/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.lists;

import com.intellij.codeInsight.intention.impl.lists.AbstractListIntentionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractChopListAction<L extends PsiElement, E extends PsiElement>
extends AbstractListIntentionAction<L, E> {
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        Context<L, E> context = this.from(element);
        return context != null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        Context<L, E> context = this.from(element);
        if (context == null) {
            return;
        }
        Document document = editor.getDocument();
        List elements = context.elements;
        int size = elements.size();
        for (int i = elements.size() - 1; i >= 0; --i) {
            PsiElement el = (PsiElement)elements.get(i);
            if (this.nextBreak(el) != null) continue;
            int offset = this.findOffsetForBreakAfter(el);
            if (i == size - 1 && !this.needTailBreak(el)) continue;
            document.insertString(offset, (CharSequence)"\n");
        }
        PsiElement first = (PsiElement)elements.get(0);
        if (this.needHeadBreak(first)) {
            document.insertString(this.findOffsetOfBreakBeforeFirst(first), (CharSequence)"\n");
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        documentManager.commitDocument(document);
        CodeStyleManager.getInstance((Project)project).adjustLineIndent(context.list.getContainingFile(), context.list.getParent().getTextRange());
    }

    abstract int findOffsetForBreakAfter(E var1);

    protected int findOffsetOfBreakBeforeFirst(@NotNull E element) {
        return element.getTextRange().getStartOffset();
    }

    protected boolean canChop(List<E> elements) {
        return true;
    }

    @Nullable
    Context<L, E> from(@NotNull PsiElement element) {
        Object list = this.extractList(element);
        if (list == null) {
            return null;
        }
        List elements = this.getElements(list);
        if (elements == null) {
            return null;
        }
        if (elements.size() < this.minElementCount()) {
            return null;
        }
        if (!this.canChop(elements)) {
            return null;
        }
        if (!this.hasElementsNotOnSeparateLines(elements)) {
            return null;
        }
        return new Context((PsiElement)list, elements, null);
    }

    @Contract(pure=true)
    private boolean hasElementsNotOnSeparateLines(@NotNull List<E> elements) {
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            PsiElement current = (PsiElement)elements.get(i);
            if (i == 0 && this.needHeadBreak(current) && this.prevBreak(current) == null) {
                return true;
            }
            if (this.nextBreak(current) != null || i == size - 1 && !this.needTailBreak(current)) continue;
            return true;
        }
        return false;
    }

    private static class Context<L extends PsiElement, E extends PsiElement> {
        @NotNull
        final L list;
        @NotNull
        final List<E> elements;

        private Context(@NotNull L list, @NotNull List<E> elements) {
            this.list = list;
            this.elements = elements;
        }

        /* synthetic */ Context(PsiElement x0, List x1, 1 x2) {
            this(x0, x1);
        }
    }
}

