/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import java.util.ArrayList;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SplitSwitchBranchWithSeveralCaseValuesAction
extends PsiElementBaseIntentionAction {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        return JavaBundle.message((String)"intention.split.switch.branch.with.several.case.values.family", (Object[])new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiStatement body2;
        PsiSwitchLabelStatementBase labelStatement = SplitSwitchBranchWithSeveralCaseValuesAction.findLabelStatement(editor, element);
        if (labelStatement == null || labelStatement.getEnclosingSwitchBlock() == null) {
            return false;
        }
        if (labelStatement instanceof PsiSwitchLabelStatement) {
            PsiSwitchLabelStatement lastSiblingLabel;
            if (SplitSwitchBranchWithSeveralCaseValuesAction.isMultiValueCase(labelStatement)) {
                if (SplitSwitchBranchWithSeveralCaseValuesAction.isAvailableForLabel(labelStatement)) {
                    this.setText(JavaBundle.message((String)"intention.split.switch.branch.with.several.case.values.split.text", (Object[])new Object[0]));
                    return true;
                }
            } else if (SplitSwitchBranchWithSeveralCaseValuesAction.hasSiblingLabel(labelStatement) && SplitSwitchBranchWithSeveralCaseValuesAction.isAvailableForLabel((PsiSwitchLabelStatementBase)(lastSiblingLabel = SplitSwitchBranchWithSeveralCaseValuesAction.findLastSiblingLabel((PsiStatement)labelStatement, false)))) {
                this.setText(JavaBundle.message((String)"intention.split.switch.branch.with.several.case.values.copy.text", (Object[])new Object[0]));
                return true;
            }
        } else if (labelStatement instanceof PsiSwitchLabeledRuleStatement && SplitSwitchBranchWithSeveralCaseValuesAction.isMultiValueCase(labelStatement) && (body2 = ((PsiSwitchLabeledRuleStatement)labelStatement).getBody()) != null && element.getTextOffset() < body2.getTextOffset()) {
            this.setText(JavaBundle.message((String)"intention.split.switch.branch.with.several.case.values.split.text", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private static boolean isAvailableForLabel(@Nullable PsiSwitchLabelStatementBase label) {
        PsiStatement lastStatement = SplitSwitchBranchWithSeveralCaseValuesAction.findLastStatementInBranch((PsiElement)label);
        return lastStatement != null && (!ControlFlowUtils.statementMayCompleteNormally(lastStatement) || PsiTreeUtil.getNextSiblingOfType((PsiElement)lastStatement, PsiSwitchLabelStatement.class) == null);
    }

    private static boolean isMultiValueCase(@NotNull PsiSwitchLabelStatementBase label) {
        PsiExpressionList caseValues2 = label.getCaseValues();
        return caseValues2 != null && caseValues2.getExpressionCount() > 1;
    }

    private static boolean hasSiblingLabel(@Nullable PsiSwitchLabelStatementBase label) {
        return PsiTreeUtil.getPrevSiblingOfType((PsiElement)label, PsiStatement.class) instanceof PsiSwitchLabelStatement || PsiTreeUtil.getNextSiblingOfType((PsiElement)label, PsiStatement.class) instanceof PsiSwitchLabelStatement;
    }

    @Nullable
    private static PsiElement getPreviousElement(@NotNull Editor editor, @NotNull PsiElement element) {
        int elementOffset;
        PsiFile file = element.getContainingFile();
        int caretOffset = editor.getCaretModel().getOffset();
        if (caretOffset == (elementOffset = element.getTextRange().getStartOffset()) && caretOffset > 0) {
            return file.findElementAt(caretOffset - 1);
        }
        return null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiSwitchLabeledRuleStatement labeledRule;
        PsiExpressionList caseValues2;
        PsiSwitchLabelStatementBase statement = SplitSwitchBranchWithSeveralCaseValuesAction.findLabelStatement(editor, element);
        PsiElement result = null;
        if (statement instanceof PsiSwitchLabelStatement) {
            PsiSwitchLabelStatement labelStatement = (PsiSwitchLabelStatement)statement;
            PsiExpressionList caseValues3 = labelStatement.getCaseValues();
            if (caseValues3 != null && caseValues3.getExpressionCount() > 1) {
                PsiExpression caseValue = SplitSwitchBranchWithSeveralCaseValuesAction.findCaseValue(element, caseValues3, editor);
                Branch branch = Branch.fromLabel(labelStatement);
                if (branch != null) {
                    result = SplitSwitchBranchWithSeveralCaseValuesAction.isInList(caseValue, caseValues3) ? SplitSwitchBranchWithSeveralCaseValuesAction.moveLabelValueAfter(labelStatement, caseValue) : SplitSwitchBranchWithSeveralCaseValuesAction.splitLabelValues(labelStatement);
                }
            } else {
                PsiSwitchLabelStatement lastSiblingLabel = SplitSwitchBranchWithSeveralCaseValuesAction.findLastSiblingLabel((PsiStatement)labelStatement, true);
                if (lastSiblingLabel != null) {
                    result = SplitSwitchBranchWithSeveralCaseValuesAction.moveLabelAfter(labelStatement, lastSiblingLabel);
                } else {
                    PsiStatement previousSibling = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)statement, PsiStatement.class);
                    if (previousSibling instanceof PsiSwitchLabelStatement) {
                        result = SplitSwitchBranchWithSeveralCaseValuesAction.copyLabelTo(labelStatement, (PsiSwitchLabelStatement)previousSibling);
                    }
                }
            }
        } else if (statement instanceof PsiSwitchLabeledRuleStatement && (caseValues2 = (labeledRule = (PsiSwitchLabeledRuleStatement)statement).getCaseValues()) != null) {
            PsiExpression caseValue = SplitSwitchBranchWithSeveralCaseValuesAction.findCaseValue(element, caseValues2, editor);
            result = SplitSwitchBranchWithSeveralCaseValuesAction.isInList(caseValue, caseValues2) ? SplitSwitchBranchWithSeveralCaseValuesAction.moveRuleAfter(caseValue, labeledRule) : SplitSwitchBranchWithSeveralCaseValuesAction.splitRule(caseValues2, labeledRule);
        }
        if (result != null) {
            editor.getCaretModel().moveToOffset(result.getTextOffset());
        }
    }

    private static PsiExpression findCaseValue(@NotNull PsiElement element, @NotNull PsiExpressionList caseValues2, @NotNull Editor editor) {
        PsiExpression caseValue = (PsiExpression)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PsiExpression.class});
        if (!SplitSwitchBranchWithSeveralCaseValuesAction.isInList(caseValue, caseValues2)) {
            PsiElement previousElement = SplitSwitchBranchWithSeveralCaseValuesAction.getPreviousElement(editor, element);
            caseValue = (PsiExpression)PsiTreeUtil.getNonStrictParentOfType((PsiElement)previousElement, (Class[])new Class[]{PsiExpression.class});
        }
        while (caseValue != null && caseValue.getParent() instanceof PsiExpression) {
            caseValue = (PsiExpression)caseValue.getParent();
        }
        return caseValue;
    }

    @Contract(value="null,_ -> false")
    private static boolean isInList(@Nullable PsiExpression caseValue, @NotNull PsiExpressionList caseValues2) {
        return caseValue != null && PsiTreeUtil.isAncestor((PsiElement)caseValues2, (PsiElement)caseValue, (boolean)true);
    }

    @Nullable
    private static PsiSwitchLabelStatementBase findLabelStatement(@NotNull Editor editor, @NotNull PsiElement element) {
        PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiStatement.class);
        if (statement instanceof PsiSwitchLabelStatementBase) {
            return (PsiSwitchLabelStatementBase)statement;
        }
        PsiElement previousElement = SplitSwitchBranchWithSeveralCaseValuesAction.getPreviousElement(editor, element);
        statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)previousElement, PsiStatement.class);
        return (PsiSwitchLabelStatementBase)ObjectUtils.tryCast((Object)statement, PsiSwitchLabelStatementBase.class);
    }

    private static PsiElement moveLabelAfter(@NotNull PsiSwitchLabelStatement labelToMove, @NotNull PsiSwitchLabelStatement anchor) {
        Branch branch = Branch.fromLabel(anchor);
        if (branch == null) {
            return null;
        }
        return branch.moveAfter(labelToMove);
    }

    private static PsiElement copyLabelTo(@NotNull PsiSwitchLabelStatement labelToCopyFrom, @NotNull PsiSwitchLabelStatement anchor) {
        Branch branch = Branch.fromLabel(labelToCopyFrom);
        if (branch == null) {
            return null;
        }
        return branch.copyTo(anchor);
    }

    @Nullable
    private static PsiElement moveLabelValueAfter(@NotNull PsiSwitchLabelStatement labelStatement, @NotNull PsiExpression caseValue) {
        Branch branch = Branch.fromLabel(labelStatement);
        if (branch == null) {
            return null;
        }
        PsiSwitchLabelStatement newLabel = branch.addLabelAfter(caseValue);
        caseValue.delete();
        return branch.copyTo(newLabel);
    }

    @Nullable
    private static PsiElement splitLabelValues(@NotNull PsiSwitchLabelStatement labelStatement) {
        Branch branch = Branch.fromLabel(labelStatement);
        if (branch == null) {
            return null;
        }
        ArrayList<PsiSwitchLabelStatement> newLabels = new ArrayList<PsiSwitchLabelStatement>();
        PsiExpression[] expressions2 = Objects.requireNonNull(labelStatement.getCaseValues()).getExpressions();
        for (int i = expressions2.length - 1; i >= 1; --i) {
            PsiExpression caseValue = expressions2[i];
            PsiSwitchLabelStatement newLabel = branch.addLabelAfter(caseValue);
            newLabels.add(newLabel);
            caseValue.delete();
        }
        for (PsiSwitchLabelStatement newLabel : newLabels) {
            branch.copyTo(newLabel);
        }
        return !newLabels.isEmpty() ? (PsiElement)newLabels.get(0) : null;
    }

    private static PsiSwitchLabeledRuleStatement moveRuleAfter(@NotNull PsiExpression caseValue, @NotNull PsiSwitchLabeledRuleStatement labeledRule) {
        Project project = labeledRule.getProject();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiSwitchLabeledRuleStatement newRule = (PsiSwitchLabeledRuleStatement)factory.createStatementFromText("case 1->{}", null);
        Objects.requireNonNull(newRule.getCaseValues()).getExpressions()[0].replace((PsiElement)caseValue);
        newRule = (PsiSwitchLabeledRuleStatement)labeledRule.getParent().addAfter((PsiElement)newRule, (PsiElement)labeledRule);
        newRule = (PsiSwitchLabeledRuleStatement)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)newRule);
        Objects.requireNonNull(newRule.getBody()).replace((PsiElement)Objects.requireNonNull(labeledRule.getBody()));
        caseValue.delete();
        return newRule;
    }

    private static PsiSwitchLabeledRuleStatement splitRule(@NotNull PsiExpressionList caseValues2, @NotNull PsiSwitchLabeledRuleStatement labeledRule) {
        PsiExpression[] expressions2 = caseValues2.getExpressions();
        PsiSwitchLabeledRuleStatement anchor = labeledRule;
        for (int i = 1; i < expressions2.length; ++i) {
            anchor = SplitSwitchBranchWithSeveralCaseValuesAction.moveRuleAfter(expressions2[i], anchor);
        }
        return anchor;
    }

    @Contract(value="null -> null")
    @Nullable
    static PsiStatement findLastStatementInBranch(@Nullable PsiElement label) {
        PsiStatement lastStatement = null;
        PsiStatement statement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)label, PsiStatement.class);
        while (statement != null && !(statement instanceof PsiSwitchLabelStatement)) {
            lastStatement = statement;
            statement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, PsiStatement.class);
        }
        return lastStatement;
    }

    @Nullable
    private static PsiSwitchLabelStatement findLastSiblingLabel(@Nullable PsiStatement statement, boolean strict) {
        PsiStatement start;
        PsiSwitchLabelStatement result = null;
        PsiStatement next = start = strict ? (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, PsiStatement.class) : statement;
        while (next instanceof PsiSwitchLabelStatement) {
            result = (PsiSwitchLabelStatement)next;
            next = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)next, PsiStatement.class);
        }
        return result;
    }

    private static class Branch {
        private final PsiElement myFirstElement;
        private final PsiStatement myLastStatement;
        private final PsiCodeBlock myCodeBlock;
        private final PsiElement myLBrace;

        private Branch(@NotNull PsiElement firstElement, @NotNull PsiStatement lastStatement, @NotNull PsiCodeBlock codeBlock, @NotNull PsiElement lBrace) {
            this.myFirstElement = firstElement;
            this.myLastStatement = lastStatement;
            this.myCodeBlock = codeBlock;
            this.myLBrace = lBrace;
        }

        @Nullable
        static Branch fromLabel(@NotNull PsiSwitchLabelStatement label) {
            PsiCodeBlock codeBlock = (PsiCodeBlock)ObjectUtils.tryCast((Object)label.getParent(), PsiCodeBlock.class);
            if (codeBlock == null) {
                return null;
            }
            PsiJavaToken lBrace = codeBlock.getLBrace();
            PsiJavaToken rBrace = codeBlock.getRBrace();
            if (lBrace == null || rBrace == null) {
                return null;
            }
            PsiElement firstElement = label.getNextSibling();
            if (!Branch.isInBranch(firstElement, (PsiElement)rBrace)) {
                return null;
            }
            PsiStatement firstStatement = firstElement instanceof PsiStatement ? (PsiStatement)firstElement : (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)firstElement, PsiStatement.class);
            PsiStatement lastStatement = null;
            PsiStatement next = firstStatement;
            while (Branch.isInBranch((PsiElement)next, (PsiElement)rBrace)) {
                lastStatement = next;
                next = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)next, PsiStatement.class);
            }
            if (lastStatement == null) {
                return null;
            }
            return new Branch(firstElement, lastStatement, codeBlock, (PsiElement)lBrace);
        }

        @Contract(value="null,_ -> false")
        private static boolean isInBranch(@Nullable PsiElement element, @NotNull PsiElement rBrace) {
            return element != null && element != rBrace && !(element instanceof PsiSwitchLabelStatement);
        }

        PsiElement moveAfter(@NotNull PsiSwitchLabelStatement labelToMove) {
            PsiSwitchLabelStatement previousLabel = (PsiSwitchLabelStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)this.myFirstElement, PsiSwitchLabelStatement.class);
            PsiElement labelCopy = this.myCodeBlock.addAfter((PsiElement)labelToMove, (PsiElement)this.myLastStatement);
            this.myCodeBlock.addRangeAfter(this.myFirstElement, (PsiElement)this.myLastStatement, labelCopy);
            this.addBreakIfNeeded((PsiElement)previousLabel);
            PsiElement prefixStart = null;
            PsiElement prefixEnd = null;
            for (PsiElement previous = labelToMove.getPrevSibling(); previous != null && previous != this.myLBrace && !(previous instanceof PsiStatement); previous = previous.getPrevSibling()) {
                prefixStart = previous;
                if (prefixEnd != null) continue;
                prefixEnd = previous;
            }
            if (prefixStart != null) {
                this.myCodeBlock.addRangeBefore(prefixStart, prefixEnd, labelCopy);
                this.myCodeBlock.deleteChildRange(prefixStart, (PsiElement)labelToMove);
            } else {
                labelToMove.delete();
            }
            return labelCopy;
        }

        PsiSwitchLabelStatement copyTo(@NotNull PsiSwitchLabelStatement anchor) {
            this.myCodeBlock.addRangeAfter(this.myFirstElement, (PsiElement)this.myLastStatement, (PsiElement)anchor);
            this.addBreakIfNeeded((PsiElement)anchor);
            return anchor;
        }

        @NotNull
        PsiSwitchLabelStatement addLabelAfter(@NotNull PsiExpression caseValue) {
            Project project = this.myCodeBlock.getProject();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiSwitchLabelStatement newLabel = (PsiSwitchLabelStatement)factory.createStatementFromText("case 1:", null);
            Objects.requireNonNull(newLabel.getCaseValues()).getExpressions()[0].replace((PsiElement)caseValue);
            newLabel = (PsiSwitchLabelStatement)this.myCodeBlock.addAfter((PsiElement)newLabel, (PsiElement)this.myLastStatement);
            newLabel = (PsiSwitchLabelStatement)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)newLabel);
            return newLabel;
        }

        private void addBreakIfNeeded(@Nullable PsiElement label) {
            PsiStatement lastStatementInBranch = SplitSwitchBranchWithSeveralCaseValuesAction.findLastStatementInBranch(label);
            if (lastStatementInBranch != null && ControlFlowUtils.statementMayCompleteNormally(lastStatementInBranch)) {
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)lastStatementInBranch.getProject());
                PsiStatement breakStatement = factory.createStatementFromText("break;", null);
                this.myCodeBlock.addAfter((PsiElement)breakStatement, (PsiElement)lastStatementInBranch);
            }
        }
    }
}

