/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInsight.intention.impl.ImplementAbstractMethodHandler;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorActivityManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImplementAbstractMethodAction
extends BaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        return JavaBundle.message((String)"intention.implement.abstract.method.family", (Object[])new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        int offset = editor.getCaretModel().getOffset();
        PsiMethod method = ImplementAbstractMethodAction.findMethod(file, offset);
        if (method == null || !method.isValid() || method.isConstructor()) {
            return false;
        }
        this.setText(this.getIntentionName(method));
        if (!ImplementAbstractMethodAction.canModify((PsiElement)method)) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        boolean isAbstract = method.hasModifierProperty("abstract");
        if (isAbstract || !method.hasModifierProperty("private") && !method.hasModifierProperty("static")) {
            if (!isAbstract && !ImplementAbstractMethodAction.isOnIdentifier(file, offset)) {
                return false;
            }
            MyElementProcessor processor2 = new MyElementProcessor(method);
            if (containingClass.isEnum()) {
                for (PsiField field : containingClass.getFields()) {
                    if (!(field instanceof PsiEnumConstant)) continue;
                    PsiEnumConstantInitializer initializingClass2 = ((PsiEnumConstant)field).getInitializingClass();
                    if (initializingClass2 == null) {
                        processor2.myHasMissingImplementations = true;
                        continue;
                    }
                    if (!processor2.execute((PsiClass)initializingClass2)) break;
                }
            }
            ClassInheritorsSearch.search((PsiClass)containingClass, (boolean)false).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)processor2));
            return this.isAvailable(processor2);
        }
        return false;
    }

    private static boolean isOnIdentifier(PsiFile file, int offset) {
        PsiElement psiElement = file.findElementAt(offset);
        return psiElement instanceof PsiIdentifier && psiElement.getParent() instanceof PsiMethod;
    }

    protected String getIntentionName(PsiMethod method) {
        return method.hasModifierProperty("abstract") ? JavaBundle.message((String)"intention.implement.abstract.method.text", (Object[])new Object[]{method.getName()}) : JavaBundle.message((String)"intention.override.method.text", (Object[])new Object[]{method.getName()});
    }

    protected boolean isAvailable(MyElementProcessor processor2) {
        return processor2.hasMissingImplementations();
    }

    @Nullable
    static PsiMethod findExistingImplementation(PsiClass aClass, PsiMethod method) {
        PsiMethod[] methods;
        for (PsiMethod candidate : methods = aClass.findMethodsByName(method.getName(), false)) {
            PsiMethod[] superMethods;
            for (PsiMethod superMethod : superMethods = candidate.findSuperMethods(false)) {
                if (!superMethod.equals(method)) continue;
                return candidate;
            }
        }
        return null;
    }

    private static PsiMethod findMethod(PsiFile file, int offset) {
        PsiMethod method = ImplementAbstractMethodAction._findMethod(file, offset);
        if (method == null) {
            method = ImplementAbstractMethodAction._findMethod(file, offset - 1);
        }
        return method;
    }

    private static PsiMethod _findMethod(PsiFile file, int offset) {
        return (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(offset), PsiMethod.class);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiMethod method = ImplementAbstractMethodAction.findMethod(file, editor.getCaretModel().getOffset());
        if (method == null) {
            return;
        }
        if (EditorActivityManager.getInstance().isVisible(editor)) {
            this.invokeHandler(project, editor, method);
        }
    }

    protected void invokeHandler(Project project, Editor editor, PsiMethod method) {
        new ImplementAbstractMethodHandler(project, editor, method).invoke();
    }

    public boolean startInWriteAction() {
        return false;
    }

    static class MyElementProcessor
    implements PsiElementProcessor<PsiClass> {
        private boolean myHasMissingImplementations;
        private boolean myHasExistingImplementations;
        private final PsiMethod myMethod;

        MyElementProcessor(PsiMethod method) {
            this.myMethod = method;
        }

        public boolean hasMissingImplementations() {
            return this.myHasMissingImplementations;
        }

        public boolean hasExistingImplementations() {
            return this.myHasExistingImplementations;
        }

        public boolean execute(@NotNull PsiClass element) {
            PsiMethod existingImplementation = ImplementAbstractMethodAction.findExistingImplementation(element, this.myMethod);
            if (existingImplementation != null && !existingImplementation.hasModifierProperty("abstract")) {
                this.myHasExistingImplementations = true;
            } else if (existingImplementation == null) {
                this.myHasMissingImplementations = true;
            }
            return !this.myHasMissingImplementations || !this.myHasExistingImplementations;
        }
    }
}

