/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.generation.RecordConstructorMember;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ConvertCompactConstructorToCanonicalAction
extends PsiElementBaseIntentionAction {
    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiMethod method = ConvertCompactConstructorToCanonicalAction.getMethod(element);
        if (method == null) {
            return;
        }
        PsiClass recordClass = method.getContainingClass();
        if (recordClass == null) {
            return;
        }
        PsiMethod prototype = new RecordConstructorMember(recordClass, false).generateRecordConstructor();
        PsiModifierList modifierList = method.getModifierList();
        prototype.getModifierList().replace((PsiElement)modifierList);
        PsiElement beforeModifier = modifierList.getPrevSibling();
        if (beforeModifier != null) {
            prototype.addRangeBefore(method.getFirstChild(), beforeModifier, (PsiElement)prototype.getModifierList());
        }
        PsiCodeBlock oldBody = Objects.requireNonNull(method.getBody());
        PsiCodeBlock body2 = (PsiCodeBlock)Objects.requireNonNull(prototype.getBody()).replace((PsiElement)oldBody);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        for (PsiRecordComponent component : recordClass.getRecordComponents()) {
            PsiField field = JavaPsiRecordUtil.getFieldForComponent(component);
            if (field == null || HighlightControlFlowUtil.variableDefinitelyAssignedIn((PsiVariable)field, (PsiElement)body2)) continue;
            body2.add((PsiElement)factory.createStatementFromText("this." + field.getName() + "=" + field.getName() + ";", (PsiElement)body2));
        }
        int offset = editor.getCaretModel().getOffset();
        if (oldBody.getTextRange().contains(offset)) {
            offset += body2.getTextRangeInParent().getStartOffset() - oldBody.getTextRangeInParent().getStartOffset();
        }
        method.replace((PsiElement)prototype);
        editor.getCaretModel().moveToOffset(offset);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiMethod method = ConvertCompactConstructorToCanonicalAction.getMethod(element);
        return method != null && JavaPsiRecordUtil.isCompactConstructor(method) && method.getBody() != null && method.getContainingClass() != null && method.getContainingClass().isRecord();
    }

    private static PsiMethod getMethod(@NotNull PsiElement element) {
        return (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class, PsiMember.class});
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        return JavaBundle.message((String)"intention.convert.compact.constructor.to.canonical", (Object[])new Object[0]);
    }
}

