/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.TrackingEquivalenceChecker;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import com.siyeh.ig.psiutils.VariableNameGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import one.util.streamex.MoreCollectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollapseIntoLoopAction
implements IntentionAction {
    public @IntentionName @NotNull String getText() {
        return JavaBundle.message((String)"intention.name.collapse.into.loop", (Object[])new Object[0]);
    }

    @NotNull
    public @IntentionFamilyName String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return LoopModel.from(editor, file) != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        LoopModel model = LoopModel.from(editor, file);
        if (model == null) {
            return;
        }
        model.generate();
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static class LoopModel {
        @NotNull
        final List<PsiExpression> myLoopElements;
        @NotNull
        final List<PsiExpression> myExpressionsToReplace;
        @NotNull
        final List<PsiStatement> myStatements;
        final int myStatementCount;
        @Nullable
        final PsiType myType;

        private LoopModel(@NotNull List<PsiExpression> elements, @NotNull List<PsiExpression> expressionsToReplace, @NotNull List<PsiStatement> statements, int count, @Nullable PsiType type2) {
            this.myLoopElements = elements;
            this.myExpressionsToReplace = expressionsToReplace;
            this.myStatements = statements;
            this.myStatementCount = count;
            this.myType = type2;
        }

        void generate() {
            String loopDeclaration;
            String varName;
            PsiStatement context = this.myStatements.get(0);
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)context.getProject());
            if (this.myType == null) {
                int size = this.myStatements.size() / this.myStatementCount;
                varName = new VariableNameGenerator((PsiElement)context, VariableKind.PARAMETER).byType((PsiType)PsiType.INT).generate(true);
                loopDeclaration = "for(int " + varName + "=0;" + varName + "<" + size + ";" + varName + "++)";
            } else {
                varName = new VariableNameGenerator((PsiElement)context, VariableKind.PARAMETER).byType(this.myType).generate(true);
                loopDeclaration = this.tryCollapseIntoCountingLoop(varName);
                if (loopDeclaration == null) {
                    String container = this.myType instanceof PsiPrimitiveType ? "new " + this.myType.getCanonicalText() + "[]{" + StringUtil.join(this.myLoopElements, PsiElement::getText, (String)",") + "}" : "java.util.Arrays.asList(" + StringUtil.join(this.myLoopElements, PsiElement::getText, (String)",") + ")";
                    loopDeclaration = "for(" + this.myType.getCanonicalText() + " " + varName + ":" + container + ")";
                }
            }
            PsiLoopStatement loop = (PsiLoopStatement)factory.createStatementFromText(loopDeclaration + " {}", (PsiElement)context);
            PsiCodeBlock block = ((PsiBlockStatement)Objects.requireNonNull(loop.getBody())).getCodeBlock();
            PsiJavaToken brace = Objects.requireNonNull(block.getRBrace());
            PsiExpression ref = factory.createExpressionFromText(varName, (PsiElement)context);
            this.myExpressionsToReplace.forEach(expr2 -> expr2.replace((PsiElement)ref));
            block.addRangeBefore((PsiElement)this.myStatements.get(0), (PsiElement)this.myStatements.get(this.myStatementCount - 1), (PsiElement)brace);
            PsiElement origBlock = context.getParent();
            JavaCodeStyleManager.getInstance((Project)block.getProject()).shortenClassReferences(origBlock.addBefore((PsiElement)loop, (PsiElement)this.myStatements.get(0)));
            CommentTracker ct = new CommentTracker();
            this.myLoopElements.forEach(ct::markUnchanged);
            ct.delete((PsiElement[])this.myStatements.subList(this.myStatementCount, this.myStatements.size()).toArray(PsiStatement.EMPTY_ARRAY));
            ct.insertCommentsBefore((PsiElement)this.myStatements.get(0));
            origBlock.deleteChildRange((PsiElement)this.myStatements.get(0), (PsiElement)this.myStatements.get(this.myStatementCount - 1));
        }

        private String tryCollapseIntoCountingLoop(String varName) {
            if (!PsiType.INT.equals((Object)this.myType) && !PsiType.LONG.equals((Object)this.myType)) {
                return null;
            }
            Long start = null;
            Long step2 = null;
            Long last = null;
            for (PsiExpression element : this.myLoopElements) {
                if (!(element instanceof PsiLiteralExpression)) {
                    return null;
                }
                Object value2 = ((PsiLiteralExpression)element).getValue();
                if (!(value2 instanceof Integer) && !(value2 instanceof Long)) {
                    return null;
                }
                long cur = ((Number)value2).longValue();
                if (start == null) {
                    start = cur;
                } else if (step2 == null ? (step2 = Long.valueOf(cur - start)) == 0L : cur - last != step2 || step2 > 0L && cur < last || step2 < 0L && cur > last) {
                    return null;
                }
                last = cur;
            }
            if (start == null || step2 == null) {
                return null;
            }
            if (this.myLoopElements.size() == 2 && step2 != 1L && step2 != -1L) {
                return null;
            }
            PsiElement parent = this.myStatements.get(0).getParent();
            boolean mustBeEffectivelyFinal = this.myExpressionsToReplace.stream().map(ref -> (NavigatablePsiElement)PsiTreeUtil.getParentOfType((PsiElement)ref, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class})).anyMatch(ctx -> ctx != null && PsiTreeUtil.isAncestor((PsiElement)parent, (PsiElement)ctx, (boolean)false));
            if (mustBeEffectivelyFinal) {
                return null;
            }
            String suffix = PsiType.LONG.equals((Object)this.myType) ? "L" : "";
            String initial = this.myType.getCanonicalText() + " " + varName + "=" + start + suffix;
            String condition2 = varName + (step2 == 1L && last != (PsiType.LONG.equals((Object)this.myType) ? Long.MAX_VALUE : Integer.MAX_VALUE) ? "<" + (last + 1L) : (step2 == -1L && last != (PsiType.LONG.equals((Object)this.myType) ? Long.MIN_VALUE : Integer.MIN_VALUE) ? ">" + (last - 1L) : (step2 < 0L ? ">=" : "<=") + last)) + suffix;
            String increment = varName + (step2 == 1L ? "++" : (step2 == -1L ? "--" : (step2 > 0L ? "+=" + step2 + suffix : "-=" + -step2.longValue() + suffix)));
            return "for(" + initial + ";" + condition2 + ";" + increment + ")";
        }

        @NotNull
        private static List<PsiStatement> extractStatements(PsiFile file, SelectionModel model) {
            int startOffset = model.getSelectionStart();
            int endOffset = model.getSelectionEnd();
            Object[] elements = CodeInsightUtil.findStatementsInRange(file, startOffset, endOffset);
            return ((Optional)StreamEx.of((Object[])elements).map(e -> (PsiStatement)ObjectUtils.tryCast((Object)e, PsiStatement.class)).collect(MoreCollectors.ifAllMatch(LoopModel::isAllowedStatement, Collectors.toList()))).orElse(Collections.emptyList());
        }

        @NotNull
        private static List<PsiStatement> extractStatements(PsiFile file, int offset) {
            PsiElement pos = file.findElementAt(offset);
            PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)pos, PsiStatement.class, (boolean)false, (Class[])new Class[]{PsiMember.class, PsiCodeBlock.class});
            if (statement == null) {
                return Collections.emptyList();
            }
            return StreamEx.iterate((Object)statement, LoopModel::isAllowedStatement, st -> (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)st, PsiStatement.class)).toList();
        }

        @Nullable
        static LoopModel from(Editor editor, PsiFile file) {
            List<PsiStatement> statements;
            boolean mayTrimTail;
            if (!(file instanceof PsiJavaFile) || !PsiUtil.isLanguageLevel5OrHigher((PsiElement)file)) {
                return null;
            }
            SelectionModel selectionModel = editor.getSelectionModel();
            if (selectionModel.hasSelection()) {
                mayTrimTail = false;
                statements = LoopModel.extractStatements(file, selectionModel);
            } else {
                mayTrimTail = true;
                statements = LoopModel.extractStatements(file, editor.getCaretModel().getOffset());
            }
            int size = statements.size();
            if (size <= 1 || size > (mayTrimTail ? 100 : 1000)) {
                return null;
            }
            if (!(statements.get(0).getParent() instanceof PsiCodeBlock)) {
                return null;
            }
            for (int count = 1; count <= size / 2; ++count) {
                LoopModel model;
                if (!mayTrimTail && size % count != 0 || (model = LoopModel.from(statements, count, mayTrimTail)) == null) continue;
                return model;
            }
            return null;
        }

        @Nullable
        private static LoopModel from(List<PsiStatement> statements, int count, boolean mayTrimTail) {
            int size = statements.size();
            ArrayList<PsiExpression> expressionsToReplace = new ArrayList<PsiExpression>();
            ArrayList<PsiExpression> expressionsToIterate = new ArrayList<PsiExpression>();
            int offset = count;
            while (offset + count <= size) {
                if (!LoopModel.tryConsumeIteration(statements, count, offset, expressionsToReplace, expressionsToIterate)) {
                    if (mayTrimTail && offset != count) break;
                    return null;
                }
                offset += count;
            }
            statements = statements.subList(0, offset);
            PsiType type2 = expressionsToIterate.isEmpty() ? null : ((PsiExpression)expressionsToIterate.get(0)).getType();
            return new LoopModel(expressionsToIterate, expressionsToReplace, statements, count, type2);
        }

        private static boolean tryConsumeIteration(@NotNull List<PsiStatement> statements, int count, int offset, @NotNull List<PsiExpression> expressionsToReplace, @NotNull List<PsiExpression> expressionsToIterate) {
            EquivalenceChecker equivalence = EquivalenceChecker.getCanonicalPsiEquivalence();
            PsiExpression firstIterationExpression = null;
            PsiExpression curIterationExpression = null;
            boolean secondIteration = count == offset;
            int mismatchedStatements = 0;
            for (int index = 0; index < count; ++index) {
                Set usedVariables;
                PsiStatement cur;
                PsiStatement first = statements.get(index);
                EquivalenceChecker.Match match = new TrackingEquivalenceChecker().statementsMatch(first, cur = statements.get(index + offset));
                if (match.isExactMismatch()) {
                    return false;
                }
                if (match.isExactMatch()) continue;
                ++mismatchedStatements;
                PsiElement leftDiff = match.getLeftDiff();
                PsiElement rightDiff = match.getRightDiff();
                if (!(leftDiff instanceof PsiExpression) || !(rightDiff instanceof PsiExpression)) {
                    return false;
                }
                curIterationExpression = (PsiExpression)rightDiff;
                firstIterationExpression = (PsiExpression)leftDiff;
                if (PsiUtil.isAccessedForWriting((PsiExpression)curIterationExpression)) {
                    return false;
                }
                PsiType curType = curIterationExpression.getType();
                PsiType firstType = firstIterationExpression.getType();
                if (curType == null || !curType.equals(firstType)) {
                    return false;
                }
                if (secondIteration) {
                    if (!expressionsToReplace.isEmpty()) {
                        PsiExpression firstExpressionToReplace = expressionsToReplace.get(0);
                        if (!equivalence.expressionsAreEquivalent(firstExpressionToReplace, firstIterationExpression)) {
                            return false;
                        }
                        if (!firstType.equals(firstExpressionToReplace.getType())) {
                            return false;
                        }
                    }
                    expressionsToReplace.add(firstIterationExpression);
                    usedVariables = (Set)StreamEx.of((Object[])new PsiExpression[]{firstIterationExpression, curIterationExpression}).map(VariableAccessUtils::collectUsedVariables).toFlatCollection(Function.identity(), HashSet::new);
                } else {
                    if (!expressionsToReplace.contains(firstIterationExpression)) {
                        return false;
                    }
                    usedVariables = VariableAccessUtils.collectUsedVariables((PsiElement)curIterationExpression);
                }
                if (usedVariables.isEmpty() || !statements.subList(0, count).stream().anyMatch(st -> VariableAccessUtils.isAnyVariableAssigned(usedVariables, (PsiElement)st))) continue;
                return false;
            }
            if (secondIteration) {
                ContainerUtil.addIfNotNull(expressionsToIterate, firstIterationExpression);
            } else if (mismatchedStatements != expressionsToReplace.size()) {
                return false;
            }
            ContainerUtil.addIfNotNull(expressionsToIterate, curIterationExpression);
            return true;
        }

        private static boolean isAllowedStatement(PsiStatement st) {
            return st != null && !ControlFlowUtils.statementContainsNakedBreak(st) && !ControlFlowUtils.statementContainsNakedContinue(st);
        }
    }
}

