/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.surroundWith;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.generation.surroundWith.JavaWithIfExpressionSurrounder;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;

public class JavaWithIfElseExpressionSurrounder
extends JavaWithIfExpressionSurrounder {
    @Override
    public TextRange surroundExpression(Project project, Editor editor, PsiExpression expr2) throws IncorrectOperationException {
        PsiManager manager = expr2.getManager();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)manager.getProject());
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        String text2 = "if(a){\nst;\n}else{\n}";
        PsiIfStatement ifStatement = (PsiIfStatement)factory.createStatementFromText(text2, null);
        ifStatement = (PsiIfStatement)codeStyleManager.reformat((PsiElement)ifStatement);
        ifStatement.getCondition().replace((PsiElement)expr2);
        PsiExpressionStatement statement = (PsiExpressionStatement)expr2.getParent();
        ifStatement = (PsiIfStatement)statement.replace((PsiElement)ifStatement);
        PsiCodeBlock block = ((PsiBlockStatement)ifStatement.getThenBranch()).getCodeBlock();
        PsiStatement afterStatement = (PsiStatement)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)block.getStatements()[0]);
        TextRange range = afterStatement.getTextRange();
        editor.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
        return new TextRange(range.getStartOffset(), range.getStartOffset());
    }

    @Override
    public String getTemplateDescription() {
        return JavaBundle.message((String)"surround.with.ifelse.expression.template", (Object[])new Object[0]);
    }
}

