/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.surroundWith;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.generation.surroundWith.JavaExpressionSurrounder;
import com.intellij.codeInsight.guess.GuessManager;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.PsiTypeResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NonNls;

public class JavaWithCastSurrounder
extends JavaExpressionSurrounder {
    @NonNls
    private static final String TYPE_TEMPLATE_VARIABLE = "type";

    public boolean isApplicable(PsiExpression expr2) {
        return !PsiType.VOID.equals((Object)expr2.getType());
    }

    public TextRange surroundExpression(Project project, Editor editor, PsiExpression expr2) throws IncorrectOperationException {
        TextRange range;
        assert (expr2.isValid());
        PsiType[] types = GuessManager.getInstance(project).guessTypeToCast(expr2);
        boolean parenthesesNeeded = expr2 instanceof PsiPolyadicExpression || expr2 instanceof PsiConditionalExpression || expr2 instanceof PsiAssignmentExpression;
        String exprText = parenthesesNeeded ? "(" + expr2.getText() + ")" : expr2.getText();
        Template template = JavaWithCastSurrounder.generateTemplate(project, exprText, types);
        if (expr2.isPhysical()) {
            range = expr2.getTextRange();
        } else {
            RangeMarker rangeMarker = (RangeMarker)expr2.getUserData(ElementToWorkOn.TEXT_RANGE);
            if (rangeMarker == null) {
                return null;
            }
            range = new TextRange(rangeMarker.getStartOffset(), rangeMarker.getEndOffset());
        }
        editor.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
        editor.getCaretModel().moveToOffset(range.getStartOffset());
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        TemplateManager.getInstance((Project)project).startTemplate(editor, template);
        return null;
    }

    private static Template generateTemplate(Project project, String exprText, PsiType[] suggestedTypes) {
        TemplateManager templateManager = TemplateManager.getInstance((Project)project);
        Template template = templateManager.createTemplate("", "");
        template.setToReformat(true);
        LinkedHashSet<PsiTypeLookupItem> itemSet = new LinkedHashSet<PsiTypeLookupItem>();
        for (PsiType type2 : suggestedTypes) {
            itemSet.add(PsiTypeLookupItem.createLookupItem(type2, null));
        }
        PsiTypeResult result = suggestedTypes.length > 0 ? new PsiTypeResult(suggestedTypes[0], project) : null;
        ConstantNode expr2 = new ConstantNode((Result)result).withLookupItems(itemSet.size() > 1 ? itemSet : Collections.emptySet());
        template.addTextSegment("((");
        template.addVariable(TYPE_TEMPLATE_VARIABLE, (Expression)expr2, (Expression)expr2, true);
        template.addTextSegment(")" + exprText + ")");
        template.addEndVariable();
        return template;
    }

    public String getTemplateDescription() {
        return CodeInsightBundle.message((String)"surround.with.cast.template", (Object[])new Object[0]);
    }
}

