/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GenerationInfoBase
implements GenerationInfo {
    public abstract void insert(@NotNull PsiClass var1, PsiElement var2, boolean var3) throws IncorrectOperationException;

    public abstract PsiMember getPsiMember();

    @Nullable
    public PsiElement findInsertionAnchor(@NotNull PsiClass aClass, @NotNull PsiElement leaf) {
        PsiElement element = leaf;
        while (element.getParent() != aClass) {
            if ((element = element.getParent()) != null) continue;
            return null;
        }
        PsiElement lBrace = aClass.getLBrace();
        if (lBrace == null) {
            return null;
        }
        PsiElement rBrace = aClass.getRBrace();
        if (!GenerateMembersUtil.isChildInRange(element, lBrace.getNextSibling(), rBrace)) {
            return null;
        }
        if (leaf.getParent() == aClass && PsiUtilCore.getElementType((PsiElement)leaf.getPrevSibling()) == JavaTokenType.END_OF_LINE_COMMENT) {
            element = leaf.getNextSibling();
        }
        return element;
    }

    public void positionCaret(@NotNull Editor editor, boolean toEditMethodBody) {
        PsiMember member = this.getPsiMember();
        if (member != null) {
            GenerateMembersUtil.positionCaret(editor, (PsiElement)member, toEditMethodBody);
        }
    }
}

