/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.codeInsight.generation.GetterTemplatesManager;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.generation.OverrideImplementsAnnotationsHandler;
import com.intellij.codeInsight.generation.SetterTemplatesManager;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.light.LightTypeElement;
import com.intellij.psi.impl.source.codeStyle.JavaCodeStyleManagerImpl;
import com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.generate.GenerationUtil;
import org.jetbrains.java.generate.exception.GenerateCodeException;
import org.jetbrains.java.generate.template.TemplatesManager;

public class GenerateMembersUtil {
    private static final Logger LOG = Logger.getInstance(GenerateMembersUtil.class);

    private GenerateMembersUtil() {
    }

    @NotNull
    public static <T extends GenerationInfo> List<T> insertMembersAtOffset(@NotNull PsiFile file, int offset, @NotNull List<T> memberPrototypes) throws IncorrectOperationException {
        return GenerateMembersUtil.insertMembersAtOffset(file, offset, memberPrototypes, (Function<? super PsiElement, ? extends PsiClass>)((Function)leaf -> GenerateMembersUtil.findClassAtOffset(file, leaf)));
    }

    @NotNull
    public static <T extends GenerationInfo> List<T> insertMembersAtOffset(@NotNull PsiClass psiClass, int offset, @NotNull List<T> memberPrototypes) throws IncorrectOperationException {
        return GenerateMembersUtil.insertMembersAtOffset(psiClass.getContainingFile(), offset, memberPrototypes, (Function<? super PsiElement, ? extends PsiClass>)((Function)leaf -> psiClass));
    }

    @NotNull
    private static <T extends GenerationInfo> List<T> insertMembersAtOffset(@NotNull PsiFile file, int offset, @NotNull List<T> memberPrototypes, @NotNull Function<? super PsiElement, ? extends PsiClass> aClassFunction) throws IncorrectOperationException {
        PsiField field;
        PsiTypeElement typeElement;
        PsiElement element;
        if (memberPrototypes.isEmpty()) {
            return memberPrototypes;
        }
        PsiElement leaf = file.findElementAt(offset);
        if (leaf == null) {
            return Collections.emptyList();
        }
        PsiClass aClass = (PsiClass)aClassFunction.fun((Object)leaf);
        if (aClass == null) {
            return Collections.emptyList();
        }
        PsiElement anchor = ((GenerationInfo)memberPrototypes.get(0)).findInsertionAnchor(aClass, leaf);
        if (anchor instanceof PsiWhiteSpace) {
            ASTNode spaceNode = anchor.getNode();
            anchor = anchor.getNextSibling();
            assert (spaceNode != null);
            if (spaceNode.getStartOffset() <= offset && spaceNode.getStartOffset() + spaceNode.getTextLength() >= offset) {
                PsiParserFacade parserFacade;
                ASTNode singleNewLineWhitespace;
                String whiteSpace = spaceNode.getText().substring(0, offset - spaceNode.getStartOffset());
                if (!StringUtil.containsLineBreak((CharSequence)whiteSpace)) {
                    whiteSpace = whiteSpace + "\n";
                }
                if ((singleNewLineWhitespace = (parserFacade = PsiParserFacade.SERVICE.getInstance((Project)file.getProject())).createWhiteSpaceFromText(whiteSpace).getNode()) != null) {
                    spaceNode.getTreeParent().replaceChild(spaceNode, singleNewLineWhitespace);
                }
            }
        }
        for (element = anchor; !(element == null || element instanceof PsiField || element instanceof PsiMethod || element instanceof PsiClassInitializer); element = element.getNextSibling()) {
        }
        if (element instanceof PsiField && (typeElement = (field = (PsiField)element).getTypeElement()) != null && !field.equals(typeElement.getParent())) {
            field.normalizeDeclaration();
            anchor = field;
        }
        return GenerateMembersUtil.insertMembersBeforeAnchor(aClass, anchor, memberPrototypes);
    }

    @NotNull
    public static <T extends GenerationInfo> List<T> insertMembersBeforeAnchor(@NotNull PsiClass aClass, @Nullable PsiElement anchor, @NotNull List<T> memberPrototypes) throws IncorrectOperationException {
        boolean before = true;
        for (GenerationInfo memberPrototype : memberPrototypes) {
            memberPrototype.insert(aClass, anchor, before);
            before = false;
            anchor = memberPrototype.getPsiMember();
        }
        return memberPrototypes;
    }

    public static void positionCaret(@NotNull Editor editor, @NotNull PsiElement firstMember, boolean toEditMethodBody) {
        int offset;
        PsiMethod method;
        PsiCodeBlock body2;
        LOG.assertTrue(firstMember.isValid());
        Project project = firstMember.getProject();
        if (toEditMethodBody && (body2 = (method = (PsiMethod)firstMember).getBody()) != null) {
            CharSequence chars;
            PsiElement lastBodyElement;
            PsiElement firstBodyElement;
            PsiElement l = firstBodyElement = body2.getFirstBodyElement();
            while (l instanceof PsiWhiteSpace) {
                l = l.getNextSibling();
            }
            if (l == null) {
                l = body2;
            }
            PsiElement r = lastBodyElement = body2.getLastBodyElement();
            while (r instanceof PsiWhiteSpace) {
                r = r.getPrevSibling();
            }
            if (r == null) {
                r = body2;
            }
            int start = l.getTextRange().getStartOffset();
            int end = r.getTextRange().getEndOffset();
            boolean adjustLineIndent = false;
            if (start > end && firstBodyElement == lastBodyElement && firstBodyElement instanceof PsiWhiteSpaceImpl && (chars = ((PsiWhiteSpaceImpl)firstBodyElement).getChars()).length() > 1 && chars.charAt(0) == '\n' && chars.charAt(1) == '\n') {
                start = end = firstBodyElement.getTextRange().getStartOffset() + 1;
                adjustLineIndent = true;
            }
            editor.getCaretModel().moveToOffset(Math.min(start, end));
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            if (start < end) {
                editor.getSelectionModel().setSelection(start, end);
            } else if (adjustLineIndent) {
                Document document = editor.getDocument();
                RangeMarker marker = document.createRangeMarker(start, start);
                PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
                if (marker.isValid()) {
                    CodeStyleManager.getInstance((Project)project).adjustLineIndent(document, marker.getStartOffset());
                }
            }
            return;
        }
        if (firstMember instanceof PsiMethod) {
            PsiMethod method2 = (PsiMethod)firstMember;
            PsiCodeBlock body3 = method2.getBody();
            if (body3 == null) {
                offset = method2.getTextRange().getStartOffset();
            } else {
                PsiJavaToken lBrace = body3.getLBrace();
                assert (lBrace != null) : firstMember.getText();
                offset = lBrace.getTextRange().getEndOffset();
            }
        } else {
            offset = firstMember.getTextRange().getStartOffset();
        }
        editor.getCaretModel().moveToOffset(offset);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().removeSelection();
    }

    public static PsiElement insert(@NotNull PsiClass aClass, @NotNull PsiMember member, @Nullable PsiElement anchor, boolean before) throws IncorrectOperationException {
        if (member instanceof PsiMethod && !aClass.isInterface()) {
            PsiParameter[] parameters2 = ((PsiMethod)member).getParameterList().getParameters();
            boolean generateFinals = JavaCodeStyleSettings.getInstance((PsiFile)aClass.getContainingFile()).GENERATE_FINAL_PARAMETERS;
            for (PsiParameter parameter2 : parameters2) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)parameter2, (String)"final", (boolean)generateFinals);
            }
        }
        if (anchor != null) {
            return before ? aClass.addBefore((PsiElement)member, anchor) : aClass.addAfter((PsiElement)member, anchor);
        }
        return aClass.add((PsiElement)member);
    }

    @Nullable
    private static PsiClass findClassAtOffset(@NotNull PsiFile file, PsiElement leaf) {
        for (PsiElement element = leaf; element != null && !(element instanceof PsiFile); element = element.getParent()) {
            if (!(element instanceof PsiClass) || element instanceof PsiTypeParameter) continue;
            PsiClass psiClass = (PsiClass)element;
            if (psiClass.isEnum()) {
                PsiElement lastChild = null;
                for (PsiElement child = psiClass.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (child instanceof PsiJavaToken && ";".equals(child.getText())) {
                        lastChild = child;
                        break;
                    }
                    if ((!(child instanceof PsiJavaToken) || !",".equals(child.getText())) && !(child instanceof PsiEnumConstant)) continue;
                    lastChild = child;
                }
                if (lastChild != null) {
                    int adjustedOffset = lastChild.getTextRange().getEndOffset();
                    if (leaf.getTextRange().getEndOffset() <= adjustedOffset) {
                        return GenerateMembersUtil.findClassAtOffset(file, file.findElementAt(adjustedOffset));
                    }
                }
            }
            return psiClass;
        }
        return null;
    }

    @NotNull
    public static PsiMethod substituteGenericMethod(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor) {
        return GenerateMembersUtil.substituteGenericMethod(method, substitutor, null);
    }

    @NotNull
    public static PsiMethod substituteGenericMethod(@NotNull PsiMethod sourceMethod, @NotNull PsiSubstitutor substitutor, @Nullable PsiElement target) {
        Project project = sourceMethod.getProject();
        JVMElementFactory factory = GenerateMembersUtil.getFactory(sourceMethod.getProject(), target);
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        try {
            PsiMethod resultMethod = GenerateMembersUtil.createMethod(factory, sourceMethod, target);
            GenerateMembersUtil.copyModifiers(sourceMethod.getModifierList(), resultMethod.getModifierList());
            PsiSubstitutor collisionResolvedSubstitutor = GenerateMembersUtil.substituteTypeParameters(factory, target, sourceMethod.getTypeParameterList(), resultMethod.getTypeParameterList(), substitutor, sourceMethod);
            GenerateMembersUtil.substituteReturnType(PsiManager.getInstance((Project)project), resultMethod, sourceMethod.getReturnType(), collisionResolvedSubstitutor);
            PsiTypeElement typeElement = resultMethod.getReturnTypeElement();
            if (typeElement != null && typeElement.getText().startsWith("@")) {
                resultMethod = factory.createMethodFromText(resultMethod.getText(), target);
            }
            GenerateMembersUtil.substituteParameters(factory, codeStyleManager, sourceMethod.getParameterList(), resultMethod.getParameterList(), collisionResolvedSubstitutor, target);
            GenerateMembersUtil.copyDocComment(sourceMethod, resultMethod, factory);
            GlobalSearchScope scope = sourceMethod.getResolveScope();
            List<PsiClassType> thrownTypes = ExceptionUtil.collectSubstituted(collisionResolvedSubstitutor, sourceMethod.getThrowsList().getReferencedTypes(), scope);
            if (target instanceof PsiClass) {
                for (PsiMethod psiMethod : ((PsiClass)target).findMethodsBySignature(sourceMethod, true)) {
                    PsiClass aSuper;
                    if (psiMethod == null || psiMethod == sourceMethod || MethodSignatureUtil.isSuperMethod((PsiMethod)psiMethod, (PsiMethod)sourceMethod) || (aSuper = psiMethod.getContainingClass()) == null || aSuper == target) continue;
                    PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)aSuper, (PsiClass)((PsiClass)target), (PsiSubstitutor)PsiSubstitutor.EMPTY);
                    ExceptionUtil.retainExceptions(thrownTypes, ExceptionUtil.collectSubstituted(superClassSubstitutor, psiMethod.getThrowsList().getReferencedTypes(), scope));
                }
            }
            GenerateMembersUtil.substituteThrows(factory, resultMethod.getThrowsList(), collisionResolvedSubstitutor, sourceMethod, thrownTypes);
            return resultMethod;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return sourceMethod;
        }
    }

    private static void copyModifiers(@NotNull PsiModifierList sourceModifierList, @NotNull PsiModifierList targetModifierList) {
        VisibilityUtil.setVisibility((PsiModifierList)targetModifierList, (String)VisibilityUtil.getVisibilityModifier((PsiModifierList)sourceModifierList));
    }

    @NotNull
    private static PsiSubstitutor substituteTypeParameters(@NotNull JVMElementFactory factory, @Nullable PsiElement target, @Nullable PsiTypeParameterList sourceTypeParameterList, @Nullable PsiTypeParameterList targetTypeParameterList, @NotNull PsiSubstitutor substitutor, @NotNull PsiMethod sourceMethod) {
        if (sourceTypeParameterList == null || targetTypeParameterList == null || PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)sourceMethod, (PsiSubstitutor)substitutor)) {
            return substitutor;
        }
        HashMap<PsiTypeParameter, PsiClassType> substitutionMap = new HashMap<PsiTypeParameter, PsiClassType>(substitutor.getSubstitutionMap());
        for (PsiTypeParameter typeParam : sourceTypeParameterList.getTypeParameters()) {
            PsiTypeParameter substitutedTypeParam = GenerateMembersUtil.substituteTypeParameter(factory, typeParam, substitutor, sourceMethod);
            PsiTypeParameter resolvedTypeParam = GenerateMembersUtil.resolveTypeParametersCollision(factory, sourceTypeParameterList, target, substitutedTypeParam, substitutor);
            targetTypeParameterList.add((PsiElement)resolvedTypeParam);
            if (substitutedTypeParam == resolvedTypeParam) continue;
            substitutionMap.put(typeParam, factory.createType((PsiClass)resolvedTypeParam));
        }
        return substitutionMap.isEmpty() ? substitutor : factory.createSubstitutor(substitutionMap);
    }

    @NotNull
    private static PsiTypeParameter resolveTypeParametersCollision(@NotNull JVMElementFactory factory, @NotNull PsiTypeParameterList sourceTypeParameterList, @Nullable PsiElement target, @NotNull PsiTypeParameter typeParam, @NotNull PsiSubstitutor substitutor) {
        String typeParamName = typeParam.getName();
        for (PsiType type2 : substitutor.getSubstitutionMap().values()) {
            if (type2 == null || !Objects.equals(type2.getCanonicalText(), typeParamName)) continue;
            String newName = GenerateMembersUtil.suggestUniqueTypeParameterName(typeParamName, sourceTypeParameterList, (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)target, PsiClass.class, (boolean)false));
            PsiTypeParameter newTypeParameter = factory.createTypeParameter(newName, typeParam.getSuperTypes());
            substitutor.put(typeParam, (PsiType)factory.createType((PsiClass)newTypeParameter));
            return newTypeParameter;
        }
        return factory.createTypeParameter(typeParamName, typeParam.getSuperTypes());
    }

    @NotNull
    private static String suggestUniqueTypeParameterName(@NotNull String baseName, @NotNull PsiTypeParameterList typeParameterList, @Nullable PsiClass targetClass) {
        String newName;
        int i = 0;
        while (!GenerateMembersUtil.checkUniqueTypeParameterName(newName = baseName + ++i, typeParameterList) || targetClass != null && !GenerateMembersUtil.checkUniqueTypeParameterName(newName, targetClass.getTypeParameterList())) {
        }
        return newName;
    }

    private static boolean checkUniqueTypeParameterName(@NotNull String baseName, @Nullable PsiTypeParameterList typeParameterList) {
        if (typeParameterList == null) {
            return true;
        }
        for (PsiTypeParameter typeParameter : typeParameterList.getTypeParameters()) {
            if (!Objects.equals(typeParameter.getName(), baseName)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static PsiTypeParameter substituteTypeParameter(final @NotNull JVMElementFactory factory, @NotNull PsiTypeParameter typeParameter, final @NotNull PsiSubstitutor substitutor, final @NotNull PsiMethod sourceMethod) {
        PsiElement copy = ((PsiElement)ObjectUtils.notNull((Object)(typeParameter instanceof PsiCompiledElement ? ((PsiCompiledElement)typeParameter).getMirror() : typeParameter), (Object)typeParameter)).copy();
        final HashMap<PsiElement, PsiElement> replacementMap = new HashMap<PsiElement, PsiElement>();
        copy.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                super.visitReferenceElement(reference);
                PsiElement resolve2 = reference.resolve();
                if (resolve2 instanceof PsiTypeParameter) {
                    PsiClassType type2 = factory.createType((PsiClass)((PsiTypeParameter)resolve2));
                    replacementMap.put(reference, factory.createReferenceElementByType((PsiClassType)GenerateMembersUtil.substituteType(substitutor, (PsiType)type2, (PsiTypeParameterListOwner)sourceMethod)));
                }
            }
        });
        return (PsiTypeParameter)RefactoringUtil.replaceElementsWithMap(copy, replacementMap);
    }

    private static void substituteParameters(@NotNull JVMElementFactory factory, @NotNull JavaCodeStyleManager codeStyleManager, @NotNull PsiParameterList sourceParameterList, @NotNull PsiParameterList targetParameterList, @NotNull PsiSubstitutor substitutor, PsiElement target) {
        PsiParameter[] parameters2 = sourceParameterList.getParameters();
        PsiParameter[] newParameters = GenerateMembersUtil.overriddenParameters(parameters2, factory, codeStyleManager, substitutor, target);
        for (int i = 0; i < newParameters.length; ++i) {
            PsiParameter newParameter = newParameters[i];
            GenerateMembersUtil.copyOrReplaceModifierList((PsiModifierListOwner)parameters2[i], target, (PsiModifierListOwner)newParameter);
            targetParameterList.add((PsiElement)newParameter);
        }
    }

    public static PsiParameter @NotNull [] overriddenParameters(PsiParameter @NotNull [] parameters2, @NotNull JVMElementFactory factory, @NotNull JavaCodeStyleManager codeStyleManager, @NotNull PsiSubstitutor substitutor, @Nullable PsiElement target) {
        PsiParameter[] result = new PsiParameter[parameters2.length];
        UniqueNameGenerator generator = new UniqueNameGenerator();
        for (int i = 0; i < parameters2.length; ++i) {
            PsiParameter parameter2 = parameters2[i];
            PsiType parameterType = parameter2.getType();
            PsiType substituted = GenerateMembersUtil.substituteType(substitutor, parameterType, (PsiTypeParameterListOwner)((PsiMethod)parameter2.getDeclarationScope()));
            String paramName = parameter2.getName();
            boolean isBaseNameGenerated = true;
            boolean isSubstituted = substituted.equals(parameterType);
            if (!isSubstituted && GenerateMembersUtil.isBaseNameGenerated(codeStyleManager, TypeConversionUtil.erasure((PsiType)parameterType), paramName)) {
                isBaseNameGenerated = false;
            }
            if (isBaseNameGenerated && !isSubstituted && GenerateMembersUtil.isBaseNameGenerated(codeStyleManager, parameterType, paramName) || !factory.isValidParameterName(paramName)) {
                String[] names2 = codeStyleManager.suggestVariableName((VariableKind)VariableKind.PARAMETER, null, null, (PsiType)substituted).names;
                paramName = names2.length > 0 ? generator.generateUniqueName(names2[0]) : generator.generateUniqueName("p");
            } else if (!generator.value(paramName)) {
                paramName = generator.generateUniqueName(paramName);
            }
            generator.addExistingName(paramName);
            PsiType expressionType = GenericsUtil.getVariableTypeByExpressionType((PsiType)substituted);
            if (expressionType instanceof PsiArrayType && substituted instanceof PsiEllipsisType) {
                expressionType = new PsiEllipsisType(((PsiArrayType)expressionType).getComponentType()).annotate(expressionType.getAnnotationProvider());
            }
            result[i] = factory.createParameter(paramName, expressionType, target);
        }
        return result;
    }

    private static void substituteThrows(@NotNull JVMElementFactory factory, @NotNull PsiReferenceList targetThrowsList, @NotNull PsiSubstitutor substitutor, @NotNull PsiMethod sourceMethod, @NotNull List<? extends PsiClassType> thrownTypes) {
        for (PsiClassType psiClassType : thrownTypes) {
            targetThrowsList.add(factory.createReferenceElementByType((PsiClassType)GenerateMembersUtil.substituteType(substitutor, (PsiType)psiClassType, (PsiTypeParameterListOwner)sourceMethod)));
        }
    }

    private static void copyDocComment(@NotNull PsiMethod source, @NotNull PsiMethod target, @NotNull JVMElementFactory factory) {
        PsiDocComment docComment;
        PsiElement navigationElement = source.getNavigationElement();
        if (navigationElement instanceof PsiDocCommentOwner && (docComment = ((PsiDocCommentOwner)navigationElement).getDocComment()) != null) {
            target.addAfter((PsiElement)factory.createDocCommentFromText(docComment.getText()), null);
        }
        PsiParameter[] sourceParameters = source.getParameterList().getParameters();
        PsiParameterList targetParameterList = target.getParameterList();
        RefactoringUtil.fixJavadocsForParams(target, ContainerUtil.set((Object[])targetParameterList.getParameters()), (Condition<? super Pair<PsiParameter, String>>)((Condition)pair2 -> {
            int parameterIndex = targetParameterList.getParameterIndex((PsiParameter)pair2.first);
            if (parameterIndex >= 0 && parameterIndex < sourceParameters.length) {
                return Comparing.strEqual((String)((String)pair2.second), (String)sourceParameters[parameterIndex].getName());
            }
            return false;
        }));
    }

    @NotNull
    private static PsiMethod createMethod(@NotNull JVMElementFactory factory, @NotNull PsiMethod method, PsiElement target) {
        if (method.isConstructor()) {
            return factory.createConstructor(method.getName(), target);
        }
        return factory.createMethod(method.getName(), (PsiType)PsiType.VOID, target);
    }

    private static void substituteReturnType(@NotNull PsiManager manager, @NotNull PsiMethod method, @Nullable PsiType returnType, @NotNull PsiSubstitutor substitutor) {
        PsiTypeElement returnTypeElement = method.getReturnTypeElement();
        if (returnTypeElement == null || returnType == null) {
            return;
        }
        PsiType substitutedReturnType = GenerateMembersUtil.substituteType(substitutor, returnType, (PsiTypeParameterListOwner)method);
        returnTypeElement.replace((PsiElement)new LightTypeElement(manager, substitutedReturnType instanceof PsiWildcardType ? TypeConversionUtil.erasure((PsiType)substitutedReturnType) : substitutedReturnType));
    }

    @NotNull
    private static JVMElementFactory getFactory(@NotNull Project p, @Nullable PsiElement target) {
        return target == null ? JavaPsiFacade.getElementFactory((Project)p) : JVMElementFactories.requireFactory((Language)target.getLanguage(), (Project)p);
    }

    private static boolean isBaseNameGenerated(@NotNull JavaCodeStyleManager csManager, @NotNull PsiType parameterType, @NotNull String paramName) {
        if (Arrays.asList(csManager.suggestVariableName((VariableKind)VariableKind.PARAMETER, null, null, (PsiType)parameterType).names).contains(paramName)) {
            return true;
        }
        String typeName = JavaCodeStyleManagerImpl.getTypeName(parameterType);
        return typeName != null && NameUtil.getSuggestionsByName((String)typeName, (String)"", (String)"", (boolean)false, (boolean)false, (boolean)(parameterType instanceof PsiArrayType)).contains(paramName);
    }

    private static PsiType substituteType(PsiSubstitutor substitutor, PsiType type2, @NotNull PsiTypeParameterListOwner owner2) {
        if (PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)owner2, (PsiSubstitutor)substitutor)) {
            return TypeConversionUtil.erasure((PsiType)type2);
        }
        return GenericsUtil.eliminateWildcards((PsiType)substitutor.substitute(type2), (boolean)false, (boolean)true);
    }

    public static boolean isChildInRange(PsiElement child, PsiElement first, PsiElement last) {
        if (child.equals(first)) {
            return true;
        }
        do {
            if (child.equals(first)) {
                return false;
            }
            if (!child.equals(last)) continue;
            return true;
        } while ((child = child.getNextSibling()) != null);
        return false;
    }

    public static void setupGeneratedMethod(PsiMethod method) {
        PsiClass containingClass = method.getContainingClass();
        PsiClass base = containingClass == null ? null : containingClass.getSuperClass();
        PsiMethod overridden = base == null ? null : base.findMethodBySignature(method, true);
        boolean emptyTemplate = true;
        PsiCodeBlock body2 = method.getBody();
        if (body2 != null) {
            PsiJavaToken lBrace = body2.getLBrace();
            int left = lBrace != null ? lBrace.getStartOffsetInParent() + 1 : 0;
            PsiJavaToken rBrace = body2.getRBrace();
            int right = rBrace != null ? rBrace.getStartOffsetInParent() : body2.getTextLength();
            emptyTemplate = StringUtil.isEmptyOrSpaces((String)body2.getText().substring(left, right));
        }
        if (overridden == null) {
            if (emptyTemplate) {
                CreateFromUsageUtils.setupMethodBody(method, containingClass);
            }
            return;
        }
        PsiSubstitutor classSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)base, (PsiClass)containingClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)method.getProject());
        String throwsList = Arrays.stream(overridden.getThrowsList().getReferencedTypes()).map(arg_0 -> ((PsiSubstitutor)classSubstitutor).substitute(arg_0)).filter(Objects::nonNull).map(type2 -> type2.getCanonicalText()).collect(Collectors.joining(", "));
        if (throwsList.isEmpty()) {
            method.getThrowsList().delete();
        } else {
            method.getThrowsList().replace((PsiElement)factory.createMethodFromText("void m() throws " + throwsList + ";", (PsiElement)method).getThrowsList());
        }
        if (emptyTemplate) {
            OverrideImplementUtil.setupMethodBody(method, overridden, containingClass);
        }
        OverrideImplementUtil.annotateOnOverrideImplement(method, base, overridden);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2017.2")
    public static void copyOrReplaceModifierList(@NotNull PsiModifierListOwner sourceParam, @NotNull PsiModifierListOwner targetParam) {
        GenerateMembersUtil.copyOrReplaceModifierList(sourceParam, null, targetParam);
    }

    public static void copyOrReplaceModifierList(@NotNull PsiModifierListOwner sourceParam, @Nullable PsiElement targetClass, @NotNull PsiModifierListOwner targetParam) {
        PsiModifierList sourceModifierList = sourceParam.getModifierList();
        PsiModifierList targetModifierList = targetParam.getModifierList();
        if (sourceModifierList != null && targetModifierList != null) {
            for (String m : PsiModifier.MODIFIERS) {
                targetModifierList.setModifierProperty(m, sourceParam.hasModifierProperty(m));
            }
            OverrideImplementsAnnotationsHandler.repeatAnnotationsFromSource(sourceParam, targetClass, targetParam);
        }
    }

    public static void copyAnnotations(@NotNull PsiModifierList source, @NotNull PsiModifierList target, String ... skipAnnotations) {
        for (PsiAnnotation annotation : source.getAnnotations()) {
            PsiClass newClass;
            String qualifiedName;
            PsiClass oldClass;
            PsiJavaCodeReferenceElement ref = annotation.getNameReferenceElement();
            if (ref == null || (oldClass = (PsiClass)ObjectUtils.tryCast((Object)ref.resolve(), PsiClass.class)) == null || (qualifiedName = oldClass.getQualifiedName()) == null || ArrayUtil.contains((String)qualifiedName, (String[])skipAnnotations) || target.hasAnnotation(qualifiedName) || (newClass = JavaPsiFacade.getInstance((Project)target.getProject()).findClass(qualifiedName, target.getResolveScope())) == null || !oldClass.getManager().areElementsEquivalent((PsiElement)oldClass, (PsiElement)newClass)) continue;
            AddAnnotationPsiFix.addPhysicalAnnotationIfAbsent(qualifiedName, annotation.getParameterList().getAttributes(), (PsiAnnotationOwner)target);
        }
    }

    public static void copyAnnotations(@NotNull PsiModifierListOwner source, @NotNull PsiModifierListOwner target, String ... skipAnnotations) {
        PsiModifierList targetModifierList = target.getModifierList();
        PsiModifierList sourceModifierList = source.getModifierList();
        if (targetModifierList == null || sourceModifierList == null) {
            return;
        }
        GenerateMembersUtil.copyAnnotations(sourceModifierList, targetModifierList, skipAnnotations);
    }

    public static PsiMethod generateSimpleGetterPrototype(@NotNull PsiField field) {
        return GenerateMembersUtil.generatePrototype(field, PropertyUtilBase.generateGetterPrototype((PsiField)field));
    }

    public static PsiMethod generateSimpleSetterPrototype(@NotNull PsiField field) {
        return GenerateMembersUtil.generatePrototype(field, PropertyUtilBase.generateSetterPrototype((PsiField)field));
    }

    public static PsiMethod generateSimpleSetterPrototype(PsiField field, PsiClass targetClass) {
        return GenerateMembersUtil.generatePrototype(field, PropertyUtilBase.generateSetterPrototype((PsiField)field, (PsiClass)targetClass));
    }

    @NotNull
    public static String suggestGetterName(PsiField field) {
        return GenerateMembersUtil.generateGetterPrototype(field).getName();
    }

    @NotNull
    public static String suggestGetterName(String name2, PsiType type2, Project project) {
        if (type2 instanceof PsiEllipsisType) {
            type2 = ((PsiEllipsisType)type2).toArrayType();
        }
        return GenerateMembersUtil.suggestGetterName(JavaPsiFacade.getElementFactory((Project)project).createField(name2, type2));
    }

    @NotNull
    public static String suggestSetterName(PsiField field) {
        return GenerateMembersUtil.generateSetterPrototype(field).getName();
    }

    @NotNull
    public static String suggestSetterName(String name2, PsiType type2, Project project) {
        if (type2 instanceof PsiEllipsisType) {
            type2 = ((PsiEllipsisType)type2).toArrayType();
        }
        return GenerateMembersUtil.suggestSetterName(JavaPsiFacade.getElementFactory((Project)project).createField(name2, type2));
    }

    @NotNull
    public static PsiMethod generateGetterPrototype(@NotNull PsiField field) {
        return GenerateMembersUtil.generateGetterPrototype(field, true);
    }

    @NotNull
    public static PsiMethod generateSetterPrototype(@NotNull PsiField field) {
        return GenerateMembersUtil.generateSetterPrototype(field, true);
    }

    @NotNull
    public static PsiMethod generateSetterPrototype(@NotNull PsiField field, PsiClass aClass) {
        return GenerateMembersUtil.generatePrototype(field, aClass, true, SetterTemplatesManager.getInstance());
    }

    @NotNull
    static PsiMethod generateGetterPrototype(@NotNull PsiField field, boolean ignoreInvalidTemplate) {
        return GenerateMembersUtil.generatePrototype(field, field.getContainingClass(), ignoreInvalidTemplate, GetterTemplatesManager.getInstance());
    }

    @NotNull
    static PsiMethod generateSetterPrototype(@NotNull PsiField field, boolean ignoreInvalidTemplate) {
        return GenerateMembersUtil.generatePrototype(field, field.getContainingClass(), ignoreInvalidTemplate, SetterTemplatesManager.getInstance());
    }

    @NotNull
    private static PsiMethod generatePrototype(@NotNull PsiField field, PsiClass psiClass, boolean ignoreInvalidTemplate, @NotNull TemplatesManager templatesManager) {
        PsiMethod annotationTarget;
        PsiMethod result;
        String methodText;
        Project project = field.getProject();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        String template = templatesManager.getDefaultTemplate().getTemplate();
        Function calculateTemplateText = currentTemplate -> GenerationUtil.velocityGenerateCode(psiClass, Collections.singletonList(field), new HashMap<String, String>(), currentTemplate, 0, false);
        try {
            methodText = (String)calculateTemplateText.fun((Object)template);
        }
        catch (GenerateCodeException e) {
            if (ignoreInvalidTemplate) {
                LOG.info((Throwable)e);
                methodText = (String)calculateTemplateText.fun((Object)templatesManager.getDefaultTemplates().get(0).getTemplate());
            }
            throw e;
        }
        boolean isGetter = templatesManager instanceof GetterTemplatesManager;
        try {
            result = factory.createMethodFromText(methodText, (PsiElement)psiClass);
        }
        catch (IncorrectOperationException e) {
            if (ignoreInvalidTemplate) {
                LOG.info((Throwable)e);
                result = isGetter ? PropertyUtilBase.generateGetterPrototype((PsiField)field) : PropertyUtilBase.generateSetterPrototype((PsiField)field);
            }
            throw new GenerateCodeException(e);
        }
        result = (PsiMethod)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)result);
        if (isGetter) {
            annotationTarget = result;
        } else {
            PsiParameter[] parameters2 = result.getParameterList().getParameters();
            PsiParameter psiParameter = annotationTarget = parameters2.length == 1 ? parameters2[0] : null;
        }
        if (annotationTarget != null) {
            NullableNotNullManager.getInstance((Project)project).copyNullableOrNotNullAnnotation((PsiModifierListOwner)field, (PsiModifierListOwner)annotationTarget);
        }
        return GenerateMembersUtil.generatePrototype(field, result);
    }

    @NotNull
    private static PsiMethod generatePrototype(@NotNull PsiField field, @NotNull PsiMethod result) {
        return GenerateMembersUtil.setVisibility((PsiMember)field, GenerateMembersUtil.annotateOnOverrideImplement(field.getContainingClass(), result));
    }

    @Contract(value="_, null -> null; _, !null -> !null")
    public static PsiMethod setVisibility(PsiMember member, PsiMethod prototype) {
        String newVisibility;
        if (prototype == null) {
            return null;
        }
        PsiFile file = member.getContainingFile();
        JavaCodeStyleSettings javaSettings = file != null ? JavaCodeStyleSettings.getInstance(file) : (JavaCodeStyleSettings)CodeStyle.getProjectOrDefaultSettings((Project)member.getProject()).getCustomSettings(JavaCodeStyleSettings.class);
        String visibility = javaSettings.VISIBILITY;
        if ("EscalateVisible".equals(visibility)) {
            PsiClass aClass = member instanceof PsiClass ? (PsiClass)member : member.getContainingClass();
            newVisibility = PsiUtil.getMaximumModifierForMember((PsiClass)aClass, (boolean)false);
        } else {
            newVisibility = visibility;
        }
        VisibilityUtil.setVisibility((PsiModifierList)prototype.getModifierList(), (String)newVisibility);
        return prototype;
    }

    @Contract(value="_, null -> null; _, !null -> !null")
    public static PsiMethod annotateOnOverrideImplement(@Nullable PsiClass targetClass, @Nullable PsiMethod generated) {
        if (generated == null || targetClass == null) {
            return generated;
        }
        if (JavaCodeStyleSettings.getInstance((PsiFile)targetClass.getContainingFile()).INSERT_OVERRIDE_ANNOTATION) {
            PsiMethod superMethod = targetClass.findMethodBySignature(generated, true);
            if (superMethod != null && superMethod.getContainingClass() != targetClass && PsiUtil.isAccessible((PsiMember)superMethod, (PsiElement)targetClass, null)) {
                OverrideImplementUtil.annotateOnOverrideImplement(generated, targetClass, superMethod, true);
            }
            if (JavaPsiRecordUtil.getRecordComponentForAccessor(generated) != null && PsiUtil.getLanguageLevel((PsiElement)targetClass) != LanguageLevel.JDK_14_PREVIEW) {
                AddAnnotationPsiFix.addPhysicalAnnotationIfAbsent("java.lang.Override", PsiNameValuePair.EMPTY_ARRAY, (PsiAnnotationOwner)generated.getModifierList());
            }
        }
        return generated;
    }
}

