/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.externalAnnotation;

import com.intellij.codeInsight.externalAnnotation.AnnotationProvider;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;

public class UnmodifiableViewAnnotationProvider
implements AnnotationProvider {
    @Override
    @NotNull
    public String getName(Project project) {
        return Mutability.UNMODIFIABLE_VIEW_ANNOTATION;
    }

    @Override
    public boolean isAvailable(PsiModifierListOwner owner2) {
        if (!(owner2 instanceof PsiMethod)) {
            return false;
        }
        PsiClass returnClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)((PsiMethod)owner2).getReturnType());
        return InheritanceUtil.isInheritor((PsiClass)returnClass, (String)"java.util.Collection") || InheritanceUtil.isInheritor((PsiClass)returnClass, (String)"java.util.Map");
    }

    @Override
    public String @NotNull [] getAnnotationsToRemove(Project project) {
        return new String[]{Mutability.UNMODIFIABLE_ANNOTATION};
    }
}

