/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.wordSelection.BasicSelectioner;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.jsp.jspJava.JspCodeBlock;
import com.intellij.psi.javadoc.PsiDocComment;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class StatementGroupSelectioner
extends BasicSelectioner {
    @Override
    public boolean canSelect(@NotNull PsiElement e) {
        return e instanceof PsiStatement || e instanceof PsiComment && !(e instanceof PsiDocComment);
    }

    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        PsiWhiteSpace whiteSpace;
        String[] strings;
        PsiJavaToken token;
        PsiElement sibling;
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        PsiElement parent = e.getParent();
        if (!(parent instanceof PsiCodeBlock) && !(parent instanceof PsiBlockStatement) || parent instanceof JspCodeBlock || e instanceof PsiSwitchLabelStatement) {
            return result;
        }
        PsiElement startElement = e;
        PsiElement endElement = e;
        while (!(startElement.getPrevSibling() == null || (sibling = startElement.getPrevSibling()) instanceof PsiJavaToken && (token = (PsiJavaToken)sibling).getTokenType() == JavaTokenType.LBRACE || sibling instanceof PsiWhiteSpace && (strings = LineTokenizer.tokenize((char[])(whiteSpace = (PsiWhiteSpace)sibling).getText().toCharArray(), (boolean)false)).length > 2 || sibling instanceof PsiSwitchLabelStatement)) {
            startElement = sibling;
        }
        while (startElement instanceof PsiWhiteSpace) {
            startElement = startElement.getNextSibling();
        }
        while (!(endElement.getNextSibling() == null || (sibling = endElement.getNextSibling()) instanceof PsiJavaToken && (token = (PsiJavaToken)sibling).getTokenType() == JavaTokenType.RBRACE || sibling instanceof PsiWhiteSpace && (strings = LineTokenizer.tokenize((char[])(whiteSpace = (PsiWhiteSpace)sibling).getText().toCharArray(), (boolean)false)).length > 2 || sibling instanceof PsiSwitchLabelStatement)) {
            endElement = sibling;
        }
        while (endElement instanceof PsiWhiteSpace) {
            endElement = endElement.getPrevSibling();
        }
        result.addAll(StatementGroupSelectioner.expandToWholeLine((CharSequence)editorText, (TextRange)new TextRange(startElement.getTextRange().getStartOffset(), endElement.getTextRange().getEndOffset())));
        return result;
    }
}

