/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.wordSelection.BasicSelectioner;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiStatement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class IfStatementSelectioner
extends BasicSelectioner {
    @Override
    public boolean canSelect(@NotNull PsiElement e) {
        return e instanceof PsiIfStatement;
    }

    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        ArrayList<TextRange> result = new ArrayList<TextRange>(IfStatementSelectioner.expandToWholeLine((CharSequence)editorText, (TextRange)e.getTextRange(), (boolean)false));
        PsiIfStatement statement = (PsiIfStatement)e;
        PsiKeyword elseKeyword = statement.getElseElement();
        if (elseKeyword != null) {
            PsiStatement elseThen;
            PsiIfStatement elseIf;
            PsiKeyword element;
            TextRange thenRange;
            PsiStatement then = statement.getThenBranch();
            if (then != null && (thenRange = new TextRange(statement.getTextRange().getStartOffset(), then.getTextRange().getEndOffset())).contains(cursorOffset)) {
                result.addAll(IfStatementSelectioner.expandToWholeLine((CharSequence)editorText, (TextRange)thenRange, (boolean)false));
            }
            result.addAll(IfStatementSelectioner.expandToWholeLine((CharSequence)editorText, (TextRange)new TextRange(elseKeyword.getTextRange().getStartOffset(), statement.getTextRange().getEndOffset()), (boolean)false));
            PsiStatement branch = statement.getElseBranch();
            if (branch instanceof PsiIfStatement && (element = (elseIf = (PsiIfStatement)branch).getElseElement()) != null && (elseThen = elseIf.getThenBranch()) != null) {
                result.addAll(IfStatementSelectioner.expandToWholeLine((CharSequence)editorText, (TextRange)new TextRange(elseKeyword.getTextRange().getStartOffset(), elseThen.getTextRange().getEndOffset()), (boolean)false));
            }
        }
        return result;
    }
}

