/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.moveUpDown;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.editorActions.moveUpDown.LineMover;
import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaseBlockMover
extends LineMover {
    public boolean checkAvailable(@NotNull Editor editor, @NotNull PsiFile file, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        LineRange range2;
        PsiElement lastToMove2;
        PsiElement firstToMove2;
        if (!(file instanceof PsiJavaFile)) {
            return false;
        }
        if (!super.checkAvailable(editor, file, info, down)) {
            return false;
        }
        Document document = editor.getDocument();
        int startOffset = document.getLineStartOffset(info.toMove.startLine);
        int endOffset = CaseBlockMover.getLineStartSafeOffset((Document)document, (int)info.toMove.endLine);
        SmartList statements = new SmartList();
        PsiElement firstElement = null;
        for (PsiElement element : CodeInsightUtil.findStatementsInRange(file, startOffset, endOffset)) {
            if (element instanceof PsiSwitchLabelStatement) {
                statements.add((PsiSwitchLabelStatement)element);
                continue;
            }
            if (!statements.isEmpty()) continue;
            firstElement = element;
        }
        if (statements.isEmpty()) {
            return false;
        }
        if (firstElement != null) {
            return info.prohibitMove();
        }
        PsiSwitchLabelStatement firstToMove = CaseBlockMover.getThisCaseBlockStart((PsiSwitchLabelStatement)statements.get(0));
        PsiSwitchLabelStatement lastStatement = (PsiSwitchLabelStatement)statements.get(statements.size() - 1);
        PsiElement nextCaseBlockStart = CaseBlockMover.getNextCaseBlockStart(lastStatement);
        PsiElement lastToMove = PsiTreeUtil.skipWhitespacesBackward((PsiElement)nextCaseBlockStart);
        assert (lastToMove != null);
        LineRange range = CaseBlockMover.createRange(document, (PsiElement)firstToMove, lastToMove);
        if (range == null) {
            return info.prohibitMove();
        }
        info.toMove = range;
        if (down) {
            if (!(nextCaseBlockStart instanceof PsiSwitchLabelStatement) || nextCaseBlockStart == lastStatement) {
                return info.prohibitMove();
            }
            firstToMove2 = nextCaseBlockStart;
            nextCaseBlockStart = CaseBlockMover.getNextCaseBlockStart((PsiSwitchLabelStatement)firstToMove2);
            lastToMove2 = PsiTreeUtil.skipWhitespacesBackward((PsiElement)nextCaseBlockStart);
            assert (lastToMove2 != null);
        } else {
            lastToMove2 = PsiTreeUtil.skipWhitespacesBackward((PsiElement)firstToMove);
            if (lastToMove2 == null) {
                return info.prohibitMove();
            }
            firstToMove2 = PsiTreeUtil.getPrevSiblingOfType((PsiElement)lastToMove2, PsiSwitchLabelStatement.class);
            if (firstToMove2 == null) {
                return info.prohibitMove();
            }
            firstToMove2 = CaseBlockMover.getThisCaseBlockStart((PsiSwitchLabelStatement)firstToMove2);
        }
        if ((range2 = CaseBlockMover.createRange(document, firstToMove2, lastToMove2)) == null) {
            return info.prohibitMove();
        }
        info.toMove2 = range2;
        return true;
    }

    @NotNull
    private static PsiSwitchLabelStatement getThisCaseBlockStart(PsiSwitchLabelStatement element) {
        PsiElement tmp;
        while ((tmp = PsiTreeUtil.skipWhitespacesBackward((PsiElement)element)) instanceof PsiSwitchLabelStatement) {
            element = (PsiSwitchLabelStatement)tmp;
        }
        return element;
    }

    @NotNull
    private static PsiElement getNextCaseBlockStart(PsiSwitchLabelStatement element) {
        PsiElement tmp;
        PsiSwitchLabelStatement result = element;
        while ((tmp = PsiTreeUtil.skipWhitespacesForward((PsiElement)result)) instanceof PsiSwitchLabelStatement) {
            result = tmp;
        }
        tmp = PsiTreeUtil.getNextSiblingOfType((PsiElement)result, PsiSwitchLabelStatement.class);
        return tmp == null ? result.getParent().getLastChild() : tmp;
    }

    @Nullable
    private static LineRange createRange(@NotNull Document document, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        int endLine;
        int startOffset;
        int startLine;
        CharSequence text2 = document.getImmutableCharSequence();
        if (!CharArrayUtil.isEmptyOrSpaces((CharSequence)text2, (int)document.getLineStartOffset(startLine = document.getLineNumber(startOffset = startElement.getTextRange().getStartOffset())), (int)startOffset)) {
            return null;
        }
        int endOffset = endElement.getTextRange().getEndOffset();
        if (!CharArrayUtil.isEmptyOrSpaces((CharSequence)text2, (int)endOffset, (int)document.getLineEndOffset(endLine = document.getLineNumber(endOffset)))) {
            return null;
        }
        return new LineRange(startLine, endLine + 1);
    }
}

