/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.problems.pass;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.JavaLensProvider;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.daemon.problems.Problem;
import com.intellij.codeInsight.daemon.problems.pass.BrokenUsage;
import com.intellij.codeInsight.daemon.problems.pass.RelatedProblemTargetAdapter;
import com.intellij.codeInsight.hints.BlockConstrainedPresentation;
import com.intellij.codeInsight.hints.BlockConstraints;
import com.intellij.codeInsight.hints.BlockInlayRenderer;
import com.intellij.codeInsight.hints.presentation.AttributesTransformerPresentation;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.MouseButton;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.PresentationListener;
import com.intellij.codeInsight.hints.presentation.RecursivelyUpdatingRootPresentation;
import com.intellij.codeInsight.hints.presentation.RootInlayPresentation;
import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.SmartHashMap;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.java.JavaBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectProblemPassUtils {
    private static final Key<Map<SmartPsiElementPointer<PsiMember>, EditorInfo>> EDITOR_INFOS_KEY = Key.create((String)"ProjectProblemEditorInfoKey");
    private static final Key<Long> PREV_MODIFICATION_COUNT = Key.create((String)"ProjectProblemModificationCount");
    private static final String RELATED_PROBLEMS_CLICKED_EVENT_ID = "related.problems.clicked";

    @NotNull
    static InlayPresentation getPresentation(@NotNull Project project, @NotNull Editor editor, @NotNull Document document, @NotNull PresentationFactory factory, int offset, @NotNull PsiMember member, @NotNull Set<Problem> relatedProblems) {
        int column = offset - document.getLineStartOffset(document.getLineNumber(offset));
        InlayPresentation problemsOffset = factory.textSpacePlaceholder(column, true);
        InlayPresentation textPresentation = factory.smallText(JavaBundle.message((String)"project.problems.hint.text", (Object[])new Object[]{relatedProblems.size()}));
        AttributesTransformerPresentation errorTextPresentation = new AttributesTransformerPresentation(textPresentation, __ -> editor.getColorsScheme().getAttributes(CodeInsightColors.WRONG_REFERENCES_ATTRIBUTES));
        InlayPresentation problemsPresentation = factory.referenceOnHover((InlayPresentation)errorTextPresentation, (e, p) -> ProjectProblemPassUtils.showProblems(member, relatedProblems));
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem item = new JMenuItem(JavaBundle.message((String)"project.problems.settings", (Object[])new Object[0]));
        item.addActionListener(e -> JavaLensProvider.openSettings((Language)JavaLanguage.INSTANCE, project));
        popupMenu.add(item);
        InlayPresentation withSettings = factory.onClick(problemsPresentation, MouseButton.Right, (e, __) -> {
            popupMenu.show(e.getComponent(), e.getX(), e.getY());
            return Unit.INSTANCE;
        });
        return factory.seq(new InlayPresentation[]{problemsOffset, withSettings});
    }

    private static void showProblems(@NotNull PsiMember member, @NotNull Set<Problem> relatedProblems) {
        FUCounterUsageLogger.getInstance().logEvent(member.getProject(), "java.lens", RELATED_PROBLEMS_CLICKED_EVENT_ID);
        Project project = member.getProject();
        if (relatedProblems.size() == 1) {
            Problem problem = relatedProblems.iterator().next();
            PsiElement reportedElement = problem.getReportedElement();
            VirtualFile fileWithProblem = reportedElement.getContainingFile().getVirtualFile();
            TextRange elementRange = reportedElement.getTextRange();
            int offset = elementRange != null ? elementRange.getStartOffset() : -1;
            PsiNavigationSupport.getInstance().createNavigatable(project, fileWithProblem, offset).navigate(true);
        } else {
            String memberName = UsageViewUtil.getLongName((PsiElement)member);
            UsageViewPresentation presentation = new UsageViewPresentation();
            String title = JavaBundle.message((String)"project.problems.window.title", (Object[])new Object[]{memberName});
            presentation.setCodeUsagesString(JavaBundle.message((String)"project.problems.title", (Object[])new Object[0]));
            presentation.setTabName(title);
            presentation.setTabText(title);
            Usage[] usages = (Usage[])ContainerUtil.map2Array(relatedProblems, (Object[])new Usage[relatedProblems.size()], e -> {
                PsiElement reportedElement = e.getReportedElement();
                UsageInfo usageInfo = new UsageInfo(e.getContext());
                return new BrokenUsage(usageInfo, reportedElement);
            });
            UsageTarget[] usageTargets = new UsageTarget[]{new RelatedProblemTargetAdapter((PsiElement)member)};
            UsageViewManager usageViewManager = UsageViewManager.getInstance((Project)project);
            usageViewManager.showUsages(usageTargets, usages, presentation);
        }
    }

    @NotNull
    static BlockInlayRenderer createBlockRenderer(@NotNull InlayPresentation presentation) {
        BlockConstraints constraints = new BlockConstraints(true, 100);
        RecursivelyUpdatingRootPresentation rootPresentation = new RecursivelyUpdatingRootPresentation(presentation);
        BlockConstrainedPresentation constrainedPresentation = new BlockConstrainedPresentation((RootInlayPresentation)rootPresentation, constraints);
        return new BlockInlayRenderer(Collections.singletonList(constrainedPresentation));
    }

    static void addListener(@NotNull BlockInlayRenderer renderer, final @NotNull Inlay<?> inlay) {
        renderer.setListener(new PresentationListener(){

            public void sizeChanged(@NotNull Dimension previous, @NotNull Dimension current) {
                inlay.repaint();
            }

            public void contentChanged(@NotNull Rectangle area) {
                inlay.repaint();
            }
        });
    }

    @NotNull
    static HighlightInfo createHighlightInfo(@NotNull Editor editor, @NotNull PsiMember member, @NotNull PsiElement identifier, @NotNull Set<Problem> relatedProblems) {
        ShowRelatedProblemsAction relatedProblemsAction = new ShowRelatedProblemsAction(relatedProblems);
        return ProjectProblemPassUtils.createHighlightInfo(editor, member, identifier, (IntentionAction)relatedProblemsAction);
    }

    @NotNull
    private static HighlightInfo createHighlightInfo(@NotNull Editor editor, @NotNull PsiMember member, @NotNull PsiElement identifier, @NotNull IntentionAction action) {
        Color textColor = editor.getColorsScheme().getAttributes(CodeInsightColors.WEAK_WARNING_ATTRIBUTES).getEffectColor();
        TextAttributes attributes = new TextAttributes(null, null, textColor, null, 0);
        String memberName = UsageViewUtil.getLongName((PsiElement)member);
        HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WARNING).range(identifier.getTextRange()).textAttributes(attributes).descriptionAndTooltip(JavaBundle.message((String)"project.problems.fix.description", (Object[])new Object[]{memberName})).createUnconditionally();
        QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)action);
        return info;
    }

    static int getMemberOffset(@NotNull PsiMember psiMember) {
        return Arrays.stream(psiMember.getChildren()).filter(c -> !(c instanceof PsiDocComment) && !(c instanceof PsiWhiteSpace)).findFirst().orElse((PsiElement)psiMember).getTextRange().getStartOffset();
    }

    static boolean hasOtherElementsOnSameLine(@NotNull PsiMember psiMember) {
        for (PsiElement prevSibling = psiMember.getPrevSibling(); !(prevSibling == null || prevSibling instanceof PsiWhiteSpace && prevSibling.textContains('\n')); prevSibling = prevSibling.getPrevSibling()) {
            if (prevSibling instanceof PsiWhiteSpace || prevSibling.getText().isEmpty()) continue;
            return true;
        }
        return false;
    }

    static boolean hintsEnabled() {
        return JavaLensProvider.getSettings().isShowRelatedProblems();
    }

    @NotNull
    public static Map<PsiMember, Inlay<?>> getInlays(@NotNull Editor editor) {
        return ContainerUtil.map2Map(ProjectProblemPassUtils.getEditorInfos(editor).entrySet(), e -> Pair.create(e.getKey(), ((EditorInfo)e.getValue()).myInlay));
    }

    @NotNull
    static Map<PsiMember, EditorInfo> getEditorInfos(@NotNull Editor editor) {
        Map oldInfos = (Map)editor.getUserData(EDITOR_INFOS_KEY);
        SmartHashMap editorInfos = new SmartHashMap();
        if (oldInfos == null) {
            return editorInfos;
        }
        InlayModel inlayModel = editor.getInlayModel();
        oldInfos.forEach((arg_0, arg_1) -> ProjectProblemPassUtils.lambda$getEditorInfos$7(inlayModel, editor, (Map)editorInfos, arg_0, arg_1));
        return editorInfos;
    }

    @Nullable
    private static IntentionAction getRegisteredAction(@NotNull HighlightInfo highlightInfo) {
        List actionRanges = highlightInfo.quickFixActionRanges;
        if (actionRanges == null || actionRanges.size() != 1) {
            return null;
        }
        return ((HighlightInfo.IntentionActionDescriptor)((Pair)actionRanges.get((int)0)).first).getAction();
    }

    static void updateInfos(@NotNull Editor editor, @NotNull Map<PsiMember, EditorInfo> infos) {
        Map newInfos = ContainerUtil.map2Map(infos.entrySet(), e -> Pair.create((Object)SmartPointerManager.createPointer((PsiElement)((PsiElement)e.getKey())), e.getValue()));
        editor.putUserData(EDITOR_INFOS_KEY, (Object)newInfos);
    }

    static void removeInfos(@NotNull Editor editor) {
        Map infos = (Map)editor.getUserData(EDITOR_INFOS_KEY);
        if (infos == null) {
            return;
        }
        infos.values().forEach(info -> Disposer.dispose(info.myInlay));
        editor.putUserData(EDITOR_INFOS_KEY, null);
    }

    static boolean isDocumentUpdated(@NotNull Editor editor) {
        Document document = editor.getDocument();
        long stamp = document.getModificationStamp();
        Long prevStamp = (Long)document.getUserData(PREV_MODIFICATION_COUNT);
        return prevStamp == null || prevStamp != stamp;
    }

    static void updateTimestamp(@NotNull Editor editor) {
        Document document = editor.getDocument();
        long timestamp = document.getModificationStamp();
        document.putUserData(PREV_MODIFICATION_COUNT, (Object)timestamp);
    }

    @Nullable
    static PsiElement getIdentifier(@NotNull PsiMember psiMember) {
        PsiNameIdentifierOwner identifierOwner = (PsiNameIdentifierOwner)ObjectUtils.tryCast((Object)psiMember, PsiNameIdentifierOwner.class);
        if (identifierOwner == null) {
            return null;
        }
        return identifierOwner.getNameIdentifier();
    }

    private static /* synthetic */ void lambda$getEditorInfos$7(InlayModel inlayModel, Editor editor, Map editorInfos, SmartPsiElementPointer pointer, EditorInfo info) {
        PsiMember member = (PsiMember)pointer.getElement();
        Inlay<?> inlay = info.myInlay;
        if (member == null) {
            Disposer.dispose(inlay);
        } else {
            PsiElement identifier;
            int memberOffset;
            int curOffset = inlay.getOffset();
            if (curOffset != (memberOffset = ProjectProblemPassUtils.getMemberOffset(member))) {
                EditorCustomElementRenderer renderer = inlay.getRenderer();
                info.myInlay = inlayModel.addBlockElement(memberOffset, true, true, 100, renderer);
                Disposer.dispose(inlay);
            }
            if ((identifier = ProjectProblemPassUtils.getIdentifier(member)) != null) {
                IntentionAction action;
                HighlightInfo oldHighlightInfo = info.myHighlightInfo;
                if (!identifier.getTextRange().equalsToRange(oldHighlightInfo.getActualStartOffset(), oldHighlightInfo.getActualEndOffset()) && (action = ProjectProblemPassUtils.getRegisteredAction(oldHighlightInfo)) != null) {
                    HighlightInfo newHighlightInfo = ProjectProblemPassUtils.createHighlightInfo(editor, member, identifier, action);
                    UpdateHighlightersUtil.setHighlightersToEditor((Project)member.getProject(), (Document)editor.getDocument(), (int)0, (int)member.getContainingFile().getTextLength(), Collections.singletonList(newHighlightInfo), (EditorColorsScheme)editor.getColorsScheme(), (int)-1);
                    info.myHighlightInfo = newHighlightInfo;
                }
            }
            editorInfos.put(member, info);
        }
    }

    private static class ShowRelatedProblemsAction
    extends BaseElementAtCaretIntentionAction {
        private final Set<Problem> myRelatedProblems;

        private ShowRelatedProblemsAction(Set<Problem> relatedProblems) {
            this.myRelatedProblems = relatedProblems;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
            return ProjectProblemPassUtils.hintsEnabled();
        }

        public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
            PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMember.class);
            if (member == null) {
                return;
            }
            ProjectProblemPassUtils.showProblems(member, this.myRelatedProblems);
        }

        @NotNull
        public String getText() {
            return this.getFamilyName();
        }

        public boolean startInWriteAction() {
            return false;
        }

        @NotNull
        public String getFamilyName() {
            return JavaBundle.message((String)"project.problems.fix.text", (Object[])new Object[0]);
        }
    }

    static class EditorInfo {
        Inlay<?> myInlay;
        HighlightInfo myHighlightInfo;

        EditorInfo(@NotNull Inlay<?> inlay, @NotNull HighlightInfo info) {
            this.myInlay = inlay;
            this.myHighlightInfo = info;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EditorInfo info = (EditorInfo)o;
            return this.myInlay.equals(info.myInlay) && this.myHighlightInfo.equals((Object)info.myHighlightInfo);
        }

        public int hashCode() {
            return Objects.hash(this.myInlay, this.myHighlightInfo);
        }
    }
}

