/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.problems.pass;

import com.intellij.codeHighlighting.EditorBoundHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.problems.FileState;
import com.intellij.codeInsight.daemon.problems.FileStateUpdater;
import com.intellij.codeInsight.daemon.problems.Problem;
import com.intellij.codeInsight.daemon.problems.ProblemCollector;
import com.intellij.codeInsight.daemon.problems.ScopedMember;
import com.intellij.codeInsight.daemon.problems.pass.ProjectProblemPassUtils;
import com.intellij.codeInsight.hints.BlockInlayRenderer;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInspection.SmartHashMap;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ProjectProblemPass
extends EditorBoundHighlightingPass {
    private final FileEditorManager myEditorManager;
    private Map<PsiMember, MemberState> myMemberStates;
    private Map<SmartPsiElementPointer<PsiMember>, ScopedMember> mySnapshot;

    ProjectProblemPass(@NotNull Editor editor, @NotNull PsiJavaFile file) {
        super(editor, (PsiFile)file, true);
        this.myEditorManager = FileEditorManager.getInstance((Project)this.myProject);
        this.myMemberStates = null;
        this.mySnapshot = null;
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        FileState prevState = FileStateUpdater.getState(this.myFile);
        if (prevState == null) {
            return;
        }
        FileState curState = FileStateUpdater.findState(this.myFile, prevState.getSnapshot());
        this.myMemberStates = this.collectStates(curState.getChanges(), prevState.getChanges());
        this.mySnapshot = curState.getSnapshot();
    }

    public void doApplyInformationToEditor() {
        Map<SmartPsiElementPointer<PsiMember>, ScopedMember> snapshot = this.mySnapshot;
        if (snapshot == null) {
            return;
        }
        Map<PsiMember, MemberState> memberStates = this.myMemberStates;
        if (memberStates == null) {
            return;
        }
        PresentationFactory factory = new PresentationFactory((EditorImpl)this.myEditor);
        Map<PsiMember, ProjectProblemPassUtils.EditorInfo> editorInfos = ProjectProblemPassUtils.getEditorInfos(this.myEditor);
        SmartHashMap changes2 = new SmartHashMap();
        memberStates.forEach((arg_0, arg_1) -> this.lambda$doApplyInformationToEditor$0((Map)changes2, factory, editorInfos, arg_0, arg_1));
        ProjectProblemPassUtils.updateInfos(this.myEditor, editorInfos);
        List highlighters = ContainerUtil.map(editorInfos.values(), v -> v.myHighlightInfo);
        int textLength = this.myFile.getTextLength();
        UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)this.myDocument, (int)0, (int)textLength, (Collection)highlighters, (EditorColorsScheme)this.myEditor.getColorsScheme(), (int)-1);
        FileState fileState = new FileState(snapshot, (Map<PsiMember, ScopedMember>)changes2);
        FileStateUpdater.updateState(this.myFile, fileState);
        ProjectProblemPassUtils.updateTimestamp(this.myEditor);
    }

    private void addInfo(@NotNull PresentationFactory factory, @NotNull PsiMember psiMember, @NotNull Set<Problem> relatedProblems, @NotNull Map<PsiMember, ProjectProblemPassUtils.EditorInfo> editorInfos) {
        ProjectProblemPassUtils.EditorInfo oldInfo = editorInfos.remove(psiMember);
        if (oldInfo != null) {
            Disposer.dispose(oldInfo.myInlay);
        }
        if (relatedProblems.isEmpty() || ProjectProblemPassUtils.hasOtherElementsOnSameLine(psiMember)) {
            return;
        }
        PsiElement identifier = ProjectProblemPassUtils.getIdentifier(psiMember);
        if (identifier == null) {
            return;
        }
        int offset = ProjectProblemPassUtils.getMemberOffset(psiMember);
        InlayPresentation presentation = ProjectProblemPassUtils.getPresentation(this.myProject, this.myEditor, this.myEditor.getDocument(), factory, offset, psiMember, relatedProblems);
        BlockInlayRenderer renderer = ProjectProblemPassUtils.createBlockRenderer(presentation);
        Inlay newInlay = this.myEditor.getInlayModel().addBlockElement(offset, true, true, 100, (EditorCustomElementRenderer)renderer);
        if (newInlay == null) {
            return;
        }
        ProjectProblemPassUtils.addListener(renderer, newInlay);
        HighlightInfo newHighlightInfo = ProjectProblemPassUtils.createHighlightInfo(this.myEditor, psiMember, identifier, relatedProblems);
        editorInfos.put(psiMember, new ProjectProblemPassUtils.EditorInfo(newInlay, newHighlightInfo));
    }

    @NotNull
    private Map<PsiMember, MemberState> collectStates(@NotNull Map<PsiMember, ScopedMember> curChanges, @NotNull Map<PsiMember, ScopedMember> oldChanges) {
        boolean isInSplitEditorMode;
        boolean bl = isInSplitEditorMode = this.myEditorManager.getSelectedEditors().length > 1;
        if (isInSplitEditorMode && curChanges.isEmpty() && !ProjectProblemPassUtils.isDocumentUpdated(this.myEditor)) {
            curChanges = oldChanges;
            oldChanges = Collections.emptyMap();
        }
        Map states = ContainerUtil.map2Map(oldChanges.entrySet(), e -> Pair.create(e.getKey(), (Object)new MemberState((ScopedMember)e.getValue(), null)));
        curChanges.forEach((curMember, prevMember) -> {
            Set<Problem> changeProblems = ProblemCollector.collect(prevMember, curMember);
            if (changeProblems == null) {
                changeProblems = Collections.emptySet();
            }
            states.put(curMember, new MemberState((ScopedMember)prevMember, changeProblems));
        });
        return states;
    }

    private /* synthetic */ void lambda$doApplyInformationToEditor$0(Map changes2, PresentationFactory factory, Map editorInfos, PsiMember curMember, MemberState state) {
        ScopedMember prevMember = state.prevMember;
        Set relatedProblems = state.relatedProblems;
        changes2.put(curMember, prevMember);
        if (relatedProblems != null) {
            this.addInfo(factory, curMember, relatedProblems, editorInfos);
        }
    }

    private static class MemberState {
        private final ScopedMember prevMember;
        private final Set<Problem> relatedProblems;

        private MemberState(ScopedMember prevMember, Set<Problem> relatedProblems) {
            this.prevMember = prevMember;
            this.relatedProblems = relatedProblems;
        }
    }
}

