/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.ArgumentFixerActionFactory;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodArgumentFix;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WrapWithAdapterMethodCallFix
extends LocalQuickFixAndIntentionActionOnPsiElement
implements HighPriorityAction {
    private static final Wrapper[] WRAPPERS = new Wrapper[]{new Wrapper("new java.io.File({0})", inType -> inType.equalsToText("java.lang.String"), outType -> outType.equalsToText("java.io.File")), new Wrapper("java.nio.file.Path.of({0})", inType -> inType.equalsToText("java.lang.String"), outType -> outType.equalsToText("java.nio.file.Path") && WrapWithAdapterMethodCallFix.isAppropriateLanguageLevel(outType, level -> level.isAtLeast(LanguageLevel.JDK_11))), new Wrapper("java.nio.file.Paths.get({0})", inType -> inType.equalsToText("java.lang.String"), outType -> outType.equalsToText("java.nio.file.Path") && WrapWithAdapterMethodCallFix.isAppropriateLanguageLevel(outType, level -> level.isLessThan(LanguageLevel.JDK_11))), new Wrapper("java.util.Arrays.asList({0})", inType -> inType instanceof PsiArrayType && ((PsiArrayType)inType).getComponentType() instanceof PsiClassType, outType -> InheritanceUtil.isInheritor((PsiType)outType, (String)"java.lang.Iterable")), new Wrapper("java.lang.Math.toIntExact({0})", inType -> PsiType.LONG.equals(inType) || inType.equalsToText("java.lang.Long"), outType -> PsiType.INT.equals(outType) || outType.equalsToText("java.lang.Integer")), new Wrapper("java.util.Collections.singleton({0})", inType -> true, outType -> InheritanceUtil.isInheritor((PsiType)outType, (String)"java.lang.Iterable")), new Wrapper("java.util.Collections.singletonList({0})", inType -> true, outType -> outType instanceof PsiClassType && ((PsiClassType)outType).rawType().equalsToText("java.util.List")), new Wrapper("java.util.Arrays.stream({0})", inType -> inType instanceof PsiArrayType, outType -> InheritanceUtil.isInheritor((PsiType)outType, (String)"java.util.stream.BaseStream"))};
    @FileModifier.SafeFieldForPreview
    @Nullable
    private final PsiType myType;
    @FileModifier.SafeFieldForPreview
    @Nullable
    private final Wrapper myWrapper;

    private static boolean isAppropriateLanguageLevel(@NotNull PsiType psiType, @NotNull Predicate<LanguageLevel> level) {
        if (!(psiType instanceof PsiClassType)) {
            return true;
        }
        return level.test(((PsiClassType)psiType).getLanguageLevel());
    }

    public WrapWithAdapterMethodCallFix(@Nullable PsiType type2, @NotNull PsiExpression expression2) {
        this(type2, expression2, (Wrapper)ContainerUtil.find((Object[])WRAPPERS, w -> w.isApplicable((PsiElement)expression2, expression2.getType(), type2)));
    }

    private WrapWithAdapterMethodCallFix(@Nullable PsiType type2, @NotNull PsiExpression expression2, @Nullable Wrapper wrapper) {
        super((PsiElement)expression2);
        this.myType = type2;
        this.myWrapper = wrapper;
    }

    @Nls
    @NotNull
    public String getText() {
        return QuickFixBundle.message("wrap.with.adapter.text", this.myWrapper);
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("wrap.with.adapter.call.family.name", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        return this.myType != null && this.myWrapper != null && this.myType.isValid() && BaseIntentionAction.canModify((PsiElement)startElement);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(startElement.replace((PsiElement)this.getModifiedExpression(startElement)));
    }

    private PsiExpression getModifiedExpression(@NotNull PsiElement expression2) {
        assert (this.myWrapper != null);
        return this.myWrapper.createReplacement(expression2, expression2.getText());
    }

    public static void registerCastActions(CandidateInfo @NotNull [] candidates, @NotNull PsiCall call, HighlightInfo highlightInfo, TextRange fixRange) {
        for (Wrapper wrapper : WRAPPERS) {
            wrapper.registerCastActions(candidates, call, highlightInfo, fixRange);
        }
    }

    private static class MyMethodArgumentFix
    extends MethodArgumentFix
    implements HighPriorityAction {
        protected MyMethodArgumentFix(@NotNull PsiExpressionList list, int i, @NotNull PsiType toType, @NotNull Wrapper fixerActionFactory) {
            super(list, i, toType, fixerActionFactory);
        }

        @Nls
        @NotNull
        public String getText() {
            return this.myArgList.getExpressionCount() == 1 ? QuickFixBundle.message("wrap.with.adapter.parameter.single.text", this.myArgumentFixerActionFactory) : QuickFixBundle.message("wrap.with.adapter.parameter.multiple.text", this.myIndex + 1, this.myArgumentFixerActionFactory);
        }

        @Nullable
        public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
            return new MyMethodArgumentFix((PsiExpressionList)PsiTreeUtil.findSameElementInCopy((PsiElement)this.myArgList, (PsiFile)target), this.myIndex, this.myToType, (Wrapper)this.myArgumentFixerActionFactory);
        }
    }

    static class Wrapper
    extends ArgumentFixerActionFactory {
        final Predicate<? super PsiType> myInTypeFilter;
        final Predicate<? super PsiType> myOutTypeFilter;
        final String myTemplate;

        Wrapper(String template, Predicate<? super PsiType> inTypeFilter, Predicate<? super PsiType> outTypeFilter) {
            this.myInTypeFilter = inTypeFilter;
            this.myOutTypeFilter = outTypeFilter;
            this.myTemplate = template;
        }

        boolean isApplicable(PsiElement context, PsiType inType, PsiType outType) {
            PsiExpression replacement;
            String typeText;
            if (inType == null || outType == null || inType.equals(PsiType.NULL) || !this.myInTypeFilter.test((PsiType)inType) || !this.myOutTypeFilter.test((PsiType)outType)) {
                return false;
            }
            PsiType variableType = GenericsUtil.getVariableTypeByExpressionType((PsiType)inType);
            if (LambdaUtil.notInferredType((PsiType)variableType)) {
                return false;
            }
            if (variableType instanceof PsiDisjunctionType) {
                variableType = ((PsiDisjunctionType)variableType).getLeastUpperBound();
            }
            if ((typeText = variableType.getCanonicalText()).isEmpty()) {
                return false;
            }
            try {
                replacement = this.createReplacement(context, "((" + typeText + ")null)");
            }
            catch (IncorrectOperationException ioe) {
                PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)variableType);
                String message2 = "Cannot create expression for type " + variableType.getClass() + "\nCanonical text: " + variableType.getCanonicalText() + "\nInternal text: " + variableType.getInternalCanonicalText() + "\n";
                if (aClass != null) {
                    message2 = message2 + "Class: " + aClass.getClass() + "|" + aClass.getQualifiedName() + "\nFile: " + aClass.getContainingFile() + "\n";
                }
                if (variableType instanceof PsiClassReferenceType) {
                    PsiJavaCodeReferenceElement reference = ((PsiClassReferenceType)variableType).getReference();
                    message2 = message2 + "Reference: " + reference.getCanonicalText() + "\nReference class: " + reference.getClass() + "\nReference name: " + reference.getReferenceName() + "\nReference qualifier: " + (reference.getQualifier() == null ? "(null)" : reference.getQualifier().getText()) + "Reference file: " + reference.getContainingFile();
                }
                throw new IncorrectOperationException(message2, (Throwable)ioe);
            }
            PsiDeclarationStatement declaration2 = JavaPsiFacade.getElementFactory((Project)context.getProject()).createVariableDeclarationStatement("x", outType, replacement, context);
            PsiVariable var = (PsiVariable)ObjectUtils.tryCast((Object)ArrayUtil.getFirstElement((Object[])declaration2.getDeclaredElements()), PsiVariable.class);
            if (var == null) {
                return false;
            }
            PsiExpression initializer = var.getInitializer();
            if (initializer == null) {
                return false;
            }
            PsiType resultType = initializer.getType();
            return resultType != null && outType.isAssignableFrom(resultType);
        }

        @NotNull
        private PsiExpression createReplacement(PsiElement context, String replacement) {
            return JavaPsiFacade.getElementFactory((Project)context.getProject()).createExpressionFromText(this.myTemplate.replace("{0}", replacement), context);
        }

        @Override
        @Nullable
        protected PsiExpression getModifiedArgument(PsiExpression expression2, PsiType toType) throws IncorrectOperationException {
            if (this.isApplicable((PsiElement)expression2, expression2.getType(), toType)) {
                return (PsiExpression)JavaCodeStyleManager.getInstance((Project)expression2.getProject()).shortenClassReferences((PsiElement)this.createReplacement((PsiElement)expression2, expression2.getText()));
            }
            return null;
        }

        @Override
        public boolean areTypesConvertible(@NotNull PsiType exprType, @NotNull PsiType parameterType, @NotNull PsiElement context) {
            return parameterType.isConvertibleFrom(exprType) || this.isApplicable(context, exprType, parameterType);
        }

        @Override
        public MethodArgumentFix createFix(PsiExpressionList list, int i, PsiType toType) {
            return new MyMethodArgumentFix(list, i, toType, this);
        }

        public String toString() {
            return this.myTemplate.replace("{0}", "").replaceAll("\\b[a-z.]+\\.", "");
        }
    }
}

