/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class WrapSwitchRuleStatementsIntoBlockFix
extends BaseIntentionAction {
    @NotNull
    private final PsiSwitchLabeledRuleStatement myRuleStatement;

    public WrapSwitchRuleStatementsIntoBlockFix(@NotNull PsiSwitchLabeledRuleStatement ruleStatement) {
        this.myRuleStatement = ruleStatement;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("create.block", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (!(file instanceof PsiJavaFile)) {
            return false;
        }
        if (!this.myRuleStatement.isValid()) {
            return false;
        }
        if (this.myRuleStatement.getBody() instanceof PsiBlockStatement) {
            return false;
        }
        PsiStatement sibling = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)this.myRuleStatement, PsiStatement.class);
        if (sibling == null || sibling instanceof PsiSwitchLabelStatementBase) {
            this.setText(this.getFamilyName());
        } else {
            this.setText(QuickFixBundle.message("wrap.with.block", new Object[0]));
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        int nextIndex;
        if (!this.myRuleStatement.isValid()) {
            return;
        }
        PsiCodeBlock parent = (PsiCodeBlock)ObjectUtils.tryCast((Object)this.myRuleStatement.getParent(), PsiCodeBlock.class);
        if (parent == null) {
            return;
        }
        PsiJavaToken rBrace = parent.getRBrace();
        Object[] children = parent.getChildren();
        int index = ArrayUtil.indexOf((Object[])children, (Object)this.myRuleStatement);
        assert (index >= 0);
        for (nextIndex = index + 1; nextIndex < children.length && !(children[nextIndex] instanceof PsiSwitchLabelStatementBase) && children[nextIndex] != rBrace; ++nextIndex) {
        }
        if (children[nextIndex - 1] instanceof PsiWhiteSpace) {
            --nextIndex;
        }
        PsiElement oldBody = null;
        if (this.myRuleStatement.getBody() != null) {
            oldBody = this.myRuleStatement.getBody().copy();
            this.myRuleStatement.getBody().delete();
        }
        PsiSwitchLabeledRuleStatement newRule = (PsiSwitchLabeledRuleStatement)JavaPsiFacade.getElementFactory((Project)project).createStatementFromText(this.myRuleStatement.getText() + "{}", (PsiElement)this.myRuleStatement);
        PsiCodeBlock block = ((PsiBlockStatement)Objects.requireNonNull(newRule.getBody())).getCodeBlock();
        if (oldBody != null) {
            block.add(oldBody);
        }
        if (nextIndex > index + 1) {
            Object first = children[index + 1];
            Object last = children[nextIndex - 1];
            block.addRange((PsiElement)first, (PsiElement)last);
            parent.deleteChildRange((PsiElement)first, (PsiElement)last);
        }
        this.myRuleStatement.replace((PsiElement)newRule);
    }
}

