/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.ImportFilter;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticImportMemberFix;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

abstract class StaticMembersProcessor<T extends PsiMember & PsiDocCommentOwner>
implements Processor<T> {
    private final MultiMap<PsiClass, T> mySuggestions = MultiMap.createLinked();
    private final Map<String, Boolean> myPossibleClasses = new HashMap<String, Boolean>();
    @NotNull
    private final PsiElement myPlace;
    @NotNull
    private final SearchMode mySearchMode;
    private final boolean myInDefaultPackage;
    private final boolean myAddStaticImport;
    private ExpectedTypeInfo[] myExpectedTypes;

    protected StaticMembersProcessor(@NotNull PsiElement place, boolean addStaticImport, @NotNull SearchMode searchMode) {
        this.myPlace = place;
        this.mySearchMode = searchMode;
        this.myInDefaultPackage = PsiUtil.isFromDefaultPackage((PsiElement)place);
        this.myAddStaticImport = addStaticImport;
    }

    protected abstract boolean isApplicable(T var1, PsiElement var2);

    @NotNull
    public List<T> getMembersToImport(boolean applicableOnly) {
        ArrayList list = new ArrayList();
        ArrayList applicableList = new ArrayList();
        for (Map.Entry methodEntry : this.mySuggestions.entrySet()) {
            this.registerMember((PsiClass)methodEntry.getKey(), (Collection)methodEntry.getValue(), list, applicableList);
        }
        ArrayList result = !applicableOnly && applicableList.isEmpty() ? list : applicableList;
        result.sort(CodeInsightUtil.createSortIdenticalNamedMembersComparator(this.myPlace));
        return result;
    }

    protected ExpectedTypeInfo[] getExpectedTypes() {
        if (this.myExpectedTypes == null) {
            this.myExpectedTypes = this.myPlace instanceof PsiExpression ? ExpectedTypesProvider.getExpectedTypes((PsiExpression)this.myPlace, false) : ExpectedTypeInfo.EMPTY_ARRAY;
        }
        return this.myExpectedTypes;
    }

    protected boolean isApplicableFor(PsiType fieldType) {
        ExpectedTypeInfo[] expectedTypes;
        for (ExpectedTypeInfo info : expectedTypes = this.getExpectedTypes()) {
            if (!TypeConversionUtil.isAssignable((PsiType)info.getType(), (PsiType)fieldType)) continue;
            return true;
        }
        return expectedTypes.length == 0;
    }

    public boolean process(T member) {
        ProgressManager.checkCanceled();
        if (StaticImportMemberFix.isExcluded(member)) {
            return true;
        }
        PsiClass containingClass = member.getContainingClass();
        if (containingClass != null) {
            String qualifiedName = containingClass.getQualifiedName();
            PsiFile containingFile = this.myPlace.getContainingFile();
            if (qualifiedName != null && containingFile != null && !ImportFilter.shouldImport((PsiFile)containingFile, (String)qualifiedName)) {
                return true;
            }
            PsiModifierList modifierList = member.getModifierList();
            if (modifierList != null && member instanceof PsiMethod && member.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE) && !modifierList.hasExplicitModifier("static")) {
                return true;
            }
        }
        if (this.myAddStaticImport) {
            if (!PsiUtil.isFromDefaultPackage(member)) {
                this.mySuggestions.putValue((Object)containingClass, member);
            }
        } else if (this.myInDefaultPackage || !PsiUtil.isFromDefaultPackage(member)) {
            this.mySuggestions.putValue((Object)containingClass, member);
        }
        return this.processCondition();
    }

    private boolean processCondition() {
        return this.mySuggestions.size() < this.mySearchMode.count;
    }

    private void registerMember(PsiClass containingClass, Collection<? extends T> members, List<? super T> list, List<? super T> applicableList) {
        String qualifiedName = containingClass.getQualifiedName();
        if (qualifiedName == null) {
            return;
        }
        Boolean alreadyMentioned = this.myPossibleClasses.get(qualifiedName);
        if (alreadyMentioned == Boolean.TRUE) {
            return;
        }
        if (alreadyMentioned == null) {
            this.myPossibleClasses.put(qualifiedName, false);
        }
        for (PsiMember member : members) {
            if (!member.hasModifierProperty("static")) continue;
            if (alreadyMentioned == null) {
                list.add(member);
                alreadyMentioned = Boolean.FALSE;
            }
            if (!PsiUtil.isAccessible((Project)this.myPlace.getProject(), (PsiMember)member, (PsiElement)this.myPlace, (PsiClass)containingClass) || this.myAddStaticImport && !PsiUtil.isAccessible((Project)this.myPlace.getProject(), (PsiMember)member, (PsiElement)this.myPlace.getContainingFile(), (PsiClass)containingClass) || !this.isApplicable(member, this.myPlace)) continue;
            applicableList.add(member);
            this.myPossibleClasses.put(qualifiedName, true);
            break;
        }
    }

    public static enum SearchMode {
        MAX_2_MEMBERS(2),
        MAX_100_MEMBERS(100);

        private final int count;

        private SearchMode(int count) {
            this.count = count;
        }
    }
}

