/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.roots.ui.configuration.SdkPopupFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class SetupJDKFix
implements IntentionAction,
HighPriorityAction {
    private static final SetupJDKFix ourInstance = new SetupJDKFix();

    public static SetupJDKFix getInstance() {
        return ourInstance;
    }

    private SetupJDKFix() {
    }

    @NotNull
    public String getText() {
        return QuickFixBundle.message("setup.jdk.location.text", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("setup.jdk.location.family", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return JavaPsiFacade.getInstance((Project)project).findClass("java.lang.Object", file.getResolveScope()) == null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        SdkPopupFactory.newBuilder().withProject(project).withSdkTypeFilter(type2 -> type2 instanceof JavaSdkType).updateSdkForFile(file).buildPopup().showInBestPositionFor(editor);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

