/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.util.JavaElementKind;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveUnusedParameterFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final String myName;

    public RemoveUnusedParameterFix(PsiParameter parameter2) {
        super((PsiElement)parameter2);
        this.myName = parameter2.getName();
    }

    @NotNull
    public String getText() {
        return CommonQuickFixBundle.message((String)"fix.remove.title.x", (Object[])new Object[]{JavaElementKind.PARAMETER.object(), this.myName});
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("remove.unused.element.family", JavaElementKind.PARAMETER.object());
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiParameter myParameter = (PsiParameter)startElement;
        return myParameter.getDeclarationScope() instanceof PsiMethod && BaseIntentionAction.canModify((PsiElement)myParameter);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiParameter myParameter = (PsiParameter)startElement;
        if (!FileModificationService.getInstance().prepareFileForWrite(myParameter.getContainingFile())) {
            return;
        }
        RemoveUnusedParameterFix.removeReferences(myParameter);
    }

    public static void removeReferences(PsiParameter parameter2) {
        PsiMethod method = (PsiMethod)parameter2.getDeclarationScope();
        ChangeSignatureProcessor processor2 = new ChangeSignatureProcessor(parameter2.getProject(), method, false, null, method.getName(), method.getReturnType(), ParameterInfoImpl.fromMethodExceptParameter(method, parameter2));
        processor2.run();
    }

    public boolean startInWriteAction() {
        return false;
    }
}

