/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PermuteArgumentsFix
implements IntentionAction,
HighPriorityAction {
    private static final Logger LOG = Logger.getInstance(PermuteArgumentsFix.class);
    private final PsiCall myCall;
    private final PsiCall myPermutation;

    private PermuteArgumentsFix(@NotNull PsiCall call, @NotNull PsiCall permutation) {
        this.myCall = call;
        this.myPermutation = permutation;
    }

    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    public String getText() {
        return QuickFixBundle.message("permute.arguments", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return !project.isDisposed() && this.myCall.isValid() && BaseIntentionAction.canModify((PsiElement)this.myCall);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        this.myCall.getArgumentList().replace((PsiElement)this.myPermutation.getArgumentList());
    }

    public static boolean registerFix(HighlightInfo info, PsiCall callExpression, CandidateInfo[] candidates, TextRange fixRange) {
        PsiExpression[] expressions2 = callExpression.getArgumentList().getExpressions();
        if (expressions2.length < 2) {
            return false;
        }
        ArrayList permutations = new ArrayList();
        for (CandidateInfo candidate : candidates) {
            if (!(candidate instanceof MethodCandidateInfo)) continue;
            MethodCandidateInfo methodCandidate = (MethodCandidateInfo)candidate;
            PsiMethod method = methodCandidate.getElement();
            PsiSubstitutor substitutor = methodCandidate.getSubstitutor();
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            if (expressions2.length != parameters2.length || parameters2.length == 0) continue;
            int minIncompatibleIndex = parameters2.length;
            int maxIncompatibleIndex = 0;
            int incompatibilitiesCount = 0;
            for (int i = 0; i < parameters2.length; ++i) {
                PsiParameter parameter2 = parameters2[i];
                PsiType type2 = substitutor.substitute(parameter2.getType());
                if (TypeConversionUtil.areTypesAssignmentCompatible((PsiType)type2, (PsiExpression)expressions2[i])) continue;
                if (minIncompatibleIndex == parameters2.length) {
                    minIncompatibleIndex = i;
                }
                maxIncompatibleIndex = i;
                ++incompatibilitiesCount;
            }
            try {
                PermuteArgumentsFix.registerSwapFixes(expressions2, callExpression, permutations, methodCandidate, incompatibilitiesCount, minIncompatibleIndex, maxIncompatibleIndex);
                PermuteArgumentsFix.registerShiftFixes(expressions2, callExpression, permutations, methodCandidate, minIncompatibleIndex, maxIncompatibleIndex);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        if (permutations.size() == 1) {
            PermuteArgumentsFix fix = new PermuteArgumentsFix(callExpression, (PsiCall)permutations.get(0));
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (TextRange)fixRange, (IntentionAction)fix);
            return true;
        }
        return false;
    }

    private static void registerShiftFixes(PsiExpression[] expressions2, PsiCall callExpression, List<? super PsiCall> permutations, MethodCandidateInfo methodCandidate, int minIncompatibleIndex, int maxIncompatibleIndex) throws IncorrectOperationException {
        PsiMethod method = methodCandidate.getElement();
        PsiSubstitutor substitutor = methodCandidate.getSubstitutor();
        for (int i = 0; i <= minIncompatibleIndex; ++i) {
            for (int j = Math.max(i + 2, maxIncompatibleIndex); j < expressions2.length; ++j) {
                ArrayUtil.rotateLeft((Object[])expressions2, (int)i, (int)j);
                if (PsiUtil.isApplicable((PsiMethod)method, (PsiSubstitutor)substitutor, (PsiExpression[])expressions2) && PermuteArgumentsFix.canShift(expressions2, callExpression, permutations, i)) {
                    return;
                }
                ArrayUtil.rotateRight((Object[])expressions2, (int)i, (int)j);
                ArrayUtil.rotateRight((Object[])expressions2, (int)i, (int)j);
                if (PsiUtil.isApplicable((PsiMethod)method, (PsiSubstitutor)substitutor, (PsiExpression[])expressions2) && PermuteArgumentsFix.canShift(expressions2, callExpression, permutations, i)) {
                    return;
                }
                ArrayUtil.rotateLeft((Object[])expressions2, (int)i, (int)j);
            }
        }
    }

    private static boolean canShift(PsiExpression[] expressions2, PsiCall callExpression, List<? super PsiCall> permutations, int i) {
        PsiCall copy = LambdaUtil.copyTopLevelCall((PsiCall)callExpression);
        if (copy == null) {
            return false;
        }
        PsiExpressionList list = copy.getArgumentList();
        if (list == null) {
            return false;
        }
        PsiExpression[] copyExpressions = list.getExpressions();
        for (int k = i; k < copyExpressions.length; ++k) {
            copyExpressions[k].replace((PsiElement)expressions2[k]);
        }
        JavaResolveResult result = copy.resolveMethodGenerics();
        if (result.getElement() != null && result.isValidResult()) {
            permutations.add((PsiCall)copy);
            if (permutations.size() > 1) {
                return true;
            }
        }
        return false;
    }

    private static void registerSwapFixes(PsiExpression[] expressions2, PsiCall callExpression, List<? super PsiCall> permutations, MethodCandidateInfo candidate, int incompatibilitiesCount, int minIncompatibleIndex, int maxIncompatibleIndex) throws IncorrectOperationException {
        PsiMethod method = candidate.getElement();
        PsiSubstitutor substitutor = candidate.getSubstitutor();
        if (incompatibilitiesCount >= 3) {
            return;
        }
        for (int i = minIncompatibleIndex; i < maxIncompatibleIndex; ++i) {
            for (int j = i + 1; j <= maxIncompatibleIndex; ++j) {
                ArrayUtil.swap((Object[])expressions2, (int)i, (int)j);
                if (PsiUtil.isApplicable((PsiMethod)method, (PsiSubstitutor)substitutor, (PsiExpression[])expressions2)) {
                    PsiCall copy = LambdaUtil.copyTopLevelCall((PsiCall)callExpression);
                    if (copy == null) {
                        return;
                    }
                    PsiExpressionList argumentList = copy.getArgumentList();
                    if (argumentList == null) {
                        return;
                    }
                    PsiExpression[] copyExpressions = argumentList.getExpressions();
                    copyExpressions[i].replace((PsiElement)expressions2[i]);
                    copyExpressions[j].replace((PsiElement)expressions2[j]);
                    JavaResolveResult result = copy.resolveMethodGenerics();
                    if (result.getElement() != null && result.isValidResult()) {
                        permutations.add((PsiCall)copy);
                        if (permutations.size() > 1) {
                            return;
                        }
                    }
                }
                ArrayUtil.swap((Object[])expressions2, (int)i, (int)j);
            }
        }
    }
}

