/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiVariable;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class NavigateToAlreadyDeclaredVariableFix
implements IntentionAction {
    private final PsiVariable myVariable;

    public NavigateToAlreadyDeclaredVariableFix(@NotNull PsiVariable variable) {
        this.myVariable = variable;
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("navigate.variable.declaration.family", new Object[0]);
    }

    @NotNull
    public String getText() {
        return QuickFixBundle.message("navigate.variable.declaration.text", this.myVariable.getName());
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (!this.myVariable.isValid()) {
            return false;
        }
        return BaseIntentionAction.canModify((PsiElement)this.myVariable);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        this.myVariable.navigate(true);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

