/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.actions.AddImportAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PackageUtil;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringActionHandlerFactory;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class MoveClassToModuleFix
implements IntentionAction {
    private final Map<PsiClass, Module> myModules = new LinkedHashMap<PsiClass, Module>();
    private final String myReferenceName;
    private final Module myCurrentModule;
    private final PsiDirectory mySourceRoot;
    private static final Logger LOG = Logger.getInstance(MoveClassToModuleFix.class);

    public MoveClassToModuleFix(String referenceName, Module currentModule, PsiDirectory root, PsiElement psiElement) {
        this.myReferenceName = referenceName;
        this.myCurrentModule = currentModule;
        this.mySourceRoot = root;
        Project project = psiElement.getProject();
        PsiClass[] classes2 = PsiShortNamesCache.getInstance((Project)project).getClassesByName(referenceName, GlobalSearchScope.allScope((Project)project));
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        for (PsiClass aClass : classes2) {
            Module classModule;
            VirtualFile virtualFile;
            PsiFile psiFile;
            if (!facade.getResolveHelper().isAccessible((PsiMember)aClass, psiElement, aClass) || !((psiFile = aClass.getContainingFile()) instanceof PsiJavaFile) || aClass.getQualifiedName() == null || (virtualFile = psiFile.getVirtualFile()) == null || (classModule = fileIndex.getModuleForFile(virtualFile)) == null || classModule == currentModule || ModuleRootManager.getInstance((Module)currentModule).isDependsOn(classModule)) continue;
            this.myModules.put(aClass, classModule);
        }
    }

    @NotNull
    public String getText() {
        if (this.myModules.size() == 1) {
            PsiClass aClass = this.myModules.keySet().iterator().next();
            return QuickFixBundle.message("move.0.from.module.1.to.2", aClass.getQualifiedName(), this.myModules.get(aClass).getName(), this.myCurrentModule.getName());
        }
        return QuickFixBundle.message("move.0.in.1", this.myReferenceName, this.myCurrentModule.getName());
    }

    @NotNull
    public String getFamilyName() {
        return JavaBundle.message((String)"intention.family.move.it", (Object[])new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return !this.myModules.isEmpty() && this.myModules.keySet().stream().allMatch(PsiElement::isValid);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (this.myModules.size() == 1) {
            this.moveClass(project, editor, file, this.myModules.keySet().iterator().next());
        } else {
            LOG.assertTrue(editor != null);
            JBPopupFactory.getInstance().createPopupChooserBuilder(new ArrayList<PsiClass>(this.myModules.keySet())).setTitle(QuickFixBundle.message("choose.class.to.move.popup.title", new Object[0])).setRenderer((ListCellRenderer)new PsiElementListCellRenderer<PsiClass>(){

                public String getElementText(PsiClass psiClass) {
                    return psiClass.getQualifiedName();
                }

                @Nullable
                protected String getContainerText(PsiClass element, String name2) {
                    return null;
                }

                protected int getIconFlags() {
                    return 0;
                }
            }).setMovable(false).setResizable(false).setRequestFocus(true).setItemChosenCallback(value2 -> this.moveClass(project, editor, file, (PsiClass)value2)).createPopup().showInBestPositionFor(editor);
        }
    }

    private void moveClass(Project project, Editor editor, PsiFile file, PsiClass aClass) {
        RefactoringActionHandler moveHandler = RefactoringActionHandlerFactory.getInstance().createMoveHandler();
        DataManager dataManager = DataManager.getInstance();
        DataContext dataContext = dataManager.getDataContext();
        String fqName = aClass.getQualifiedName();
        LOG.assertTrue(fqName != null);
        PsiDirectory directory = PackageUtil.findOrCreateDirectoryForPackage(this.myCurrentModule, StringUtil.getPackageName((String)fqName), this.mySourceRoot, true);
        DataContext context = SimpleDataContext.getSimpleContext((String)LangDataKeys.TARGET_PSI_ELEMENT.getName(), (Object)directory, (DataContext)dataContext);
        moveHandler.invoke(project, new PsiElement[]{aClass}, context);
        PsiReference reference = file.findReferenceAt(editor.getCaretModel().getOffset());
        PsiClass newClass = JavaPsiFacade.getInstance((Project)project).findClass(fqName, GlobalSearchScope.moduleScope((Module)this.myCurrentModule));
        if (reference != null && newClass != null) {
            AddImportAction action = new AddImportAction(project, reference, editor, newClass);
            action.execute();
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static void registerFixes(QuickFixActionRegistrar registrar, PsiJavaCodeReferenceElement reference) {
        PsiElement psiElement = reference.getElement();
        String referenceName = reference.getRangeInElement().substring(psiElement.getText());
        Project project = psiElement.getProject();
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile == null) {
            return;
        }
        PsiDirectory dir = containingFile.getContainingDirectory();
        if (dir == null) {
            return;
        }
        VirtualFile classVFile = containingFile.getVirtualFile();
        if (classVFile == null) {
            return;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Module currentModule = fileIndex.getModuleForFile(classVFile);
        if (currentModule == null) {
            return;
        }
        List sourceRoots = ModuleRootManager.getInstance((Module)currentModule).getSourceRoots(JavaModuleSourceRootTypes.SOURCES);
        if (sourceRoots.isEmpty()) {
            return;
        }
        PsiDirectory sourceDirectory = PsiManager.getInstance((Project)project).findDirectory((VirtualFile)sourceRoots.get(0));
        if (sourceDirectory == null) {
            return;
        }
        VirtualFile vsourceRoot = fileIndex.getSourceRootForFile(classVFile);
        if (vsourceRoot == null) {
            return;
        }
        PsiDirectory sourceRoot = PsiManager.getInstance((Project)project).findDirectory(vsourceRoot);
        if (sourceRoot == null) {
            return;
        }
        registrar.register((IntentionAction)new MoveClassToModuleFix(referenceName, currentModule, sourceRoot, psiElement));
    }
}

