/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.ExtendsListFix;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReferenceList;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveBoundClassToFrontFix
extends ExtendsListFix {
    private static final Logger LOG = Logger.getInstance(MoveBoundClassToFrontFix.class);
    private final String myName;

    public MoveBoundClassToFrontFix(@NotNull PsiClass aClass, @NotNull PsiClassType classToExtendFrom) {
        super(aClass, classToExtendFrom, true);
        PsiClass classToExtendFromPointer = this.myClassToExtendFromPointer != null ? (PsiClass)this.myClassToExtendFromPointer.getElement() : null;
        this.myName = QuickFixBundle.message("move.bound.class.to.front.fix.text", classToExtendFromPointer == null ? "<null>" : HighlightUtil.formatClass(classToExtendFromPointer), HighlightUtil.formatClass(aClass));
    }

    @Override
    @NotNull
    public String getText() {
        return this.myName;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("move.class.in.extend.list.family", new Object[0]);
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiClass myClass = (PsiClass)startElement;
        PsiReferenceList extendsList = myClass.getExtendsList();
        if (extendsList == null) {
            return;
        }
        try {
            this.modifyList(extendsList, false, -1);
            this.modifyList(extendsList, true, 0);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        UndoUtil.markPsiFileForUndo((PsiFile)file);
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiClass myClass = (PsiClass)startElement;
        PsiClass classToExtendFrom = this.myClassToExtendFromPointer != null ? (PsiClass)this.myClassToExtendFromPointer.getElement() : null;
        return BaseIntentionAction.canModify((PsiElement)myClass) && classToExtendFrom != null && classToExtendFrom.isValid();
    }
}

