/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MakeClassInterfaceFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private static final Logger LOG = Logger.getInstance(MakeClassInterfaceFix.class);
    private final boolean myMakeInterface;
    private final String myName;

    public MakeClassInterfaceFix(PsiClass aClass, boolean makeInterface) {
        super((PsiElement)aClass);
        this.myMakeInterface = makeInterface;
        this.myName = aClass.getName();
    }

    @NotNull
    public String getText() {
        return QuickFixBundle.message(this.myMakeInterface ? "make.class.an.interface.text" : "make.interface.an.class.text", this.myName);
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("make.class.an.interface.family", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiClass myClass = (PsiClass)startElement;
        return BaseIntentionAction.canModify((PsiElement)myClass);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiClass myClass = (PsiClass)startElement;
        try {
            PsiReferenceList implementsList;
            PsiReferenceList extendsList = this.myMakeInterface ? myClass.getExtendsList() : myClass.getImplementsList();
            PsiReferenceList psiReferenceList = implementsList = this.myMakeInterface ? myClass.getImplementsList() : myClass.getExtendsList();
            if (extendsList != null) {
                for (PsiJavaCodeReferenceElement referenceElement : extendsList.getReferenceElements()) {
                    referenceElement.delete();
                }
                if (implementsList != null) {
                    for (PsiJavaCodeReferenceElement referenceElement : implementsList.getReferenceElements()) {
                        extendsList.addAfter((PsiElement)referenceElement, null);
                        referenceElement.delete();
                    }
                }
            }
            MakeClassInterfaceFix.convertPsiClass(myClass, this.myMakeInterface);
            UndoUtil.markPsiFileForUndo((PsiFile)file);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static void convertPsiClass(PsiClass aClass, boolean makeInterface) throws IncorrectOperationException {
        IElementType lookFor = makeInterface ? JavaTokenType.CLASS_KEYWORD : JavaTokenType.INTERFACE_KEYWORD;
        PsiKeyword replaceWith = JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createKeyword(makeInterface ? "interface" : "class");
        for (PsiElement psiElement = aClass.getFirstChild(); psiElement != null; psiElement = psiElement.getNextSibling()) {
            PsiKeyword psiKeyword;
            if (!(psiElement instanceof PsiKeyword) || (psiKeyword = (PsiKeyword)psiElement).getTokenType() != lookFor) continue;
            psiKeyword.replace((PsiElement)replaceWith);
            break;
        }
    }
}

