/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFieldFromUsageHelper;
import com.intellij.codeInsight.daemon.impl.quickfix.EmptyExpression;
import com.intellij.codeInsight.daemon.impl.quickfix.GuessTypeParameters;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.introduceField.BaseExpressionToFieldHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCreateFieldFromUsageHelper
extends CreateFieldFromUsageHelper {
    @Override
    public Template setupTemplateImpl(PsiField field, Object expectedTypes, PsiClass targetClass, Editor editor, PsiElement context, boolean createConstantField, @NotNull PsiSubstitutor substitutor) {
        Project project = field.getProject();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        field = (PsiField)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)field);
        TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)field);
        if (!(expectedTypes instanceof ExpectedTypeInfo[])) {
            expectedTypes = ExpectedTypeInfo.EMPTY_ARRAY;
        }
        new GuessTypeParameters(project, (JVMElementFactory)factory, (TemplateBuilder)builder, substitutor).setupTypeElement(field.getTypeElement(), expectedTypes, context, targetClass);
        if (createConstantField) {
            field.setInitializer(factory.createExpressionFromText("0", null));
            builder.replaceElement((PsiElement)field.getInitializer(), (Expression)new EmptyExpression());
            PsiIdentifier identifier = field.getNameIdentifier();
            builder.setEndVariableAfter((PsiElement)identifier);
        }
        field = (PsiField)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)field);
        editor.getCaretModel().moveToOffset(field.getTextRange().getStartOffset());
        Template template = builder.buildInlineTemplate();
        if (JavaCreateFieldFromUsageHelper.disableShortenLongNames(project, expectedTypes)) {
            template.setToShortenLongNames(false);
        }
        return template;
    }

    private static boolean disableShortenLongNames(Project project, ExpectedTypeInfo[] expectedTypes) {
        if (Registry.is((String)"ide.create.field.enable.shortening")) {
            return false;
        }
        return ExpectedTypesProvider.processExpectedTypes(expectedTypes, (PsiTypeVisitor<? extends PsiType>)new PsiTypeVisitor<PsiType>(){

            public PsiType visitType(@NotNull PsiType type2) {
                return type2;
            }
        }, project).length > 1;
    }

    @Override
    public PsiField insertFieldImpl(@NotNull PsiClass targetClass, @NotNull PsiField field, @Nullable PsiElement place) {
        PsiClass parentClass;
        PsiMember enclosingContext = null;
        while ((parentClass = (enclosingContext = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)(enclosingContext == null ? place : enclosingContext), (Class[])new Class[]{PsiMethod.class, PsiField.class, PsiClassInitializer.class})) == null ? null : enclosingContext.getContainingClass()) instanceof PsiAnonymousClass) {
        }
        return BaseExpressionToFieldHandler.ConvertToFieldRunnable.appendField(targetClass, field, (PsiElement)enclosingContext, null);
    }
}

