/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DeleteRepeatedInterfaceFix
implements IntentionAction {
    private final PsiTypeElement myConjunct;
    private final List<? extends PsiTypeElement> myConjList;

    public DeleteRepeatedInterfaceFix(PsiTypeElement conjunct, List<? extends PsiTypeElement> conjList) {
        this.myConjunct = conjunct;
        this.myConjList = conjList;
    }

    @NotNull
    public String getText() {
        return JavaAnalysisBundle.message((String)"delete.repeated.0", (Object[])new Object[]{this.myConjunct.getText()});
    }

    @NotNull
    public String getFamilyName() {
        return JavaAnalysisBundle.message((String)"delete.repeated.interface", (Object[])new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        for (PsiTypeElement psiTypeElement : this.myConjList) {
            if (psiTypeElement.isValid()) continue;
            return false;
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiType type2;
        PsiTypeElement castType;
        PsiTypeCastExpression castExpression = (PsiTypeCastExpression)PsiTreeUtil.getParentOfType((PsiElement)this.myConjunct, PsiTypeCastExpression.class);
        if (castExpression != null && (castType = castExpression.getCastType()) != null && (type2 = castType.getType()) instanceof PsiIntersectionType) {
            String typeText = StringUtil.join((Collection)ContainerUtil.filter(this.myConjList, element -> element != this.myConjunct), element -> element.getText(), (String)" & ");
            PsiTypeCastExpression newCastExpr = (PsiTypeCastExpression)JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText("(" + typeText + ")a", (PsiElement)castType);
            CodeStyleManager.getInstance((Project)project).reformat(castType.replace((PsiElement)newCastExpr.getCastType()));
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

