/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassKind;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateServiceClassFixBase;
import com.intellij.ide.actions.TemplateKindCombo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.ComboBoxWithWidePopup;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.panel.PanelBuilder;
import com.intellij.openapi.ui.panel.PanelGridBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.PsiUsesStatement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.UI;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateServiceInterfaceOrClassFix
extends CreateServiceClassFixBase {
    private String myInterfaceName;

    public CreateServiceInterfaceOrClassFix(PsiJavaCodeReferenceElement referenceElement) {
        referenceElement = CreateServiceInterfaceOrClassFix.findTopmostReference(referenceElement);
        PsiElement parent = referenceElement.getParent();
        if ((parent instanceof PsiUsesStatement && ((PsiUsesStatement)parent).getClassReference() == referenceElement || parent instanceof PsiProvidesStatement && ((PsiProvidesStatement)parent).getInterfaceReference() == referenceElement) && referenceElement.isQualified()) {
            this.myInterfaceName = referenceElement.getQualifiedName();
        }
    }

    @Nls
    @NotNull
    public String getText() {
        return QuickFixBundle.message("create.service.interface.fix.name", this.myInterfaceName);
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("create.service.interface.fix.family.name", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        GlobalSearchScope projectScope;
        if (this.myInterfaceName == null) {
            return false;
        }
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        return psiFacade.findClass(this.myInterfaceName, projectScope = GlobalSearchScope.projectScope((Project)project)) == null && CreateServiceInterfaceOrClassFix.isQualifierInProject(this.myInterfaceName, project);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        Map<Module, PsiDirectory[]> psiRootDirs;
        PsiPackage psiPackage;
        String qualifierText = StringUtil.getPackageName((String)this.myInterfaceName);
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiClass outerClass = psiFacade.findClass(qualifierText, GlobalSearchScope.projectScope((Project)project));
        if (outerClass != null) {
            this.createClassInOuter(qualifierText, outerClass);
            return;
        }
        do {
            psiPackage = psiFacade.findPackage(qualifierText);
            qualifierText = StringUtil.getPackageName((String)qualifierText);
        } while (psiPackage == null && !StringUtil.isEmpty((String)qualifierText));
        if (psiPackage != null && !(psiRootDirs = CreateServiceInterfaceOrClassFix.getModuleRootDirs(psiPackage)).isEmpty()) {
            PsiDirectory rootDir;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                PsiDirectory rootDir2 = (PsiDirectory)file.getUserData(SERVICE_ROOT_DIR);
                CreateClassKind classKind = (CreateClassKind)file.getUserData(SERVICE_CLASS_KIND);
                if (rootDir2 != null && classKind != null) {
                    WriteAction.run(() -> CreateServiceInterfaceOrClassFix.createClassInRoot(this.myInterfaceName, classKind, rootDir2, (PsiElement)file, null));
                }
                return;
            }
            CreateServiceInterfaceDialog dialog = new CreateServiceInterfaceDialog(project, psiRootDirs);
            if (dialog.showAndGet() && (rootDir = dialog.getRootDir()) != null) {
                CreateClassKind classKind = dialog.getClassKind();
                PsiClass psiClass = (PsiClass)WriteAction.compute(() -> CreateServiceInterfaceOrClassFix.createClassInRoot(this.myInterfaceName, classKind, rootDir, (PsiElement)file, null));
                CreateServiceInterfaceOrClassFix.positionCursor(psiClass);
            }
        }
    }

    @NotNull
    private static Map<Module, PsiDirectory[]> getModuleRootDirs(@NotNull PsiPackage psiPackage) {
        ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance((Project)psiPackage.getProject());
        return ((StreamEx)StreamEx.of((Object[])psiPackage.getDirectories()).map(PsiDirectory::getVirtualFile).map(arg_0 -> ((ProjectFileIndex)index).getSourceRootForFile(arg_0)).nonNull().map(arg_0 -> ((ProjectFileIndex)index).getModuleForFile(arg_0)).nonNull().distinct()).mapToEntry(CreateServiceClassFixBase::getModuleRootDirs).filterValues(dirs -> !ArrayUtil.isEmpty((Object[])dirs)).toMap();
    }

    private void createClassInOuter(@NotNull String qualifierText, @NotNull PsiClass outerClass) {
        String name2 = this.myInterfaceName.substring(qualifierText.length() + 1);
        PsiClass psiClass = (PsiClass)WriteAction.compute(() -> CreateServiceInterfaceOrClassFix.createClassInOuterImpl(name2, outerClass, null));
        CreateServiceInterfaceOrClassFix.positionCursor(psiClass);
    }

    private class CreateServiceInterfaceDialog
    extends DialogWrapper {
        private final ComboBoxWithWidePopup<Module> myModuleCombo;
        private final ComboBoxWithWidePopup<PsiDirectory> myRootDirCombo;
        private final TemplateKindCombo myKindCombo;

        protected CreateServiceInterfaceDialog(@NotNull Project project, Map<Module, PsiDirectory[]> psiRootDirs) {
            super(project);
            this.myModuleCombo = new ComboBoxWithWidePopup();
            this.myRootDirCombo = new ComboBoxWithWidePopup();
            this.myKindCombo = new TemplateKindCombo();
            this.setTitle(QuickFixBundle.message("create.service", new Object[0]));
            this.myModuleCombo.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", Module::getName));
            this.myRootDirCombo.setRenderer((ListCellRenderer)((Object)new CreateServiceClassFixBase.PsiDirectoryListCellRenderer()));
            this.myModuleCombo.addActionListener(e -> this.updateRootDirsCombo(psiRootDirs));
            Module[] modules = psiRootDirs.keySet().toArray(Module.EMPTY_ARRAY);
            Arrays.sort(modules, Comparator.comparing(Module::getName));
            this.myModuleCombo.setModel(new DefaultComboBoxModel<Module>(modules));
            this.updateRootDirsCombo(psiRootDirs);
            this.myKindCombo.addItem(CommonRefactoringUtil.capitalize((String)CreateClassKind.CLASS.getDescription()), PlatformIcons.CLASS_ICON, CreateClassKind.CLASS.name());
            this.myKindCombo.addItem(CommonRefactoringUtil.capitalize((String)CreateClassKind.INTERFACE.getDescription()), PlatformIcons.INTERFACE_ICON, CreateClassKind.INTERFACE.name());
            this.myKindCombo.addItem(CommonRefactoringUtil.capitalize((String)CreateClassKind.ANNOTATION.getDescription()), PlatformIcons.ANNOTATION_TYPE_ICON, CreateClassKind.ANNOTATION.name());
            this.init();
        }

        private void updateRootDirsCombo(@NotNull Map<Module, PsiDirectory[]> psiRootDirs) {
            Module module = (Module)this.myModuleCombo.getSelectedItem();
            PsiDirectory[] moduleRootDirs = psiRootDirs.getOrDefault(module, PsiDirectory.EMPTY_ARRAY);
            this.myRootDirCombo.setModel(new DefaultComboBoxModel<PsiDirectory>(moduleRootDirs));
        }

        protected Action @NotNull [] createActions() {
            return new Action[]{this.getOKAction(), this.getCancelAction()};
        }

        protected JComponent createCenterPanel() {
            return null;
        }

        @Nullable
        protected JComponent createNorthPanel() {
            JTextField nameTextField = new JTextField(CreateServiceInterfaceOrClassFix.this.myInterfaceName);
            nameTextField.setEditable(false);
            PanelGridBuilder builder = UI.PanelFactory.grid();
            builder.add((PanelBuilder)UI.PanelFactory.panel((JComponent)nameTextField).withLabel(CommonBundle.message((String)"label.name", (Object[])new Object[0]) + ":"));
            if (this.myModuleCombo.getModel().getSize() > 1) {
                builder.add((PanelBuilder)UI.PanelFactory.panel(this.myModuleCombo).withLabel(CommonBundle.message((String)"label.module", (Object[])new Object[0]) + ":"));
            }
            if (this.myRootDirCombo.getModel().getSize() > 1) {
                builder.add((PanelBuilder)UI.PanelFactory.panel(this.myRootDirCombo).withLabel(CommonBundle.message((String)"label.source.root", (Object[])new Object[0]) + ":"));
            }
            builder.add((PanelBuilder)UI.PanelFactory.panel((JComponent)this.myKindCombo).withLabel(CommonBundle.message((String)"label.kind", (Object[])new Object[0]) + ":"));
            return builder.createPanel();
        }

        @Nullable
        public PsiDirectory getRootDir() {
            return (PsiDirectory)this.myRootDirCombo.getSelectedItem();
        }

        public CreateClassKind getClassKind() {
            return CreateClassKind.valueOf(this.myKindCombo.getSelectedName());
        }
    }
}

