/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ConvertCollectionToArrayFix
implements IntentionAction {
    private final PsiExpression myCollectionExpression;
    private final PsiExpression myExpressionToReplace;
    private final String myNewArrayText;

    public ConvertCollectionToArrayFix(@NotNull PsiExpression collectionExpression, @NotNull PsiExpression expressionToReplace, @NotNull PsiArrayType arrayType) {
        this.myCollectionExpression = collectionExpression;
        this.myExpressionToReplace = expressionToReplace;
        PsiType componentType = arrayType.getComponentType();
        this.myNewArrayText = componentType.equalsToText("java.lang.Object") ? "" : "new " + ConvertCollectionToArrayFix.getArrayTypeText(componentType);
    }

    @Nls
    @NotNull
    public String getText() {
        return QuickFixBundle.message("collection.to.array.text", this.myNewArrayText);
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("collection.to.array.family.name", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return this.myCollectionExpression.isValid() && BaseIntentionAction.canModify((PsiElement)this.myCollectionExpression) && this.myExpressionToReplace.isValid() && BaseIntentionAction.canModify((PsiElement)this.myExpressionToReplace);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        String replacement = ParenthesesUtils.getText(this.myCollectionExpression, 2) + ".toArray(" + this.myNewArrayText + ")";
        this.myExpressionToReplace.replace((PsiElement)factory.createExpressionFromText(replacement, (PsiElement)this.myCollectionExpression));
    }

    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    private static String getArrayTypeText(PsiType componentType) {
        if (componentType instanceof PsiArrayType) {
            return ConvertCollectionToArrayFix.getArrayTypeText(((PsiArrayType)componentType).getComponentType()) + "[]";
        }
        if (componentType instanceof PsiClassType) {
            return ((PsiClassType)componentType).rawType().getCanonicalText() + "[0]";
        }
        return componentType.getCanonicalText() + "[0]";
    }
}

