/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.StreamApiUtil;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdjustFunctionContextFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private static final Function<PsiMethodCallExpression, Function<PsiType, String>> MAP_NAME_ADJUSTER = call -> type2 -> {
        PsiType inType;
        PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
        if (qualifier != null && type2.equals(inType = StreamApiUtil.getStreamElementType(qualifier.getType()))) {
            return "map";
        }
        if (PsiType.INT.equals(type2)) {
            return "mapToInt";
        }
        if (PsiType.LONG.equals(type2)) {
            return "mapToLong";
        }
        if (PsiType.DOUBLE.equals(type2)) {
            return "mapToDouble";
        }
        return "mapToObj";
    };
    private static final Function<PsiType, String> FLAT_MAP_NAME_ADJUSTER = type2 -> {
        if (InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.stream.IntStream")) {
            return "flatMapToInt";
        }
        if (InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.stream.LongStream")) {
            return "flatMapToLong";
        }
        if (InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.stream.DoubleStream")) {
            return "flatMapToDouble";
        }
        if (InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.stream.Stream")) {
            return "flatMap";
        }
        return null;
    };
    private static final CallMapper<Function<PsiType, String>> METHOD_NAME_ADJUSTER = new CallMapper<Function<PsiMethodCallExpression, Function<PsiType, String>>>().register(CallMatcher.anyOf(CallMatcher.instanceCall("java.util.stream.IntStream", "map", "mapToLong", "mapToDouble"), CallMatcher.instanceCall("java.util.stream.LongStream", "map", "mapToInt", "mapToDouble"), CallMatcher.instanceCall("java.util.stream.DoubleStream", "map", "mapToInt", "mapToLong")), MAP_NAME_ADJUSTER).register((CallMatcher)CallMatcher.instanceCall("java.util.stream.Stream", "flatMap", "flatMapToInt", "flatMapToLong", "flatMapToDouble"), (Function<PsiMethodCallExpression, Function<PsiType, String>>)FLAT_MAP_NAME_ADJUSTER);
    private final String myOriginalName;
    private final String myNewName;

    protected AdjustFunctionContextFix(@NotNull PsiMethodCallExpression call, @NotNull String targetMethodName) {
        super((PsiElement)call);
        this.myOriginalName = call.getMethodExpression().getReferenceName();
        this.myNewName = targetMethodName;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)startElement, PsiMethodCallExpression.class);
        if (call == null) {
            return;
        }
        ExpressionUtils.bindCallTo(call, this.myNewName);
    }

    @NotNull
    public String getText() {
        return QuickFixBundle.message("adjust.method.accepting.functional.expression.fix.text", this.myOriginalName, this.myNewName);
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("adjust.method.accepting.functional.expression.fix.family.name", new Object[0]);
    }

    @Contract(value="null -> null")
    @Nullable
    public static AdjustFunctionContextFix createFix(PsiElement context) {
        PsiType actualReturnType;
        if (!(context instanceof PsiExpression)) {
            return null;
        }
        PsiExpression expression2 = (PsiExpression)context;
        PsiFunctionalExpression fn = (PsiFunctionalExpression)PsiTreeUtil.getParentOfType((PsiElement)context, PsiFunctionalExpression.class, (boolean)false);
        if (fn == null) {
            return null;
        }
        PsiExpressionList expressionList = (PsiExpressionList)ObjectUtils.tryCast((Object)fn.getParent(), PsiExpressionList.class);
        if (expressionList == null || expressionList.getExpressionCount() != 1) {
            return null;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)expressionList.getParent(), PsiMethodCallExpression.class);
        Function<PsiType, String> remapper = METHOD_NAME_ADJUSTER.mapFirst(call);
        if (remapper == null) {
            return null;
        }
        if (expression2 instanceof PsiMethodReferenceExpression) {
            PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)expression2;
            actualReturnType = PsiMethodReferenceUtil.getMethodReferenceReturnType((PsiMethodReferenceExpression)methodRef);
        } else {
            actualReturnType = (PsiType)PsiResolveHelper.ourGraphGuard.doPreventingRecursion((Object)expression2, true, () -> expression2.getType());
        }
        String targetMethodName = remapper.apply(actualReturnType);
        if (targetMethodName == null) {
            return null;
        }
        return new AdjustFunctionContextFix(call, targetMethodName);
    }
}

