/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AddConstructorFix
implements LocalQuickFix,
IntentionAction {
    private final SmartPsiElementPointer<PsiClass> myBeanClass;
    private final List<? extends PsiParameter> myParameters;
    private final String name;

    public AddConstructorFix(PsiClass beanClass, List<? extends PsiParameter> parameters2) {
        this.myBeanClass = SmartPointerManager.getInstance((Project)beanClass.getProject()).createSmartPsiElementPointer((PsiElement)beanClass);
        this.myParameters = parameters2;
        String params = this.myParameters.stream().map(p -> p.getText()).collect(Collectors.joining(", "));
        String signature = beanClass.getName() + "(" + params + ")";
        this.name = QuickFixBundle.message("model.create.constructor.quickfix.message", signature);
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nls
    @NotNull
    public String getText() {
        return this.name;
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("model.create.constructor.quickfix.message.family.name", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        this.applyFix();
    }

    private void applyFix() {
        try {
            if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)this.myBeanClass.getContainingFile())) {
                return;
            }
            PsiClass psiClass = (PsiClass)this.myBeanClass.getElement();
            if (psiClass == null) {
                return;
            }
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.myBeanClass.getProject());
            PsiMethod constructor = elementFactory.createConstructor();
            for (PsiParameter psiParameter : this.myParameters) {
                constructor.getParameterList().add((PsiElement)psiParameter);
            }
            psiClass.add((PsiElement)constructor);
        }
        catch (IncorrectOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        this.applyFix();
    }
}

