/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

public enum HighlightingFeature {
    GENERICS(LanguageLevel.JDK_1_5, "feature.generics"),
    ANNOTATIONS(LanguageLevel.JDK_1_5, "feature.annotations"),
    STATIC_IMPORTS(LanguageLevel.JDK_1_5, "feature.static.imports"),
    FOR_EACH(LanguageLevel.JDK_1_5, "feature.for.each"),
    VARARGS(LanguageLevel.JDK_1_5, "feature.varargs"),
    HEX_FP_LITERALS(LanguageLevel.JDK_1_5, "feature.hex.fp.literals"),
    DIAMOND_TYPES(LanguageLevel.JDK_1_7, "feature.diamond.types"),
    MULTI_CATCH(LanguageLevel.JDK_1_7, "feature.multi.catch"),
    TRY_WITH_RESOURCES(LanguageLevel.JDK_1_7, "feature.try.with.resources"),
    BIN_LITERALS(LanguageLevel.JDK_1_7, "feature.binary.literals"),
    UNDERSCORES(LanguageLevel.JDK_1_7, "feature.underscores.in.literals"),
    EXTENSION_METHODS(LanguageLevel.JDK_1_8, "feature.extension.methods"),
    METHOD_REFERENCES(LanguageLevel.JDK_1_8, "feature.method.references"),
    LAMBDA_EXPRESSIONS(LanguageLevel.JDK_1_8, "feature.lambda.expressions"),
    TYPE_ANNOTATIONS(LanguageLevel.JDK_1_8, "feature.type.annotations"),
    RECEIVERS(LanguageLevel.JDK_1_8, "feature.type.receivers"),
    INTERSECTION_CASTS(LanguageLevel.JDK_1_8, "feature.intersections.in.casts"),
    STATIC_INTERFACE_CALLS(LanguageLevel.JDK_1_8, "feature.static.interface.calls"),
    REFS_AS_RESOURCE(LanguageLevel.JDK_1_9, "feature.try.with.resources.refs"),
    MODULES(LanguageLevel.JDK_1_9, "feature.modules"),
    LVTI(LanguageLevel.JDK_10, "feature.lvti"),
    VAR_LAMBDA_PARAMETER(LanguageLevel.JDK_11, "feature.var.lambda.parameter"),
    ENHANCED_SWITCH(LanguageLevel.JDK_14, "feature.enhanced.switch"),
    SWITCH_EXPRESSION(LanguageLevel.JDK_14, "feature.switch.expressions"),
    RECORDS(LanguageLevel.JDK_14_PREVIEW, "feature.records"),
    PATTERNS(LanguageLevel.JDK_14_PREVIEW, "feature.patterns.instanceof"),
    TEXT_BLOCK_ESCAPES(LanguageLevel.JDK_14_PREVIEW, "feature.text.block.escape.sequences"){

        @Override
        boolean isSufficient(@NotNull LanguageLevel useSiteLevel) {
            return useSiteLevel.isAtLeast(LanguageLevel.JDK_14_PREVIEW);
        }

        @Override
        LanguageLevel getStandardLevel() {
            return LanguageLevel.JDK_15;
        }
    }
    ,
    TEXT_BLOCKS(LanguageLevel.JDK_14_PREVIEW, "feature.text.blocks"){

        @Override
        boolean isSufficient(@NotNull LanguageLevel useSiteLevel) {
            return useSiteLevel.isAtLeast(LanguageLevel.JDK_14_PREVIEW);
        }

        @Override
        LanguageLevel getStandardLevel() {
            return LanguageLevel.JDK_15;
        }
    }
    ,
    SEALED_CLASSES(LanguageLevel.JDK_15_PREVIEW, "feature.sealed.classes"),
    LOCAL_INTERFACES(LanguageLevel.JDK_15_PREVIEW, "feature.local.interfaces"),
    LOCAL_ENUMS(LanguageLevel.JDK_15_PREVIEW, "feature.local.enums");

    final LanguageLevel level;
    @PropertyKey(resourceBundle="messages.JavaErrorBundle")
    final String key;

    private HighlightingFeature(LanguageLevel level, String key2) {
        this.level = level;
        this.key = key2;
    }

    public boolean isAvailable(@NotNull PsiElement element) {
        return this.isSufficient(PsiUtil.getLanguageLevel((PsiElement)element));
    }

    boolean isSufficient(@NotNull LanguageLevel useSiteLevel) {
        return useSiteLevel.isAtLeast(this.level) && (!this.level.isPreview() || useSiteLevel.isPreview());
    }

    LanguageLevel getStandardLevel() {
        return this.level.isPreview() ? null : this.level;
    }
}

