/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInsight.daemon.impl.GlobalUsageHelper;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.ex.EntryPointsManagerBase;
import com.intellij.codeInspection.reference.UnusedDeclarationFixProvider;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.JavaClassFindUsagesOptions;
import com.intellij.find.findUsages.JavaFindUsagesHelper;
import com.intellij.find.findUsages.JavaFindUsagesOptions;
import com.intellij.find.findUsages.JavaMethodFindUsagesOptions;
import com.intellij.find.findUsages.JavaPackageFindUsagesOptions;
import com.intellij.find.findUsages.JavaVariableFindUsagesOptions;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.FindSuperElementsHelper;
import com.intellij.psi.impl.source.PsiClassImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DeepestSuperMethodsSearch;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnusedSymbolUtil {
    public static boolean isInjected(@NotNull Project project, @NotNull PsiModifierListOwner modifierListOwner) {
        return EntryPointsManagerBase.getInstance(project).isEntryPoint((PsiElement)modifierListOwner);
    }

    public static boolean isImplicitUsage(@NotNull Project project, @NotNull PsiModifierListOwner element) {
        if (UnusedSymbolUtil.isInjected(project, element)) {
            return true;
        }
        for (ImplicitUsageProvider provider : ImplicitUsageProvider.EP_NAME.getExtensionList()) {
            ProgressManager.checkCanceled();
            if (!provider.isImplicitUsage((PsiElement)element)) continue;
            return true;
        }
        return false;
    }

    public static boolean isImplicitRead(@NotNull PsiVariable variable) {
        return UnusedSymbolUtil.isImplicitRead(variable.getProject(), variable);
    }

    public static boolean isImplicitRead(@NotNull Project project, @NotNull PsiVariable element) {
        for (ImplicitUsageProvider provider : ImplicitUsageProvider.EP_NAME.getExtensionList()) {
            ProgressManager.checkCanceled();
            if (!provider.isImplicitRead((PsiElement)element)) continue;
            return true;
        }
        return UnusedSymbolUtil.isInjected(project, (PsiModifierListOwner)element);
    }

    public static boolean isImplicitWrite(@NotNull PsiVariable variable) {
        return UnusedSymbolUtil.isImplicitWrite(variable.getProject(), variable);
    }

    public static boolean isImplicitWrite(@NotNull Project project, @NotNull PsiVariable element) {
        for (ImplicitUsageProvider provider : ImplicitUsageProvider.EP_NAME.getExtensionList()) {
            ProgressManager.checkCanceled();
            if (!provider.isImplicitWrite((PsiElement)element)) continue;
            return true;
        }
        return EntryPointsManager.getInstance((Project)project).isImplicitWrite((PsiElement)element);
    }

    @Nullable
    public static HighlightInfo createUnusedSymbolInfo(@NotNull PsiElement element, @NotNull String message2, @NotNull HighlightInfoType highlightInfoType) {
        HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)highlightInfoType).range(element).descriptionAndTooltip(message2).group(5).create();
        if (info == null) {
            return null;
        }
        for (UnusedDeclarationFixProvider provider : UnusedDeclarationFixProvider.EP_NAME.getExtensionList()) {
            IntentionAction[] fixes;
            for (IntentionAction fix : fixes = provider.getQuickFixes(element)) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)fix);
            }
        }
        return info;
    }

    public static boolean isFieldUnused(@NotNull Project project, @NotNull PsiFile containingFile, @NotNull PsiField field, @NotNull ProgressIndicator progress, @NotNull GlobalUsageHelper helper) {
        if (helper.isLocallyUsed((PsiNamedElement)field)) {
            return false;
        }
        if (field instanceof PsiEnumConstant && UnusedSymbolUtil.isEnumValuesMethodUsed(project, containingFile, (PsiMember)field, progress, helper)) {
            return false;
        }
        return UnusedSymbolUtil.weAreSureThereAreNoUsages(project, containingFile, (PsiMember)field, progress, helper);
    }

    public static boolean isMethodReferenced(@NotNull Project project, @NotNull PsiFile containingFile, @NotNull PsiMethod method, @NotNull ProgressIndicator progress, @NotNull GlobalUsageHelper helper) {
        if (helper.isLocallyUsed((PsiNamedElement)method)) {
            return true;
        }
        boolean isPrivate = method.hasModifierProperty("private");
        PsiClass containingClass = method.getContainingClass();
        if (JavaHighlightUtil.isSerializationRelatedMethod(method, containingClass)) {
            return true;
        }
        if (isPrivate) {
            if (UnusedSymbolUtil.isIntentionalPrivateConstructor(method, containingClass)) {
                return true;
            }
            if (UnusedSymbolUtil.isImplicitUsage(project, (PsiModifierListOwner)method)) {
                return true;
            }
            if (!helper.isCurrentFileAlreadyChecked()) {
                return !UnusedSymbolUtil.weAreSureThereAreNoUsages(project, containingFile, (PsiMember)method, progress, helper);
            }
        } else {
            if (UnusedSymbolUtil.isTheOnlyConstructor(method, containingClass) && UnusedSymbolUtil.isClassUsed(project, containingFile, containingClass, progress, helper)) {
                return true;
            }
            if (UnusedSymbolUtil.isImplicitUsage(project, (PsiModifierListOwner)method)) {
                return true;
            }
            if (!method.isConstructor() && FindSuperElementsHelper.findSuperElements((PsiElement)method).length != 0) {
                return true;
            }
            return !UnusedSymbolUtil.weAreSureThereAreNoUsages(project, containingFile, (PsiMember)method, progress, helper);
        }
        return false;
    }

    private static boolean isTheOnlyConstructor(@NotNull PsiMethod method, @Nullable PsiClass containingClass) {
        return method.isConstructor() && containingClass != null && containingClass.getConstructors().length == 1;
    }

    private static boolean weAreSureThereAreNoUsages(@NotNull Project project, @NotNull PsiFile containingFile, @NotNull PsiMember member, @NotNull ProgressIndicator progress, @NotNull GlobalUsageHelper helper) {
        UnusedSymbolUtil.log("* " + member.getName() + ": call wearesure");
        if (!helper.shouldCheckUsages(member)) {
            UnusedSymbolUtil.log("* " + member.getName() + ": should not check");
            return false;
        }
        PsiFile ignoreFile = helper.isCurrentFileAlreadyChecked() ? containingFile : null;
        boolean sure = UnusedSymbolUtil.processUsages(project, containingFile, member, progress, ignoreFile, (Processor<? super UsageInfo>)((Processor)info -> {
            PsiFile psiFile = info.getFile();
            if (psiFile == ignoreFile || psiFile == null) {
                return true;
            }
            int offset = info.getNavigationOffset();
            if (offset == -1) {
                return true;
            }
            PsiElement element = psiFile.findElementAt(offset);
            boolean inComment = element instanceof PsiComment;
            UnusedSymbolUtil.log("*     " + member.getName() + ": usage :" + element);
            return inComment;
        }));
        UnusedSymbolUtil.log("*     " + member.getName() + ": result:" + sure);
        return sure;
    }

    private static void log(String s) {
    }

    public static boolean processUsages(@NotNull Project project, @NotNull PsiFile containingFile, @NotNull PsiMember member, @NotNull ProgressIndicator progress, @Nullable PsiFile ignoreFile, @NotNull Processor<? super UsageInfo> usageInfoProcessor) {
        JavaFindUsagesOptions options;
        String name2 = member.getName();
        if (name2 == null) {
            UnusedSymbolUtil.log("* " + member.getName() + " no name; false");
            return false;
        }
        SearchScope useScope = member.getUseScope();
        PsiSearchHelper searchHelper = PsiSearchHelper.getInstance((Project)project);
        if (useScope instanceof GlobalSearchScope) {
            SearchScope fileScope;
            String propertyName;
            PsiSearchHelper.SearchCostResult cheapEnough;
            if (member instanceof PsiClass) {
                useScope = GlobalSearchScope.projectScope((Project)project).uniteWith((GlobalSearchScope)useScope);
            }
            if ((cheapEnough = searchHelper.isCheapEnoughToSearch(name2, (GlobalSearchScope)useScope, ignoreFile, progress)) == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES && (member.hasModifierProperty("public") || member.hasModifierProperty("protected"))) {
                UnusedSymbolUtil.log("* " + member.getName() + " too many usages; false");
                return false;
            }
            if (cheapEnough == PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES && !UnusedSymbolUtil.canBeReferencedViaWeirdNames(member, containingFile)) {
                UnusedSymbolUtil.log("* " + member.getName() + " 0 usages; true");
                return true;
            }
            if (member instanceof PsiMethod && member.hasModifierProperty("public") && (propertyName = PropertyUtilBase.getPropertyName((PsiMember)member)) != null && (fileScope = containingFile.getUseScope()) instanceof GlobalSearchScope && searchHelper.isCheapEnoughToSearch(propertyName, (GlobalSearchScope)fileScope, ignoreFile, progress) == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
                UnusedSymbolUtil.log("* " + member.getName() + " too many prop usages; false");
                return false;
            }
        }
        SmartList toSearch = new SmartList((Object)member);
        if (member instanceof PsiPackage) {
            options = new JavaPackageFindUsagesOptions(useScope);
            ((FindUsagesOptions)options).isSearchForTextOccurrences = true;
        } else if (member instanceof PsiClass) {
            options = new JavaClassFindUsagesOptions(useScope);
            ((FindUsagesOptions)options).isSearchForTextOccurrences = true;
        } else if (member instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)member;
            options = new JavaMethodFindUsagesOptions(useScope);
            ((FindUsagesOptions)options).isSearchForTextOccurrences = method.isConstructor();
            toSearch.addAll(DeepestSuperMethodsSearch.search((PsiMethod)method).findAll());
        } else if (member instanceof PsiVariable) {
            options = new JavaVariableFindUsagesOptions(useScope);
            ((FindUsagesOptions)options).isSearchForTextOccurrences = false;
        } else {
            options = new FindUsagesOptions(useScope);
            ((FindUsagesOptions)options).isSearchForTextOccurrences = true;
        }
        ((FindUsagesOptions)options).isUsages = true;
        return ContainerUtil.process((Iterable)toSearch, arg_0 -> UnusedSymbolUtil.lambda$processUsages$1((FindUsagesOptions)options, usageInfoProcessor, arg_0));
    }

    private static boolean isEnumValuesMethodUsed(@NotNull Project project, @NotNull PsiFile containingFile, @NotNull PsiMember member, @NotNull ProgressIndicator progress, @NotNull GlobalUsageHelper helper) {
        PsiClass containingClass = member.getContainingClass();
        if (!(containingClass instanceof PsiClassImpl)) {
            return true;
        }
        PsiMethod valuesMethod = ((PsiClassImpl)containingClass).getValuesMethod();
        return valuesMethod == null || UnusedSymbolUtil.isMethodReferenced(project, containingFile, valuesMethod, progress, helper);
    }

    private static boolean canBeReferencedViaWeirdNames(@NotNull PsiMember member, @NotNull PsiFile containingFile) {
        if (member instanceof PsiClass) {
            return false;
        }
        if (!(containingFile instanceof PsiJavaFile)) {
            return true;
        }
        if (member instanceof PsiField) {
            return false;
        }
        if (member instanceof PsiMethod) {
            return PropertyUtilBase.isSimplePropertyAccessor((PsiMethod)((PsiMethod)member));
        }
        return false;
    }

    public static boolean isClassUsed(@NotNull Project project, @NotNull PsiFile containingFile, @NotNull PsiClass aClass, @NotNull ProgressIndicator progress, @NotNull GlobalUsageHelper helper) {
        Boolean result = helper.unusedClassCache.get(aClass);
        if (result == null) {
            result = UnusedSymbolUtil.isReallyUsed(project, containingFile, aClass, progress, helper);
            helper.unusedClassCache.put(aClass, result);
        }
        return result;
    }

    private static boolean isReallyUsed(@NotNull Project project, @NotNull PsiFile containingFile, @NotNull PsiClass aClass, @NotNull ProgressIndicator progress, @NotNull GlobalUsageHelper helper) {
        if (UnusedSymbolUtil.isImplicitUsage(project, (PsiModifierListOwner)aClass) || helper.isLocallyUsed((PsiNamedElement)aClass)) {
            return true;
        }
        if (helper.isCurrentFileAlreadyChecked() && (aClass.getContainingClass() != null && aClass.hasModifierProperty("private") || aClass.getParent() instanceof PsiDeclarationStatement || aClass instanceof PsiTypeParameter)) {
            return false;
        }
        return !UnusedSymbolUtil.weAreSureThereAreNoUsages(project, containingFile, (PsiMember)aClass, progress, helper);
    }

    private static boolean isIntentionalPrivateConstructor(@NotNull PsiMethod method, PsiClass containingClass) {
        return method.isConstructor() && containingClass != null && containingClass.getConstructors().length == 1;
    }

    private static /* synthetic */ boolean lambda$processUsages$1(FindUsagesOptions options, Processor usageInfoProcessor, PsiMember m) {
        return JavaFindUsagesHelper.processElementUsages((PsiElement)m, options, (Processor<? super UsageInfo>)usageInfoProcessor);
    }
}

