/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.java.JavaBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ElementColorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.uast.UastMetaLanguage;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.evaluation.UEvaluationContextKt;
import org.jetbrains.uast.values.UConstant;
import org.jetbrains.uast.values.UValue;

public class JavaColorProvider
implements ElementColorProvider {
    UastMetaLanguage myUastMetaLanguage = (UastMetaLanguage)Language.findInstance(UastMetaLanguage.class);

    public Color getColorFrom(@NotNull PsiElement element) {
        UCallExpression newExpression;
        if (element.getFirstChild() != null) {
            return null;
        }
        if (element instanceof PsiWhiteSpace) {
            return null;
        }
        if (!this.myUastMetaLanguage.matchesLanguage(element.getLanguage())) {
            return null;
        }
        PsiElement parent = element.getParent();
        Color color = JavaColorProvider.getJavaColorFromExpression(parent, newExpression = (UCallExpression)UastUtils.findContaining((PsiElement)parent, UCallExpression.class));
        if (color == null) {
            parent = parent == null ? null : parent.getParent();
            color = JavaColorProvider.getJavaColorFromExpression(parent);
        }
        if (newExpression != null && color != null) {
            String resolvedName;
            UReferenceExpression uRef = newExpression.getClassReference();
            String string = resolvedName = uRef == null ? null : uRef.getResolvedName();
            if (resolvedName != null && element.textMatches((CharSequence)resolvedName)) {
                return color;
            }
        }
        if (JavaColorProvider.isIntLiteralInsideNewJBColorExpression(parent)) {
            return color;
        }
        return null;
    }

    public static boolean isColorType(@Nullable PsiType type2) {
        String fqn;
        PsiClass aClass;
        return type2 != null && (aClass = PsiTypesUtil.getPsiClass((PsiType)type2)) != null && ("java.awt.Color".equals(fqn = aClass.getQualifiedName()) || "javax.swing.plaf.ColorUIResource".equals(fqn));
    }

    @Nullable
    public static Color getJavaColorFromExpression(@Nullable PsiElement element) {
        UCallExpression newExpression = (UCallExpression)UastUtils.findContaining((PsiElement)element, UCallExpression.class);
        return JavaColorProvider.getJavaColorFromExpression(element, newExpression);
    }

    @Nullable
    private static Color getJavaColorFromExpression(@Nullable PsiElement element, @Nullable UCallExpression newExpression) {
        if (newExpression != null && newExpression.getKind() == UastCallKind.CONSTRUCTOR_CALL && JavaColorProvider.isColorType(newExpression.getReturnType())) {
            return JavaColorProvider.getColor(newExpression.getValueArguments());
        }
        if (JavaColorProvider.isIntLiteralInsideNewJBColorExpression(element)) {
            String text2 = element.getText();
            boolean hasAlpha = text2 != null && StringUtil.startsWithIgnoreCase((String)text2, (String)"0x") && text2.length() > 8;
            ULiteralExpression literal = (ULiteralExpression)UastContextKt.toUElement((PsiElement)element, ULiteralExpression.class);
            Object object = JavaColorProvider.getObject((UExpression)literal);
            if (object instanceof Integer) {
                return new Color((Integer)object, hasAlpha);
            }
        }
        return null;
    }

    private static boolean isIntLiteralInsideNewJBColorExpression(PsiElement element) {
        UElement parent;
        ULiteralExpression literalExpression = (ULiteralExpression)UastContextKt.toUElement((PsiElement)element, ULiteralExpression.class);
        if (literalExpression != null && PsiType.INT.equals((Object)literalExpression.getExpressionType()) && (parent = literalExpression.getUastParent()) != null) {
            return JavaColorProvider.isNewJBColorExpression(parent);
        }
        return false;
    }

    private static boolean isNewJBColorExpression(UElement element) {
        UCallExpression callExpression;
        if (element instanceof UCallExpression && (callExpression = (UCallExpression)element).getKind() == UastCallKind.CONSTRUCTOR_CALL) {
            PsiClass psiClass = PsiTypesUtil.getPsiClass((PsiType)callExpression.getReturnType());
            return psiClass != null && JBColor.class.getName().equals(psiClass.getQualifiedName());
        }
        return false;
    }

    @Nullable
    private static Color getColor(List<? extends UExpression> args) {
        try {
            Enum type2;
            Enum enum_ = type2 = args.isEmpty() ? null : JavaColorProvider.getConstructorType(args.size(), args.get(0).getExpressionType());
            if (type2 != null) {
                switch (1.$SwitchMap$com$intellij$codeInsight$daemon$impl$JavaColorProvider$ColorConstructors[type2.ordinal()]) {
                    case 1: {
                        return new Color(JavaColorProvider.getInt(args.get(0)));
                    }
                    case 2: {
                        return new Color(JavaColorProvider.getInt(args.get(0)), JavaColorProvider.getBoolean(args.get(1)));
                    }
                    case 3: {
                        return new Color(JavaColorProvider.getInt(args.get(0)), JavaColorProvider.getInt(args.get(1)), JavaColorProvider.getInt(args.get(2)));
                    }
                    case 4: {
                        return new Color(JavaColorProvider.getInt(args.get(0)), JavaColorProvider.getInt(args.get(1)), JavaColorProvider.getInt(args.get(2)), JavaColorProvider.getInt(args.get(3)));
                    }
                    case 5: {
                        return new Color(JavaColorProvider.getFloat(args.get(0)), JavaColorProvider.getFloat(args.get(1)), JavaColorProvider.getFloat(args.get(2)));
                    }
                    case 6: {
                        return new Color(JavaColorProvider.getFloat(args.get(0)), JavaColorProvider.getFloat(args.get(1)), JavaColorProvider.getFloat(args.get(2)), JavaColorProvider.getFloat(args.get(3)));
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    private static ColorConstructors getConstructorType(int paramCount, PsiType paramType) {
        switch (paramCount) {
            case 1: {
                return ColorConstructors.INT;
            }
            case 2: {
                return ColorConstructors.INT_BOOL;
            }
            case 3: {
                return PsiType.INT.equals((Object)paramType) ? ColorConstructors.INT_x3 : ColorConstructors.FLOAT_x3;
            }
            case 4: {
                return PsiType.INT.equals((Object)paramType) ? ColorConstructors.INT_x4 : ColorConstructors.FLOAT_x4;
            }
        }
        return null;
    }

    public static int getInt(UExpression expr2) {
        return (Integer)JavaColorProvider.getObject(expr2);
    }

    public static float getFloat(UExpression expr2) {
        return ((Float)JavaColorProvider.getObject(expr2)).floatValue();
    }

    public static int getInt(PsiExpression expr2) {
        return (Integer)JavaColorProvider.getObject(expr2);
    }

    public static float getFloat(PsiExpression expr2) {
        return ((Float)JavaColorProvider.getObject(expr2)).floatValue();
    }

    public static boolean getBoolean(UExpression expr2) {
        return (Boolean)JavaColorProvider.getObject(expr2);
    }

    private static Object getObject(PsiExpression expr2) {
        return JavaConstantExpressionEvaluator.computeConstantExpression(expr2, true);
    }

    private static Object getObject(UExpression expr2) {
        UValue value2 = UEvaluationContextKt.uValueOf((UExpression)expr2);
        if (value2 == null) {
            return null;
        }
        UConstant constant = value2.toConstant();
        if (constant == null) {
            return null;
        }
        return constant.getValue();
    }

    public void setColorTo(@NotNull PsiElement element, @NotNull Color color) {
        Runnable command;
        Document document = PsiDocumentManager.getInstance((Project)element.getProject()).getDocument(element.getContainingFile());
        if (JavaColorProvider.isIntLiteralInsideNewJBColorExpression(element)) {
            command = () -> JavaColorProvider.replaceInt((PsiExpression)element, color.getRGB(), true, color.getAlpha() != 255);
        } else {
            ColorConstructors type2;
            PsiNewExpression expression2 = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiNewExpression.class);
            if (expression2 == null) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            assert (argumentList != null);
            PsiExpression[] expr2 = argumentList.getExpressions();
            PsiType[] expressionTypes = argumentList.getExpressionTypes();
            ColorConstructors colorConstructors = type2 = expressionTypes.length == 0 ? null : JavaColorProvider.getConstructorType(expressionTypes.length, expressionTypes[0]);
            assert (type2 != null);
            command = () -> {
                switch (type2) {
                    case INT: {
                        if (color.getAlpha() == 255) {
                            JavaColorProvider.replaceInt(expr2[0], color.getRGB(), true);
                        } else {
                            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)argumentList.getProject());
                            argumentList.add((PsiElement)factory.createExpressionFromText("true", null));
                            JavaColorProvider.replaceInt(expr2[0], color.getRGB() | color.getAlpha() << 24, true, true);
                        }
                        return;
                    }
                    case INT_BOOL: {
                        if ("true".equals(expr2[1].getText())) {
                            JavaColorProvider.replaceInt(expr2[0], color.getRGB() | color.getAlpha() << 24, true, true);
                        } else if (color.getAlpha() == 255) {
                            JavaColorProvider.replaceInt(expr2[0], color.getRGB(), true);
                        } else {
                            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)argumentList.getProject());
                            expr2[1].replace((PsiElement)factory.createExpressionFromText("true", null));
                            JavaColorProvider.replaceInt(expr2[0], color.getRGB() | color.getAlpha() << 24, true, true);
                        }
                        return;
                    }
                    case INT_x3: 
                    case INT_x4: {
                        JavaColorProvider.replaceInt(expr2[0], color.getRed());
                        JavaColorProvider.replaceInt(expr2[1], color.getGreen());
                        JavaColorProvider.replaceInt(expr2[2], color.getBlue());
                        if (type2 == ColorConstructors.INT_x4) {
                            JavaColorProvider.replaceInt(expr2[3], color.getAlpha());
                        } else if (color.getAlpha() != 255) {
                            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)argumentList.getProject());
                            String text2 = String.valueOf(color.getAlpha());
                            argumentList.add((PsiElement)factory.createExpressionFromText(text2, null));
                        }
                        return;
                    }
                    case FLOAT_x3: 
                    case FLOAT_x4: {
                        float[] rgba = color.getColorComponents(null);
                        JavaColorProvider.replaceFloat(expr2[0], rgba[0]);
                        JavaColorProvider.replaceFloat(expr2[1], rgba[1]);
                        JavaColorProvider.replaceFloat(expr2[2], rgba[2]);
                        if (type2 == ColorConstructors.FLOAT_x4) {
                            JavaColorProvider.replaceFloat(expr2[3], rgba.length == 4 ? rgba[3] : 0.0f);
                            break;
                        }
                        if (color.getAlpha() == 255) break;
                        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)argumentList.getProject());
                        String text3 = String.valueOf(color.getAlpha());
                        argumentList.add((PsiElement)factory.createExpressionFromText(text3 + "f", null));
                    }
                }
            };
        }
        CommandProcessor.getInstance().executeCommand(element.getProject(), command, JavaBundle.message((String)"change.color.command.text", (Object[])new Object[0]), null, document);
    }

    private static void replaceInt(PsiExpression expr2, int newValue) {
        JavaColorProvider.replaceInt(expr2, newValue, false);
    }

    private static void replaceInt(PsiExpression expr2, int newValue, boolean hex) {
        JavaColorProvider.replaceInt(expr2, newValue, hex, false);
    }

    private static void replaceInt(PsiExpression expr2, int newValue, boolean hex, boolean hasAlpha) {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)expr2.getProject());
        if (JavaColorProvider.getInt(expr2) != newValue) {
            String text2;
            if (hex) {
                text2 = "0x";
                Color c = new Color(newValue, hasAlpha);
                if (hasAlpha) {
                    text2 = text2 + StringUtil.toUpperCase((String)Integer.toHexString(c.getAlpha()));
                }
                text2 = text2 + StringUtil.toUpperCase((String)ColorUtil.toHex((Color)c));
            } else {
                text2 = Integer.toString(newValue);
            }
            expr2.replace((PsiElement)factory.createExpressionFromText(text2, null));
        }
    }

    private static void replaceFloat(PsiExpression expr2, float newValue) {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)expr2.getProject());
        if (JavaColorProvider.getFloat(expr2) != newValue) {
            expr2.replace((PsiElement)factory.createExpressionFromText(newValue + "f", null));
        }
    }

    private static enum ColorConstructors {
        INT,
        INT_BOOL,
        INT_x3,
        INT_x4,
        FLOAT_x3,
        FLOAT_x4;

    }
}

