/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInsight.daemon.RainbowVisitor;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.ide.highlighter.JavaHighlightingColors;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.javadoc.PsiDocParamRef;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaRainbowVisitor
extends RainbowVisitor {
    public boolean suitableForFile(@NotNull PsiFile file) {
        return file instanceof PsiJavaFile;
    }

    public void visit(@NotNull PsiElement element) {
        PsiElement context;
        if ((element instanceof PsiReferenceExpression || element instanceof PsiLocalVariable || element instanceof PsiParameter || element instanceof PsiDocParamRef) && (context = PsiTreeUtil.findFirstParent((PsiElement)element, p -> p instanceof PsiMethod || p instanceof PsiClassInitializer || p instanceof PsiLambdaExpression)) != null) {
            PsiElement rainbowElement;
            Object object = rainbowElement = element instanceof PsiReferenceExpression || element instanceof PsiDocParamRef ? element : ((PsiVariable)element).getNameIdentifier();
            PsiElement resolved = element instanceof PsiReferenceExpression ? ((PsiReferenceExpression)element).resolve() : (element instanceof PsiDocParamRef ? (element.getReference() == null ? null : element.getReference().resolve()) : element);
            HighlightInfo attrs = this.getRainbowSymbolKey(context, rainbowElement, resolved);
            this.addInfo(attrs);
        }
    }

    @Nullable
    private HighlightInfo getRainbowSymbolKey(@NotNull PsiElement context, PsiElement rainbowElement, PsiElement resolved) {
        String name2;
        if (rainbowElement == null || resolved == null) {
            return null;
        }
        if (PsiUtil.isJvmLocalVariable((PsiElement)resolved) && (name2 = ((PsiVariable)resolved).getName()) != null) {
            return this.getInfo(context, rainbowElement, name2, resolved instanceof PsiLocalVariable ? JavaHighlightingColors.LOCAL_VARIABLE_ATTRIBUTES : (rainbowElement instanceof PsiDocTagValue ? JavaHighlightingColors.DOC_COMMENT_TAG_VALUE : JavaHighlightingColors.PARAMETER_ATTRIBUTES));
        }
        return null;
    }

    @NotNull
    public HighlightVisitor clone() {
        return new JavaRainbowVisitor();
    }
}

