/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.completion.ChainedCallCompletion;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.ReferenceExpressionCompletionContributor;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.TypedLookupItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.filters.TrueFilter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Consumer;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collector;
import org.jetbrains.annotations.NotNull;

class StreamConversion {
    StreamConversion() {
    }

    static List<LookupElement> addToStreamConversion(PsiReferenceExpression ref, CompletionParameters parameters2) {
        PsiExpression qualifier = ref.getQualifierExpression();
        if (qualifier == null) {
            return Collections.emptyList();
        }
        PsiType type2 = qualifier.getType();
        if (type2 instanceof PsiClassType) {
            PsiClass qualifierClass = ((PsiClassType)type2).resolve();
            if (qualifierClass == null || InheritanceUtil.isInheritor((PsiClass)qualifierClass, (String)"java.util.stream.BaseStream")) {
                return Collections.emptyList();
            }
            PsiMethod streamMethod = (PsiMethod)ContainerUtil.find((Object[])qualifierClass.findMethodsByName("stream", true), m -> !m.hasParameters());
            if (streamMethod == null || streamMethod.hasModifierProperty("static") || !PsiUtil.isAccessible((PsiMember)streamMethod, (PsiElement)ref, null) || !InheritanceUtil.isInheritor((PsiType)streamMethod.getReturnType(), (String)"java.util.stream.BaseStream")) {
                return Collections.emptyList();
            }
            return StreamConversion.generateStreamSuggestions(parameters2, qualifier, qualifier.getText() + ".stream()", (Consumer<InsertionContext>)((Consumer)context -> {
                String space = ReferenceExpressionCompletionContributor.getSpace(CodeStyle.getLanguageSettings((PsiFile)context.getFile()).SPACE_WITHIN_EMPTY_METHOD_CALL_PARENTHESES);
                context.getDocument().insertString(context.getStartOffset(), (CharSequence)("stream(" + space + ")."));
            }));
        }
        if (type2 instanceof PsiArrayType) {
            String arraysStream = "java.util.Arrays.stream";
            return StreamConversion.generateStreamSuggestions(parameters2, qualifier, arraysStream + "(" + qualifier.getText() + ")", (Consumer<InsertionContext>)((Consumer)context -> StreamConversion.wrapQualifiedIntoMethodCall(context, arraysStream)));
        }
        return Collections.emptyList();
    }

    @NotNull
    private static List<LookupElement> generateStreamSuggestions(CompletionParameters parameters2, PsiExpression qualifier, String changedQualifier, Consumer<InsertionContext> beforeInsertion) {
        String refText = changedQualifier + ".x";
        PsiExpression expr2 = PsiElementFactory.getInstance((Project)qualifier.getProject()).createExpressionFromText(refText, (PsiElement)qualifier);
        if (!(expr2 instanceof PsiReferenceExpression)) {
            return Collections.emptyList();
        }
        Set<LookupElement> streamSuggestions = ReferenceExpressionCompletionContributor.completeFinalReference((PsiElement)qualifier, (PsiJavaCodeReferenceElement)((PsiReferenceExpression)expr2), TrueFilter.INSTANCE, (PsiType)PsiType.getJavaLangObject((PsiManager)qualifier.getManager(), (GlobalSearchScope)qualifier.getResolveScope()), parameters2);
        return ContainerUtil.mapNotNull(streamSuggestions, e -> ChainedCallCompletion.OBJECT_METHOD_PATTERN.accepts(e.getObject()) ? null : new StreamMethodInvocation((LookupElement)e, (Consumer<? super InsertionContext>)beforeInsertion));
    }

    private static void wrapQualifiedIntoMethodCall(@NotNull InsertionContext context, @NotNull String methodQualifiedName) {
        PsiElement qualifier;
        PsiFile file = context.getFile();
        PsiReferenceExpression ref = (PsiReferenceExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)context.getStartOffset(), PsiReferenceExpression.class, (boolean)false);
        if (ref != null && (qualifier = ref.getQualifier()) != null) {
            TextRange range = qualifier.getTextRange();
            int startOffset = range.getStartOffset();
            String callSpace = ReferenceExpressionCompletionContributor.getSpace(CodeStyle.getLanguageSettings((PsiFile)file).SPACE_WITHIN_METHOD_CALL_PARENTHESES);
            context.getDocument().insertString(range.getEndOffset(), (CharSequence)(callSpace + ")"));
            context.getDocument().insertString(startOffset, (CharSequence)(methodQualifiedName + "(" + callSpace));
            context.commitDocument();
            Project project = context.getProject();
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)file, startOffset, startOffset + methodQualifiedName.length());
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(context.getDocument());
        }
    }

    static void addCollectConversion(PsiReferenceExpression ref, Collection<? extends ExpectedTypeInfo> expectedTypes, Consumer<? super LookupElement> consumer) {
        PsiClass collectors = JavaPsiFacade.getInstance((Project)ref.getProject()).findClass("java.util.stream.Collectors", ref.getResolveScope());
        if (collectors == null) {
            return;
        }
        PsiExpression qualifier = ref.getQualifierExpression();
        if (qualifier == null) {
            if (ref.getParent() instanceof PsiExpressionList && ref.getParent().getParent() instanceof PsiMethodCallExpression) {
                PsiReferenceExpression methodExpression = ((PsiMethodCallExpression)ref.getParent().getParent()).getMethodExpression();
                qualifier = methodExpression.getQualifierExpression();
                if ("collect".equals(methodExpression.getReferenceName()) && qualifier != null) {
                    StreamConversion.suggestCollectorsArgument(expectedTypes, consumer, collectors, qualifier);
                }
            }
            return;
        }
        StreamConversion.convertQualifierViaCollectors(ref, expectedTypes, consumer, qualifier, collectors);
    }

    private static void suggestCollectorsArgument(Collection<? extends ExpectedTypeInfo> expectedTypes, Consumer<? super LookupElement> consumer, PsiClass collectors, PsiExpression qualifier) {
        PsiType matchingExpectation = (PsiType)JBIterable.from(expectedTypes).map(ExpectedTypeInfo::getType).find(t -> TypeConversionUtil.erasure((PsiType)t).equalsToText(Collector.class.getName()));
        if (matchingExpectation == null) {
            return;
        }
        for (Pair<String, PsiType> pair2 : StreamConversion.suggestCollectors(Arrays.asList(ExpectedTypesProvider.getExpectedTypes(qualifier, true)), qualifier)) {
            for (PsiMethod method : collectors.findMethodsByName((String)pair2.first, false)) {
                JavaMethodCallElement item = new JavaMethodCallElement(method, false, false);
                item.setAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
                item.setInferenceSubstitutorFromExpectedType((PsiElement)qualifier, matchingExpectation);
                consumer.consume((Object)PrioritizedLookupElement.withPriority((LookupElement)item, (double)1.0));
            }
        }
    }

    private static void convertQualifierViaCollectors(PsiReferenceExpression ref, Collection<? extends ExpectedTypeInfo> expectedTypes, Consumer<? super LookupElement> consumer, PsiExpression qualifier, @NotNull PsiClass collectors) {
        for (Pair<String, PsiType> pair2 : StreamConversion.suggestCollectors(expectedTypes, qualifier)) {
            if (collectors.findMethodsByName((String)pair2.first, true).length == 0) continue;
            consumer.consume((Object)new CollectLookupElement((String)pair2.first, (PsiType)pair2.second, (PsiElement)ref));
        }
    }

    private static List<Pair<String, PsiType>> suggestCollectors(Collection<? extends ExpectedTypeInfo> expectedTypes, PsiExpression qualifier) {
        PsiType component = PsiUtil.substituteTypeParameter((PsiType)qualifier.getType(), (String)"java.util.stream.Stream", (int)0, (boolean)true);
        if (component == null) {
            return Collections.emptyList();
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)qualifier.getProject());
        PsiElementFactory factory = facade.getElementFactory();
        GlobalSearchScope scope = qualifier.getResolveScope();
        boolean joiningApplicable = InheritanceUtil.isInheritor((PsiType)component, (String)CharSequence.class.getName());
        PsiClass list = facade.findClass("java.util.List", scope);
        PsiClass set = facade.findClass("java.util.Set", scope);
        PsiClass collection = facade.findClass("java.util.Collection", scope);
        PsiClass string = facade.findClass("java.lang.String", scope);
        if (list == null || set == null || collection == null || string == null) {
            return Collections.emptyList();
        }
        PsiClassType listType = null;
        PsiClassType setType = null;
        boolean hasIterable = false;
        boolean hasString = false;
        for (ExpectedTypeInfo expectedTypeInfo : expectedTypes) {
            PsiType type2 = expectedTypeInfo.getDefaultType();
            if (type2.equalsToText("java.lang.String")) {
                hasString = true;
                continue;
            }
            PsiClass expectedClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type2);
            PsiType expectedComponent = PsiUtil.extractIterableTypeParameter((PsiType)type2, (boolean)true);
            if (expectedClass == null || expectedComponent == null || !TypeConversionUtil.isAssignable((PsiType)expectedComponent, (PsiType)component)) continue;
            hasIterable = true;
            if (InheritanceUtil.isInheritorOrSelf((PsiClass)list, (PsiClass)expectedClass, (boolean)true)) {
                listType = type2;
            }
            if (!InheritanceUtil.isInheritorOrSelf((PsiClass)set, (PsiClass)expectedClass, (boolean)true)) continue;
            setType = type2;
        }
        if (expectedTypes.isEmpty()) {
            listType = factory.createType(list, component);
            setType = factory.createType(set, component);
        }
        ArrayList<Pair<String, PsiType>> result = new ArrayList<Pair<String, PsiType>>();
        if (listType != null) {
            result.add(Pair.create((Object)"toList", (Object)listType));
            result.add(Pair.create((Object)"toUnmodifiableList", (Object)listType));
        }
        if (setType != null) {
            result.add(Pair.create((Object)"toSet", (Object)setType));
            result.add(Pair.create((Object)"toUnmodifiableSet", (Object)setType));
        }
        if (expectedTypes.isEmpty() || hasIterable) {
            result.add(Pair.create((Object)"toCollection", (Object)factory.createType(collection, component)));
        }
        if ((expectedTypes.isEmpty() || hasString) && joiningApplicable) {
            result.add((Pair<String, PsiType>)Pair.create((Object)"joining", (Object)factory.createType(string)));
        }
        return result;
    }

    static class StreamMethodInvocation
    extends LookupElementDecorator<LookupElement> {
        private final Consumer<? super InsertionContext> myBeforeInsertion;

        StreamMethodInvocation(LookupElement e, Consumer<? super InsertionContext> beforeInsertion) {
            super(e);
            this.myBeforeInsertion = beforeInsertion;
        }

        public void renderElement(LookupElementPresentation presentation) {
            super.renderElement(presentation);
            presentation.setItemText("stream()." + presentation.getItemText());
        }

        public void handleInsert(@NotNull InsertionContext context) {
            this.myBeforeInsertion.consume((Object)context);
            super.handleInsert(context);
        }
    }

    private static class CollectLookupElement
    extends LookupElement
    implements TypedLookupItem {
        private final String myLookupString;
        private final String myTypeText;
        private final String myMethodName;
        @NotNull
        private final PsiType myExpectedType;
        private final boolean myHasImport;

        CollectLookupElement(String methodName, @NotNull PsiType expectedType, @NotNull PsiElement context) {
            this.myMethodName = methodName;
            this.myExpectedType = expectedType;
            this.myTypeText = this.myExpectedType.getPresentableText();
            PsiMethodCallExpression call = (PsiMethodCallExpression)JavaPsiFacade.getElementFactory((Project)context.getProject()).createExpressionFromText(methodName + "()", context);
            this.myHasImport = ContainerUtil.or((Object[])call.getMethodExpression().multiResolve(true), result -> {
                PsiElement element = result.getElement();
                return element instanceof PsiMember && ("java.util.stream.Collectors." + this.myMethodName).equals(PsiUtil.getMemberQualifiedName((PsiMember)((PsiMember)element)));
            });
            this.myLookupString = "collect(" + (this.myHasImport ? "" : "Collectors.") + this.myMethodName + "())";
        }

        @NotNull
        public String getLookupString() {
            return this.myLookupString;
        }

        public Set<String> getAllLookupStrings() {
            return ContainerUtil.newHashSet((Object[])new String[]{this.myLookupString, this.myMethodName});
        }

        public void renderElement(LookupElementPresentation presentation) {
            super.renderElement(presentation);
            presentation.setTypeText(this.myTypeText);
            presentation.setIcon(PlatformIcons.METHOD_ICON);
        }

        public void handleInsert(@NotNull InsertionContext context) {
            context.getDocument().replaceString(context.getStartOffset(), context.getTailOffset(), (CharSequence)this.getInsertString());
            context.commitDocument();
            PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset(), PsiMethodCallExpression.class, (boolean)false);
            if (call == null) {
                return;
            }
            PsiExpression[] args = call.getArgumentList().getExpressions();
            if (args.length != 1 || !(args[0] instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression innerCall = (PsiMethodCallExpression)args[0];
            PsiMethod collectorMethod = innerCall.resolveMethod();
            if (collectorMethod != null && (!collectorMethod.getParameterList().isEmpty() || MethodSignatureUtil.hasOverloads((PsiMethod)collectorMethod))) {
                context.getEditor().getCaretModel().moveToOffset(innerCall.getArgumentList().getFirstChild().getTextRange().getEndOffset());
            }
            JavaCodeStyleManager.getInstance((Project)context.getProject()).shortenClassReferences((PsiElement)innerCall);
        }

        @NotNull
        private String getInsertString() {
            return "collect(" + (this.myHasImport ? "" : "java.util.stream.Collectors.") + this.myMethodName + "())";
        }

        @Override
        public PsiType getType() {
            return this.myExpectedType;
        }
    }
}

