/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.JavaGenerateMemberCompletionContributor;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.compiler.CompilerReferenceService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PreferMostUsedWeigher
extends LookupElementWeigher {
    private static final PsiMethodPattern OBJECT_METHOD_PATTERN = (PsiMethodPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName((ElementPattern)StandardPatterns.string().oneOf(new String[]{"hashCode", "equals", "finalize", "wait", "notify", "notifyAll", "getClass", "clone", "toString"}))).inClass("java.lang.Object");
    private static final boolean UNIT_TEST_MODE = ApplicationManager.getApplication().isUnitTestMode();
    private final CompilerReferenceService myCompilerReferenceService;
    private final boolean myConstructorSuggestion;

    private PreferMostUsedWeigher(@NotNull CompilerReferenceService service, boolean constructorSuggestion) {
        super("mostUsed");
        this.myCompilerReferenceService = service;
        this.myConstructorSuggestion = constructorSuggestion;
    }

    @Nullable
    static PreferMostUsedWeigher create(@NotNull PsiElement position) {
        CompilerReferenceService service = CompilerReferenceService.getInstance(position.getProject());
        if (service == null) {
            return null;
        }
        return service.isActive() || UNIT_TEST_MODE ? new PreferMostUsedWeigher(service, JavaSmartCompletionContributor.AFTER_NEW.accepts((Object)position)) : null;
    }

    @Nullable
    public Integer weigh(@NotNull LookupElement element) {
        PsiElement psi = (PsiElement)ObjectUtils.tryCast((Object)element.getObject(), PsiElement.class);
        if (!(psi instanceof PsiMember)) {
            return null;
        }
        if (element.getUserData(JavaGenerateMemberCompletionContributor.GENERATE_ELEMENT) != null) {
            return null;
        }
        if (OBJECT_METHOD_PATTERN.accepts((Object)psi)) {
            return null;
        }
        if (PreferMostUsedWeigher.looksLikeHelperMethodOrConst(psi)) {
            return null;
        }
        Integer occurrenceCount = this.myCompilerReferenceService.getCompileTimeOccurrenceCount(psi, this.myConstructorSuggestion);
        return occurrenceCount == null ? null : Integer.valueOf(-occurrenceCount.intValue());
    }

    private static boolean looksLikeHelperMethodOrConst(@NotNull PsiElement element) {
        if (!(element instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method = (PsiMethod)element;
        if (method.isConstructor()) {
            return false;
        }
        if (PreferMostUsedWeigher.isRawDeepTypeEqualToObject(method.getReturnType())) {
            return true;
        }
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        if (parameters2.length == 0) {
            return false;
        }
        for (PsiParameter parameter2 : parameters2) {
            PsiType paramType = parameter2.getType();
            if (!PreferMostUsedWeigher.isRawDeepTypeEqualToObject(paramType)) continue;
            return true;
        }
        return false;
    }

    private static boolean isRawDeepTypeEqualToObject(@Nullable PsiType type2) {
        if (type2 == null) {
            return false;
        }
        PsiType rawType = TypeConversionUtil.erasure((PsiType)type2.getDeepComponentType());
        if (rawType == null) {
            return false;
        }
        return rawType.equalsToText("java.lang.Object");
    }
}

