/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.JavaKeywordCompletion;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.filters.FilterPositionUtil;
import com.intellij.psi.impl.source.jsp.jspJava.JspClassLevelDeclarationStatement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModifierChooser {
    private static final String[][] CLASS_MODIFIERS = new String[][]{{"public"}, {"final", "abstract"}};
    private static final String[][] CLASS_15_MODIFIERS = new String[][]{{"public"}, {"final", "abstract"}, {"final", "sealed", "non-sealed"}};
    private static final String[][] CLASS_MEMBER_MODIFIERS = new String[][]{{"public", "protected", "private"}, {"static"}, {"final", "abstract"}, {"native"}, {"synchronized"}, {"strictfp"}, {"volatile"}, {"transient"}};
    private static final String[][] INTERFACE_9_MEMBER_MODIFIERS = new String[][]{{"public", "protected", "private"}, {"static", "default"}, {"final", "abstract"}};
    private static final String[][] INTERFACE_8_MEMBER_MODIFIERS = new String[][]{{"public", "protected"}, {"static", "default"}, {"final", "abstract"}};
    private static final String[][] INTERFACE_MEMBER_MODIFIERS = new String[][]{{"public", "protected"}, {"final", "abstract"}};

    static String[] getKeywords(@NotNull PsiElement position) {
        PsiModifierList list = ModifierChooser.findModifierList(position);
        if (list == null && !ModifierChooser.shouldSuggestModifiers(position)) {
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        PsiElement scope = position.getParent();
        while (scope != null) {
            if (scope instanceof PsiJavaFile) {
                return ModifierChooser.addClassModifiers(list, scope);
            }
            if (scope instanceof PsiClass) {
                return ModifierChooser.addMemberModifiers(list, ((PsiClass)scope).isInterface(), scope);
            }
            if (!((scope = scope.getParent()) instanceof PsiDirectory)) continue;
            break;
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    public static String[] addClassModifiers(PsiModifierList list, @NotNull PsiElement scope) {
        return ModifierChooser.addKeywords(list, PsiUtil.getLanguageLevel((PsiElement)scope).isAtLeast(LanguageLevel.JDK_15_PREVIEW) ? CLASS_15_MODIFIERS : CLASS_MODIFIERS);
    }

    public static String[] addMemberModifiers(PsiModifierList list, boolean inInterface, @NotNull PsiElement position) {
        return ModifierChooser.addKeywords(list, inInterface ? ModifierChooser.getInterfaceMemberModifiers(position) : CLASS_MEMBER_MODIFIERS);
    }

    private static String[][] getInterfaceMemberModifiers(@NotNull PsiElement list) {
        if (PsiUtil.isLanguageLevel9OrHigher((PsiElement)list)) {
            return INTERFACE_9_MEMBER_MODIFIERS;
        }
        if (PsiUtil.isLanguageLevel8OrHigher((PsiElement)list)) {
            return INTERFACE_8_MEMBER_MODIFIERS;
        }
        return INTERFACE_MEMBER_MODIFIERS;
    }

    private static String[] addKeywords(PsiModifierList list, String[][] keywordSets) {
        ArrayList ret = new ArrayList();
        for (int i = 0; i < keywordSets.length; ++i) {
            Object[] keywords = keywordSets[keywordSets.length - i - 1];
            boolean containModifierFlag = false;
            if (list != null) {
                for (Object keyword : keywords) {
                    if (!list.hasExplicitModifier((String)keyword)) continue;
                    containModifierFlag = true;
                    break;
                }
            }
            if (containModifierFlag) continue;
            ContainerUtil.addAll(ret, (Object[])keywords);
        }
        return ArrayUtilRt.toStringArray(ret);
    }

    @Nullable
    public static PsiModifierList findModifierList(@NotNull PsiElement element) {
        if (element.getParent() instanceof PsiModifierList) {
            return (PsiModifierList)element.getParent();
        }
        return (PsiModifierList)PsiTreeUtil.getParentOfType((PsiElement)FilterPositionUtil.searchNonSpaceNonCommentBack((PsiElement)element), PsiModifierList.class);
    }

    private static boolean shouldSuggestModifiers(PsiElement element) {
        PsiElement parent = element.getParent();
        while (parent instanceof PsiJavaCodeReferenceElement || parent instanceof PsiErrorElement || parent instanceof PsiTypeElement || parent instanceof PsiMethod || parent instanceof PsiVariable || parent instanceof PsiDeclarationStatement || parent instanceof PsiImportList || parent instanceof PsiDocComment) {
            if (!((parent = parent.getParent()) instanceof JspClassLevelDeclarationStatement)) continue;
            parent = parent.getContext();
        }
        if (parent == null) {
            return false;
        }
        return (parent instanceof PsiJavaFile || parent instanceof PsiClass) && JavaKeywordCompletion.isEndOfBlock(element);
    }
}

