/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.MemberLookupHelper;
import com.intellij.codeInsight.completion.StaticallyImportable;
import com.intellij.codeInsight.lookup.DefaultLookupItemRenderer;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaGlobalMemberLookupElement
extends LookupElement
implements StaticallyImportable {
    private final MemberLookupHelper myHelper;
    private final InsertHandler<JavaGlobalMemberLookupElement> myQualifiedInsertion;
    private final InsertHandler<JavaGlobalMemberLookupElement> myImportInsertion;

    public JavaGlobalMemberLookupElement(List<? extends PsiMethod> overloads, PsiClass containingClass, InsertHandler<JavaGlobalMemberLookupElement> qualifiedInsertion, InsertHandler<JavaGlobalMemberLookupElement> importInsertion, boolean shouldImport) {
        this.myHelper = new MemberLookupHelper(overloads, containingClass, shouldImport);
        this.myQualifiedInsertion = qualifiedInsertion;
        this.myImportInsertion = importInsertion;
    }

    public JavaGlobalMemberLookupElement(PsiMember member, PsiClass containingClass, InsertHandler<JavaGlobalMemberLookupElement> qualifiedInsertion, InsertHandler<JavaGlobalMemberLookupElement> importInsertion, boolean shouldImport) {
        this.myHelper = new MemberLookupHelper(member, containingClass, shouldImport, false);
        this.myQualifiedInsertion = qualifiedInsertion;
        this.myImportInsertion = importInsertion;
    }

    @NotNull
    public PsiMember getObject() {
        return this.myHelper.getMember();
    }

    @NotNull
    public PsiClass getContainingClass() {
        return Objects.requireNonNull(this.myHelper.getContainingClass());
    }

    @NotNull
    public String getLookupString() {
        return Objects.requireNonNull(this.getObject().getName());
    }

    public Set<String> getAllLookupStrings() {
        return JavaCompletionUtil.getAllLookupStrings(this.getObject());
    }

    public void renderElement(LookupElementPresentation presentation) {
        presentation.setIcon(DefaultLookupItemRenderer.getRawIcon((LookupElement)this));
        this.myHelper.renderElement(presentation, !this.myHelper.willBeImported(), true, PsiSubstitutor.EMPTY);
    }

    @Override
    public void setShouldBeImported(boolean shouldImportStatic) {
        this.myHelper.setShouldBeImported(shouldImportStatic);
    }

    @Override
    public boolean canBeImported() {
        return true;
    }

    @Override
    public boolean willBeImported() {
        return this.myHelper.willBeImported();
    }

    public void handleInsert(@NotNull InsertionContext context) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.global.member.name");
        (this.willBeImported() ? this.myImportInsertion : this.myQualifiedInsertion).handleInsert(context, (LookupElement)this);
    }
}

