/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCompletionSession {
    private final Set<String> myAddedClasses = new HashSet<String>();
    private final Set<String> myKeywords = new HashSet<String>();
    private final List<LookupElement> myBatchItems = new ArrayList<LookupElement>();
    private final CompletionResultSet myResult;

    public JavaCompletionSession(CompletionResultSet result) {
        this.myResult = result;
    }

    void registerBatchItems(Collection<? extends LookupElement> elements) {
        this.myBatchItems.addAll(elements);
    }

    void flushBatchItems() {
        this.myResult.addAllElements(this.myBatchItems);
        this.myBatchItems.clear();
    }

    public void addClassItem(LookupElement lookupElement) {
        if (!this.myResult.getPrefixMatcher().prefixMatches(lookupElement)) {
            return;
        }
        this.registerClassFrom(lookupElement);
        this.myResult.addElement(AutoCompletionPolicy.NEVER_AUTOCOMPLETE.applyPolicy(lookupElement));
    }

    void registerClassFrom(LookupElement lookupElement) {
        PsiClass psiClass = JavaCompletionSession.extractClass(lookupElement);
        if (psiClass != null) {
            this.registerClass(psiClass);
        }
    }

    @NotNull
    PrefixMatcher getMatcher() {
        return this.myResult.getPrefixMatcher();
    }

    @Nullable
    private static PsiClass extractClass(LookupElement lookupElement) {
        Object object = lookupElement.getObject();
        if (object instanceof PsiClass) {
            return (PsiClass)object;
        }
        if (object instanceof PsiMethod && ((PsiMethod)object).isConstructor()) {
            return ((PsiMethod)object).getContainingClass();
        }
        return null;
    }

    public void registerClass(@NotNull PsiClass psiClass) {
        ContainerUtil.addIfNotNull(this.myAddedClasses, (Object)JavaCompletionSession.getClassName(psiClass));
    }

    @Nullable
    private static String getClassName(@NotNull PsiClass psiClass) {
        String name2 = psiClass.getQualifiedName();
        return name2 == null ? psiClass.getName() : name2;
    }

    public boolean alreadyProcessed(@NotNull LookupElement element) {
        PsiClass psiClass = JavaCompletionSession.extractClass(element);
        return psiClass != null && this.alreadyProcessed(psiClass);
    }

    public boolean alreadyProcessed(@NotNull PsiClass object) {
        String name2 = JavaCompletionSession.getClassName(object);
        return name2 == null || this.myAddedClasses.contains(name2);
    }

    public boolean isKeywordAlreadyProcessed(@NotNull String keyword) {
        return this.myKeywords.contains(keyword);
    }

    void registerKeyword(@NotNull String keyword) {
        this.myKeywords.add(keyword);
    }
}

