/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.ReferenceExpressionCompletionContributor;
import com.intellij.codeInsight.lookup.ExpressionLookupItem;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ArrayMemberAccess {
    ArrayMemberAccess() {
    }

    static void addMemberAccessors(PsiElement element, String prefix, PsiType itemType, PsiElement qualifier, Consumer<? super LookupElement> result, PsiModifierListOwner object, PsiType expectedType) throws IncorrectOperationException {
        if (itemType instanceof PsiArrayType && expectedType.isAssignableFrom(((PsiArrayType)itemType).getComponentType())) {
            PsiExpression conversion = ReferenceExpressionCompletionContributor.createExpression(ReferenceExpressionCompletionContributor.getQualifierText(qualifier) + prefix + "[0]", element);
            result.consume((Object)new ExpressionLookupItem(conversion, object.getIcon(1), prefix + "[...]", new String[]{prefix}){

                @Override
                public void handleInsert(@NotNull InsertionContext context) {
                    FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.second.smarttype.array.member");
                    int tailOffset = context.getTailOffset();
                    String callSpace = ReferenceExpressionCompletionContributor.getSpace(CodeStyle.getLanguageSettings((PsiFile)context.getFile()).SPACE_WITHIN_BRACKETS);
                    context.getDocument().insertString(tailOffset, (CharSequence)("[" + callSpace + callSpace + "]"));
                    context.getEditor().getCaretModel().moveToOffset(tailOffset + 1 + callSpace.length());
                }
            });
        }
    }

    @Nullable
    static ExpressionLookupItem accessFirstElement(PsiElement element, LookupElement item) {
        if (item.getObject() instanceof PsiLocalVariable) {
            PsiNewExpression newExpression;
            PsiExpression[] dimensions;
            PsiLocalVariable variable = (PsiLocalVariable)item.getObject();
            PsiType type2 = variable.getType();
            PsiExpression expression2 = variable.getInitializer();
            if (type2 instanceof PsiArrayType && expression2 instanceof PsiNewExpression && (dimensions = (newExpression = (PsiNewExpression)expression2).getArrayDimensions()).length == 1 && "1".equals(dimensions[0].getText()) && newExpression.getArrayInitializer() == null) {
                String text2 = variable.getName() + "[0]";
                return new ExpressionLookupItem(ReferenceExpressionCompletionContributor.createExpression(text2, element), variable.getIcon(1), text2, text2);
            }
        }
        return null;
    }
}

