/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.annoPackages;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullabilityAnnotationInfo;
import com.intellij.codeInsight.annoPackages.AnnotationPackageSupport;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.util.ArrayUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EclipseAnnotationSupport
implements AnnotationPackageSupport {
    private static final String DEFAULT_NOT_NULL = "org.eclipse.jdt.annotation.NonNullByDefault";
    private static final Map<String, PsiAnnotation.TargetType> TARGET_MAP = EntryStream.of((Object)"FIELD", (Object)PsiAnnotation.TargetType.FIELD, (Object)"PARAMETER", (Object)PsiAnnotation.TargetType.PARAMETER, (Object)"RETURN_TYPE", (Object)PsiAnnotation.TargetType.METHOD, (Object)"TYPE_PARAMETER", (Object)PsiAnnotation.TargetType.TYPE_PARAMETER, (Object)"TYPE_BOUND", (Object)PsiAnnotation.TargetType.TYPE_USE, (Object)"TYPE_ARGUMENT", (Object)PsiAnnotation.TargetType.TYPE_USE).toImmutableMap();
    private static final String[] DEFAULT_LOCATIONS = new String[]{"PARAMETER", "RETURN_TYPE", "FIELD", "TYPE_BOUND", "TYPE_ARGUMENT"};

    EclipseAnnotationSupport() {
    }

    @Override
    @Nullable
    public NullabilityAnnotationInfo getNullabilityByContainerAnnotation(@NotNull PsiAnnotation anno, // Could not load outer class - annotation placement on inner may be incorrect
    PsiAnnotation.TargetType @NotNull [] types, boolean superPackage) {
        if (superPackage) {
            return null;
        }
        String qName = anno.getQualifiedName();
        if (DEFAULT_NOT_NULL.equals(qName)) {
            boolean targetApplies;
            PsiAnnotationMemberValue value2 = anno.findAttributeValue("value");
            Object[] targets = DEFAULT_LOCATIONS;
            if (value2 instanceof PsiArrayInitializerMemberValue) {
                targets = (String[])StreamEx.of((Object[])((PsiArrayInitializerMemberValue)value2).getInitializers()).select(PsiReferenceExpression.class).map(PsiQualifiedReference::getReferenceName).nonNull().toArray(String[]::new);
            } else if (value2 instanceof PsiLiteralExpression && Boolean.FALSE.equals(((PsiLiteralExpression)value2).getValue())) {
                targets = ArrayUtil.EMPTY_STRING_ARRAY;
            }
            return new NullabilityAnnotationInfo(anno, (targetApplies = StreamEx.of((Object[])targets).map(TARGET_MAP::get).nonNull().anyMatch(loc -> ArrayUtil.contains((Object)loc, (Object[])types))) ? Nullability.NOT_NULL : Nullability.UNKNOWN, true);
        }
        return null;
    }

    @Override
    @NotNull
    public List<String> getNullabilityAnnotations(@NotNull Nullability nullability) {
        switch (nullability) {
            case NOT_NULL: {
                return Collections.singletonList("org.eclipse.jdt.annotation.NonNull");
            }
            case NULLABLE: {
                return Collections.singletonList("org.eclipse.jdt.annotation.Nullable");
            }
        }
        return Collections.emptyList();
    }
}

