/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullabilityAnnotationInfo;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.annoPackages.AnnotationPackageSupport;
import com.intellij.codeInsight.annoPackages.Jsr305Support;
import com.intellij.codeInspection.dataFlow.HardcodedContracts;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.java.stubs.index.JavaAnnotationIndex;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="NullableNotNullManager")
public class NullableNotNullManagerImpl
extends NullableNotNullManager
implements PersistentStateComponent<Element>,
ModificationTracker {
    private static final String INSTRUMENTED_NOT_NULLS_TAG = "instrumentedNotNulls";
    private final AnnotationPackageSupport[] myAnnotationSupports = AnnotationPackageSupport.getAnnotationPackages(this);
    private final List<String> myDefaultNullables = StreamEx.of((Object[])this.myAnnotationSupports).toFlatList(s -> s.getNullabilityAnnotations(Nullability.NULLABLE));
    private final List<String> myDefaultNotNulls = StreamEx.of((Object[])this.myAnnotationSupports).toFlatList(s -> s.getNullabilityAnnotations(Nullability.NOT_NULL));
    private final List<String> myDefaultAll = StreamEx.of((Object[])this.myAnnotationSupports).flatCollection(s -> s.getNullabilityAnnotations(Nullability.UNKNOWN)).prepend(this.myDefaultNotNulls).prepend(this.myDefaultNullables).toList();
    public String myDefaultNullable = "org.jetbrains.annotations.Nullable";
    public String myDefaultNotNull = "org.jetbrains.annotations.NotNull";
    public final JDOMExternalizableStringList myNullables = new JDOMExternalizableStringList(this.myDefaultNullables);
    public final JDOMExternalizableStringList myNotNulls = new JDOMExternalizableStringList(this.myDefaultNotNulls);
    private List<String> myInstrumentedNotNulls = ContainerUtil.newArrayList((Object[])new String[]{"org.jetbrains.annotations.NotNull"});
    private final SimpleModificationTracker myTracker = new SimpleModificationTracker();

    public NullableNotNullManagerImpl(Project project) {
        super(project);
    }

    public void setNotNulls(String ... annotations) {
        this.myNotNulls.clear();
        Collections.addAll(this.myNotNulls, annotations);
        this.normalizeDefaults();
    }

    public void setNullables(String ... annotations) {
        this.myNullables.clear();
        Collections.addAll(this.myNullables, annotations);
        this.normalizeDefaults();
    }

    @NotNull
    public String getDefaultNullable() {
        return this.myDefaultNullable;
    }

    public void setDefaultNullable(@NotNull String defaultNullable) {
        LOG.assertTrue(this.getNullables().contains(defaultNullable));
        this.myDefaultNullable = defaultNullable;
        this.myTracker.incModificationCount();
    }

    @NotNull
    public String getDefaultNotNull() {
        return this.myDefaultNotNull;
    }

    public void setDefaultNotNull(@NotNull String defaultNotNull) {
        LOG.assertTrue(this.getNotNulls().contains(defaultNotNull));
        this.myDefaultNotNull = defaultNotNull;
        this.myTracker.incModificationCount();
    }

    @NotNull
    List<String> getDefaultNullables() {
        return this.myDefaultNullables;
    }

    @NotNull
    List<String> getDefaultNotNulls() {
        return this.myDefaultNotNulls;
    }

    @NotNull
    List<String> getAllDefaultAnnotations() {
        return this.myDefaultAll;
    }

    @NotNull
    public List<String> getNullables() {
        return Collections.unmodifiableList(this.myNullables);
    }

    @NotNull
    public List<String> getNotNulls() {
        return Collections.unmodifiableList(this.myNotNulls);
    }

    @NotNull
    public List<String> getInstrumentedNotNulls() {
        return Collections.unmodifiableList(this.myInstrumentedNotNulls);
    }

    public void setInstrumentedNotNulls(@NotNull List<String> names2) {
        this.myInstrumentedNotNulls = ContainerUtil.sorted(names2);
        this.myTracker.incModificationCount();
    }

    protected boolean hasHardcodedContracts(@NotNull PsiElement element) {
        return HardcodedContracts.hasHardcodedContracts(element);
    }

    public Element getState() {
        Element component = new Element("component");
        if (!this.hasDefaultValues()) {
            try {
                DefaultJDOMExternalizer.writeExternal((Object)((Object)this), (Element)component);
            }
            catch (WriteExternalException e) {
                LOG.error((Throwable)e);
            }
        }
        if (this.myInstrumentedNotNulls.size() != 1 || !"org.jetbrains.annotations.NotNull".equals(this.myInstrumentedNotNulls.get(0))) {
            Element instrumentedNotNulls = new Element(INSTRUMENTED_NOT_NULLS_TAG);
            for (String value2 : this.myInstrumentedNotNulls) {
                instrumentedNotNulls.addContent(new Element("option").setAttribute("value", value2));
            }
            component.addContent(instrumentedNotNulls);
        }
        return component;
    }

    private boolean hasDefaultValues() {
        return "org.jetbrains.annotations.NotNull".equals(this.myDefaultNotNull) && "org.jetbrains.annotations.Nullable".equals(this.myDefaultNullable) && new HashSet(this.myNullables).equals(new HashSet<String>(this.getDefaultNullables())) && new HashSet(this.myNotNulls).equals(new HashSet<String>(this.getDefaultNotNulls()));
    }

    public void loadState(@NotNull Element state) {
        try {
            DefaultJDOMExternalizer.readExternal((Object)((Object)this), (Element)state);
            this.normalizeDefaults();
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
        Element instrumented = state.getChild(INSTRUMENTED_NOT_NULLS_TAG);
        this.myInstrumentedNotNulls = instrumented == null ? ContainerUtil.newArrayList((Object[])new String[]{"org.jetbrains.annotations.NotNull"}) : ContainerUtil.mapNotNull((Collection)instrumented.getChildren("option"), o -> o.getAttributeValue("value"));
    }

    private void normalizeDefaults() {
        this.myNotNulls.removeAll(this.getDefaultNullables());
        this.myNullables.removeAll(this.getDefaultNotNulls());
        this.myNullables.addAll((Collection)ContainerUtil.filter(this.getDefaultNullables(), s -> !this.myNullables.contains(s)));
        this.myNotNulls.addAll((Collection)ContainerUtil.filter(this.getDefaultNotNulls(), s -> !this.myNotNulls.contains(s)));
        this.myTracker.incModificationCount();
    }

    @NotNull
    private List<PsiClass> getAllNullabilityNickNames() {
        if (!this.getNotNulls().contains("javax.annotation.Nonnull")) {
            return Collections.emptyList();
        }
        return (List)CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)this.myProject, () -> {
            PsiClass[] nickDeclarations;
            HashSet<PsiClass> result = new HashSet<PsiClass>(this.getPossiblyUnresolvedJavaNicknameUsages());
            DelegatingGlobalSearchScope scope = new DelegatingGlobalSearchScope(GlobalSearchScope.allScope((Project)this.myProject)){

                public boolean contains(@NotNull VirtualFile file) {
                    return super.contains(file) && file.getFileType() != JavaFileType.INSTANCE;
                }
            };
            for (PsiClass tqNick : nickDeclarations = JavaPsiFacade.getInstance((Project)this.myProject).findClasses("javax.annotation.meta.TypeQualifierNickname", (GlobalSearchScope)scope)) {
                result.addAll(ContainerUtil.findAll((Collection)MetaAnnotationUtil.getChildren((PsiClass)tqNick, (GlobalSearchScope)scope), Jsr305Support::isNullabilityNickName));
            }
            return CachedValueProvider.Result.create(new ArrayList<PsiClass>(result), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    @NotNull
    private List<PsiClass> getPossiblyUnresolvedJavaNicknameUsages() {
        ArrayList<PsiClass> result = new ArrayList<PsiClass>();
        Collection<PsiAnnotation> annotations = JavaAnnotationIndex.getInstance().get(StringUtil.getShortName((String)"javax.annotation.meta.TypeQualifierNickname"), this.myProject, GlobalSearchScope.allScope((Project)this.myProject));
        for (PsiAnnotation annotation : annotations) {
            PsiClass ownerClass;
            PsiElement context = annotation.getContext();
            if (!(context instanceof PsiModifierList) || !(context.getContext() instanceof PsiClass) || !(ownerClass = (PsiClass)context.getContext()).isAnnotationType() || !Jsr305Support.isNullabilityNickName(ownerClass)) continue;
            result.add(ownerClass);
        }
        return result;
    }

    @Nullable
    NullabilityAnnotationInfo getNullityDefault(@NotNull PsiModifierListOwner container, // Could not load outer class - annotation placement on inner may be incorrect
    PsiAnnotation.TargetType @NotNull [] placeTargetTypes, PsiElement context, boolean superPackage) {
        PsiModifierList modifierList = container.getModifierList();
        if (modifierList == null) {
            return null;
        }
        for (PsiAnnotation annotation : modifierList.getAnnotations()) {
            NullabilityAnnotationInfo result;
            if (container instanceof PsiPackage) {
                VirtualFile annotationFile = PsiUtilCore.getVirtualFile((PsiElement)annotation);
                VirtualFile ownerFile = PsiUtilCore.getVirtualFile((PsiElement)context);
                if (annotationFile != null && ownerFile != null && !annotationFile.equals(ownerFile)) {
                    ProjectFileIndex index = ProjectRootManager.getInstance((Project)container.getProject()).getFileIndex();
                    VirtualFile annotationRoot = index.getClassRootForFile(annotationFile);
                    VirtualFile ownerRoot = index.getClassRootForFile(ownerFile);
                    if (ownerRoot != null && !ownerRoot.equals(annotationRoot)) continue;
                }
            }
            if ((result = this.checkNullityDefault(annotation, placeTargetTypes, superPackage)) == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    private NullabilityAnnotationInfo checkNullityDefault(@NotNull PsiAnnotation annotation, // Could not load outer class - annotation placement on inner may be incorrect
    PsiAnnotation.TargetType @NotNull [] placeTargetTypes, boolean superPackage) {
        for (AnnotationPackageSupport support : this.myAnnotationSupports) {
            NullabilityAnnotationInfo info = support.getNullabilityByContainerAnnotation(annotation, placeTargetTypes, superPackage);
            if (info == null) continue;
            return info;
        }
        return null;
    }

    @NotNull
    private List<String> filterNickNames(@NotNull Nullability nullability) {
        return ContainerUtil.mapNotNull(this.getAllNullabilityNickNames(), c -> Jsr305Support.getNickNamedNullability(c) == nullability ? c.getQualifiedName() : null);
    }

    @NotNull
    protected List<String> getNullablesWithNickNames() {
        return (List)CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)this.myProject, () -> CachedValueProvider.Result.create((Object)ContainerUtil.concat(this.getNullables(), this.filterNickNames(Nullability.NULLABLE)), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @NotNull
    protected List<String> getNotNullsWithNickNames() {
        return (List)CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)this.myProject, () -> CachedValueProvider.Result.create((Object)ContainerUtil.concat(this.getNotNulls(), this.filterNickNames(Nullability.NOT_NULL)), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @NotNull
    protected Set<String> getAllNullabilityAnnotationsWithNickNames() {
        return (Set)CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)this.myProject, () -> {
            THashSet result = new THashSet();
            result.addAll(this.getNotNulls());
            result.addAll(this.getNullables());
            result.addAll(ContainerUtil.mapNotNull(this.getAllNullabilityNickNames(), PsiClass::getQualifiedName));
            return CachedValueProvider.Result.create(Collections.unmodifiableSet(result), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    public long getModificationCount() {
        return this.myTracker.getModificationCount();
    }
}

