/*
 * Decompiled with CFR 0.152.
 */
package git4idea.annotate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkHtmlRenderer;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.util.containers.Convertor;
import com.intellij.vcsUtil.VcsUtil;
import com.intellij.xml.util.XmlStringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationTooltipBuilder {
    @NotNull
    private final Project myProject;
    private final boolean myAsHtml;
    private final StringBuilder sb = new StringBuilder();

    public AnnotationTooltipBuilder(@NotNull Project project, boolean asHtml) {
        this.myProject = project;
        this.myAsHtml = asHtml;
    }

    private void append(@NotNull String text2) {
        this.sb.append(this.myAsHtml ? XmlStringUtil.escapeString((String)text2) : text2);
    }

    private void appendRaw(@NotNull String text2) {
        this.sb.append(text2);
    }

    public void appendRevisionLine(@NotNull VcsRevisionNumber revisionNumber, @Nullable Convertor<? super VcsRevisionNumber, String> linkBuilder) {
        String revision;
        this.appendNewline();
        if (this.myAsHtml) {
            String string = revision = linkBuilder != null ? (String)linkBuilder.convert((Object)revisionNumber) : null;
            if (revision == null) {
                revision = XmlStringUtil.escapeString((String)revisionNumber.asString());
            }
        } else {
            revision = revisionNumber.asString();
        }
        this.appendRaw(VcsBundle.message((String)"commit.description.tooltip.commit", (Object[])new Object[]{revision}));
    }

    public void appendLine(@NotNull String content2) {
        this.appendNewline();
        this.append(content2);
    }

    public void appendCommitMessageBlock(@NotNull String message) {
        this.append("\n\n");
        this.appendTextWithLinks(message);
    }

    public void appendTextWithLinks(@NotNull String message) {
        if (this.myAsHtml) {
            this.appendRaw(IssueLinkHtmlRenderer.formatTextWithLinks(this.myProject, message));
        } else {
            this.append(VcsUtil.trimCommitMessageToSaneSize((String)message));
        }
    }

    private void appendNewline() {
        if (this.sb.length() != 0) {
            this.append("\n");
        }
    }

    public String toString() {
        return this.sb.toString();
    }

    @NotNull
    public static String buildSimpleTooltip(@NotNull Project project, boolean asHtml, @NotNull String prefix, @NotNull String revision, @Nullable String commitMessage2) {
        AnnotationTooltipBuilder builder = new AnnotationTooltipBuilder(project, asHtml);
        builder.append(prefix);
        builder.append(" ");
        builder.append(revision);
        if (commitMessage2 != null) {
            builder.append(": ");
            builder.appendTextWithLinks(commitMessage2);
        }
        return builder.toString();
    }
}

