/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.visible.filters;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.util.VcsUserUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
class VcsLogUserFilterImpl
implements VcsLogUserFilter {
    private static final Logger LOG = Logger.getInstance(VcsLogUserFilterImpl.class);
    @NotNull
    private final Collection<String> myUsers;
    @NotNull
    private final Map<VirtualFile, VcsUser> myData;
    @NotNull
    private final MultiMap<String, VcsUser> myAllUsersByNames = MultiMap.create();
    @NotNull
    private final MultiMap<String, VcsUser> myAllUsersByEmails = MultiMap.create();

    VcsLogUserFilterImpl(@NotNull Collection<String> users, @NotNull Map<VirtualFile, VcsUser> meData, @NotNull Set<? extends VcsUser> allUsers) {
        this.myUsers = users;
        this.myData = meData;
        for (VcsUser vcsUser : allUsers) {
            String email;
            String nameFromEmail;
            String name = vcsUser.getName();
            if (!name.isEmpty()) {
                this.myAllUsersByNames.putValue((Object)VcsUserUtil.getNameInStandardForm(name), (Object)vcsUser);
            }
            if ((nameFromEmail = VcsUserUtil.getNameFromEmail(email = vcsUser.getEmail())) == null) continue;
            this.myAllUsersByEmails.putValue((Object)VcsUserUtil.getNameInStandardForm(nameFromEmail), (Object)vcsUser);
        }
    }

    @NotNull
    public Collection<VcsUser> getUsers(@NotNull VirtualFile root) {
        HashSet<VcsUser> result2 = new HashSet<VcsUser>();
        for (String user : this.myUsers) {
            result2.addAll(this.getUsers(root, user));
        }
        return result2;
    }

    @NotNull
    private Set<VcsUser> getUsers(@NotNull VirtualFile root, @NotNull String name) {
        HashSet<VcsUser> users = new HashSet<VcsUser>();
        if ("*".equals(name)) {
            VcsUser vcsUser = this.myData.get(root);
            if (vcsUser != null) {
                users.addAll(this.getUsers(vcsUser.getName()));
                String emailNamePart = VcsUserUtil.getNameFromEmail(vcsUser.getEmail());
                if (emailNamePart != null) {
                    Set emails = ContainerUtil.map2Set(users, user -> VcsUserUtil.emailToLowerCase(user.getEmail()));
                    for (VcsUser candidateUser : this.getUsers(emailNamePart)) {
                        if (!emails.contains(VcsUserUtil.emailToLowerCase(candidateUser.getEmail()))) continue;
                        users.add(candidateUser);
                    }
                }
            } else {
                LOG.warn("Can not resolve user name for root " + root);
            }
        } else {
            users.addAll(this.getUsers(name));
        }
        return users;
    }

    @NotNull
    public Collection<String> getValuesAsText() {
        return this.myUsers;
    }

    @NotNull
    public String getDisplayText() {
        List users = ContainerUtil.map(this.myUsers, user -> {
            String me = VcsLogBundle.message((String)"vcs.log.user.filter.me", (Object[])new Object[0]);
            return user.equals("*") ? me : user;
        });
        return StringUtil.join((Collection)users, (String)", ");
    }

    public boolean matches(@NotNull VcsCommitMetadata commit) {
        return ContainerUtil.exists(this.myUsers, name -> {
            Set<VcsUser> users = this.getUsers(commit.getRoot(), (String)name);
            if (!users.isEmpty()) {
                return users.contains(commit.getAuthor());
            }
            if (!name.equals("*")) {
                boolean result2;
                String lowerUser = VcsUserUtil.nameToLowerCase(name);
                boolean bl = result2 = VcsUserUtil.nameToLowerCase(commit.getAuthor().getName()).equals(lowerUser) || VcsUserUtil.emailToLowerCase(commit.getAuthor().getEmail()).startsWith(lowerUser + "@");
                if (result2) {
                    LOG.warn("Unregistered author " + commit.getAuthor() + " for commit " + ((Hash)commit.getId()).asString() + "; search pattern " + name);
                }
                return result2;
            }
            return false;
        });
    }

    @NotNull
    private Set<VcsUser> getUsers(@NotNull String name) {
        String standardName = VcsUserUtil.getNameInStandardForm(name);
        HashSet<VcsUser> result2 = new HashSet<VcsUser>();
        result2.addAll(this.myAllUsersByNames.get((Object)standardName));
        result2.addAll(this.myAllUsersByEmails.get((Object)standardName));
        return result2;
    }

    public String toString() {
        return "author: " + StringUtil.join(this.myUsers, (String)", ");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VcsLogUserFilterImpl filter = (VcsLogUserFilterImpl)o;
        return Comparing.haveEqualElements(this.myUsers, filter.myUsers);
    }

    public int hashCode() {
        return Comparing.unorderedHashcode(this.myUsers);
    }
}

