/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.visible.filters;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.vcs.log.VcsLogHashFilter;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

class VcsLogHashFilterImpl
implements VcsLogHashFilter {
    @NotNull
    private final Collection<String> myHashes;

    VcsLogHashFilterImpl(@NotNull Collection<String> hashes) {
        this.myHashes = hashes;
    }

    @NotNull
    public Collection<String> getHashes() {
        return this.myHashes;
    }

    @NotNull
    public String getDisplayText() {
        return StringUtil.join(this.getHashes(), it -> VcsLogUtil.getShortHash(it), (String)", ");
    }

    public String toString() {
        return "hashes:" + this.myHashes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VcsLogHashFilterImpl filter = (VcsLogHashFilterImpl)o;
        return this.myHashes.equals(filter.myHashes);
    }

    public int hashCode() {
        return Objects.hash(this.myHashes);
    }
}

