/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@NonNls
public class StopWatch {
    private static final Logger LOG = Logger.getInstance(StopWatch.class);
    private static final String[] UNIT_NAMES = new String[]{"s", "m", "h"};
    private static final long[] UNITS = new long[]{1L, 60L, 3600L};
    private static final String M_SEC_FORMAT = "%03d";
    private final long myStartTime;
    @NotNull
    private final String myOperation;
    @NotNull
    private final Map<VirtualFile, Long> myDurationPerRoot;

    private StopWatch(@NotNull String operation) {
        this.myOperation = operation;
        this.myStartTime = System.currentTimeMillis();
        this.myDurationPerRoot = new HashMap<VirtualFile, Long>();
    }

    @NotNull
    public static StopWatch start(@NonNls @NotNull String operation) {
        return new StopWatch(operation);
    }

    public void rootCompleted(@NotNull VirtualFile root) {
        long totalDuration = System.currentTimeMillis() - this.myStartTime;
        long duration = totalDuration - StopWatch.sum(this.myDurationPerRoot.values());
        this.myDurationPerRoot.put(root, duration);
    }

    private static long sum(@NotNull Collection<Long> durations) {
        long sum = 0L;
        for (Long duration : durations) {
            sum += duration.longValue();
        }
        return sum;
    }

    public void report() {
        this.report(LOG);
    }

    public void report(@NotNull Logger logger) {
        String message = this.myOperation + " took " + StopWatch.formatTime(System.currentTimeMillis() - this.myStartTime);
        if (this.myDurationPerRoot.size() > 1) {
            message = message + "\n" + StringUtil.join(this.myDurationPerRoot.entrySet(), entry -> "    " + ((VirtualFile)entry.getKey()).getName() + ": " + StopWatch.formatTime((Long)entry.getValue()), (String)"\n");
        }
        logger.debug(message);
    }

    @NotNull
    public static String formatTime(long time) {
        if (time < 1000L * UNITS[0]) {
            return time + "ms";
        }
        String result2 = "";
        long remainder = time / 1000L;
        long msec = time % 1000L;
        for (int i = UNITS.length - 1; i >= 0; --i) {
            if (remainder < UNITS[i]) continue;
            long quotient = remainder / UNITS[i];
            remainder %= UNITS[i];
            if (i == 0) {
                result2 = result2 + quotient + (msec == 0L ? "" : "." + String.format(M_SEC_FORMAT, msec)) + UNIT_NAMES[i];
                continue;
            }
            result2 = result2 + quotient + UNIT_NAMES[i];
            if (remainder == 0L && msec == 0L) continue;
            result2 = result2 + " ";
            if (remainder != 0L) continue;
            result2 = result2 + "0." + String.format(M_SEC_FORMAT, msec) + UNIT_NAMES[0];
        }
        return result2;
    }
}

