/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.google.common.primitives.Ints;
import com.intellij.ide.CopyProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.ValueKey;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.issueLinks.TableLinkMouseListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.VcsCommitStyleFactory;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogProgress;
import com.intellij.vcs.log.graph.DefaultColorGenerator;
import com.intellij.vcs.log.graph.RowInfo;
import com.intellij.vcs.log.graph.RowType;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.graph.actions.GraphAnswer;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.paint.PositionUtil;
import com.intellij.vcs.log.paint.SimpleGraphCellPainter;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.VcsLogColorManagerImpl;
import com.intellij.vcs.log.ui.render.GraphCommitCell;
import com.intellij.vcs.log.ui.render.GraphCommitCellRenderer;
import com.intellij.vcs.log.ui.render.SimpleColoredComponentLinkMouseListener;
import com.intellij.vcs.log.ui.table.GraphCommitCellController;
import com.intellij.vcs.log.ui.table.GraphTableModel;
import com.intellij.vcs.log.ui.table.IndexSpeedSearch;
import com.intellij.vcs.log.ui.table.RootCellRenderer;
import com.intellij.vcs.log.ui.table.Selection;
import com.intellij.vcs.log.ui.table.TableWithProgress;
import com.intellij.vcs.log.ui.table.VcsLogCellController;
import com.intellij.vcs.log.ui.table.VcsLogCellRenderer;
import com.intellij.vcs.log.ui.table.VcsLogColumn;
import com.intellij.vcs.log.util.VcsLogUiUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogGraphTable
extends TableWithProgress
implements DataProvider,
CopyProvider {
    private static final Logger LOG = Logger.getInstance(VcsLogGraphTable.class);
    public static final int ROOT_INDICATOR_WHITE_WIDTH = 5;
    private static final int ROOT_INDICATOR_WIDTH = 13;
    private static final int ROOT_NAME_MAX_WIDTH = 300;
    private static final int MAX_DEFAULT_DYNAMIC_COLUMN_WIDTH = 300;
    private static final int MAX_ROWS_TO_CALC_WIDTH = 1000;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final String myId;
    @NotNull
    private final VcsLogUiProperties myProperties;
    @NotNull
    private final VcsLogColorManager myColorManager;
    @NotNull
    private final MyDummyTableCellEditor myDummyEditor = new MyDummyTableCellEditor();
    @NotNull
    private final TableCellRenderer myDummyRenderer = new MyDefaultTableCellRenderer();
    @NotNull
    private final GraphCommitCellRenderer myGraphCommitCellRenderer;
    @NotNull
    private final MyMouseAdapter myMouseAdapter;
    @NotNull
    private final StringCellRenderer myStringCellRenderer;
    @NotNull
    private final List<TableColumn> myTableColumns = new ArrayList<TableColumn>();
    @NotNull
    private final Set<VcsLogColumn> myInitializedColumns = EnumSet.noneOf(VcsLogColumn.class);
    @NotNull
    private final Collection<VcsLogHighlighter> myHighlighters = new ArrayList<VcsLogHighlighter>();
    @Nullable
    private Selection mySelection = null;

    public VcsLogGraphTable(@NotNull String logId, @NotNull VcsLogData logData, @NotNull VcsLogUiProperties uiProperties, @NotNull VcsLogColorManager colorManager, @NotNull Consumer<Runnable> requestMore, @NotNull Disposable disposable) {
        super(new GraphTableModel(logData, requestMore, uiProperties));
        this.myLogData = logData;
        this.myId = logId;
        this.myProperties = uiProperties;
        this.myColorManager = colorManager;
        SimpleGraphCellPainter graphCellPainter = new SimpleGraphCellPainter(new DefaultColorGenerator()){

            @Override
            protected int getRowHeight() {
                return VcsLogGraphTable.this.getRowHeight();
            }
        };
        this.myGraphCommitCellRenderer = new GraphCommitCellRenderer(logData, graphCellPainter, this);
        this.myStringCellRenderer = new StringCellRenderer();
        this.getEmptyText().setText(VcsLogBundle.message((String)"vcs.log.default.status", (Object[])new Object[0]));
        this.myLogData.getProgress().addProgressIndicatorListener(new MyProgressListener(), disposable);
        this.initColumns();
        this.setDefaultRenderer(FilePath.class, new RootCellRenderer(this.myProperties, this.myColorManager));
        this.setDefaultRenderer(GraphCommitCell.class, this.myGraphCommitCellRenderer);
        this.setDefaultRenderer(String.class, (TableCellRenderer)((Object)this.myStringCellRenderer));
        this.setShowVerticalLines(false);
        this.setShowHorizontalLines(false);
        this.setIntercellSpacing((Dimension)JBUI.emptySize());
        this.setTableHeader((JTableHeader)new JBTable.InvisibleResizableHeader(){

            protected boolean canMoveOrResizeColumn(int modelIndex) {
                return modelIndex != VcsLogColumn.ROOT.ordinal();
            }
        });
        this.myMouseAdapter = new MyMouseAdapter();
        this.addMouseMotionListener(this.myMouseAdapter);
        this.addMouseListener(this.myMouseAdapter);
        this.getSelectionModel().addListSelectionListener(e -> {
            this.mySelection = null;
        });
        this.getColumnModel().setColumnSelectionAllowed(false);
        ScrollingUtil.installActions((JTable)((Object)this), (boolean)false);
        new IndexSpeedSearch(this.myLogData.getProject(), this.myLogData.getIndex(), this){

            @Override
            protected boolean isSpeedSearchEnabled() {
                return VcsLogGraphTable.this.isSpeedSearchEnabled() && super.isSpeedSearchEnabled();
            }
        };
    }

    private void initColumns() {
        this.setColumnModel(new MyTableColumnModel(this.myProperties));
        this.createDefaultColumnsFromModel();
        ContainerUtil.addAll(this.myTableColumns, this.getColumnModel().getColumns());
        this.setAutoCreateColumnsFromModel(false);
        this.onColumnOrderSettingChanged();
        this.setRootColumnSize();
        for (TableColumn column : this.myTableColumns) {
            column.setResizable(column.getModelIndex() != VcsLogColumn.ROOT.ordinal());
        }
    }

    protected boolean isSpeedSearchEnabled() {
        return Registry.is((String)"vcs.log.speedsearch");
    }

    protected void updateEmptyText() {
        this.getEmptyText().setText(VcsLogBundle.message((String)"vcs.log.default.status", (Object[])new Object[0]));
    }

    protected void setErrorEmptyText(@NotNull Throwable error, @Nls @NotNull String defaultText) {
        String message = (String)ObjectUtils.chooseNotNull((Object)error.getMessage(), (Object)defaultText);
        message = StringUtil.shortenTextWithEllipsis((String)message, (int)150, (int)0, (boolean)true).replace('\n', ' ');
        this.getEmptyText().setText(message);
    }

    protected void appendActionToEmptyText(@Nls @NotNull String text2, @NotNull Runnable action) {
        this.getEmptyText().appendSecondaryText(text2, VcsLogUiUtil.getLinkAttributes(), e -> action.run());
    }

    public void updateDataPack(@NotNull VisiblePack visiblePack, boolean permGraphChanged) {
        boolean filtersChanged = !this.getModel().getVisiblePack().getFilters().equals(visiblePack.getFilters());
        Selection previousSelection = this.getSelection();
        this.getModel().setVisiblePack(visiblePack);
        previousSelection.restore(visiblePack.getVisibleGraph(), true, permGraphChanged);
        for (VcsLogHighlighter highlighter : this.myHighlighters) {
            highlighter.update((VcsLogDataPack)visiblePack, permGraphChanged);
        }
        if (!this.getEmptyText().getText().equals(VcsLogBundle.message((String)"vcs.log.loading.status", (Object[])new Object[0]))) {
            this.updateEmptyText();
        }
        this.setPaintBusy(false);
        if (filtersChanged) {
            this.myInitializedColumns.clear();
        }
        this.reLayout();
    }

    public void onColumnOrderSettingChanged() {
        TableColumnModel columnModel = this.getColumnModel();
        List<Integer> columnOrder = this.getColumnOrderFromProperties();
        if (columnOrder != null) {
            int columnCount = this.getVisibleColumnCount();
            for (int i = columnCount - 1; i >= 0; --i) {
                columnModel.removeColumn(columnModel.getColumn(i));
            }
            for (Integer expectedColumnIndex : columnOrder) {
                columnModel.addColumn(this.myTableColumns.get(expectedColumnIndex));
            }
        }
        this.reLayout();
    }

    @Nullable
    private List<Integer> getColumnOrderFromProperties() {
        if (!this.myProperties.exists(CommonUiProperties.COLUMN_ORDER)) {
            return null;
        }
        List<Integer> columnOrder = this.myProperties.get(CommonUiProperties.COLUMN_ORDER);
        if (VcsLogColumn.isValidColumnOrder(columnOrder)) {
            return columnOrder;
        }
        LOG.debug("Incorrect column order was saved in properties " + columnOrder + ", replacing it with default order.");
        this.saveColumnOrderToSettings();
        return null;
    }

    private void saveColumnOrderToSettings() {
        if (this.myProperties.exists(CommonUiProperties.COLUMN_ORDER)) {
            this.myProperties.set(CommonUiProperties.COLUMN_ORDER, this.getVisibleColumns());
        }
    }

    @NotNull
    private List<Integer> getVisibleColumns() {
        ArrayList<Integer> columnOrder = new ArrayList<Integer>();
        for (int i = 0; i < this.getVisibleColumnCount(); ++i) {
            columnOrder.add(this.getColumnModel().getColumn(i).getModelIndex());
        }
        return columnOrder;
    }

    private int getVisibleColumnCount() {
        return this.getColumnModel().getColumnCount();
    }

    public void reLayout() {
        if (this.getTableHeader().getResizingColumn() == null) {
            this.updateDynamicColumnsWidth();
            super.doLayout();
            this.repaint();
        }
    }

    public void forceReLayout(@NotNull VcsLogColumn column) {
        this.myInitializedColumns.remove((Object)column);
        this.reLayout();
    }

    public void doLayout() {
        if (this.getTableHeader().getResizingColumn() == null) {
            this.updateDynamicColumnsWidth();
        }
        super.doLayout();
    }

    private void resetColumnWidth(@NotNull VcsLogColumn column) {
        VcsLogUsageTriggerCollector.triggerUsage(VcsLogUsageTriggerCollector.VcsLogEvent.COLUMN_RESET, null);
        if (CommonUiProperties.getColumnWidth(this.myProperties, column) != -1) {
            CommonUiProperties.saveColumnWidth(this.myProperties, column, -1);
        } else {
            this.forceReLayout(column);
        }
    }

    private void updateDynamicColumnsWidth() {
        for (VcsLogColumn logColumn : VcsLogColumn.DYNAMIC_COLUMNS) {
            TableColumn column = this.getTableColumn(logColumn);
            if (column == null) continue;
            int width = CommonUiProperties.getColumnWidth(this.myProperties, logColumn);
            if (width <= 0 || width > this.getWidth()) {
                width = logColumn.getContentSample() != null || !this.myInitializedColumns.contains((Object)logColumn) ? this.getColumnWidthFromData(column) : -1;
            }
            if (width <= 0 || width == column.getPreferredWidth()) continue;
            column.setPreferredWidth(width);
        }
        int size = this.getWidth();
        for (VcsLogColumn logColumn : VcsLogColumn.values()) {
            TableColumn column;
            if (logColumn == VcsLogColumn.COMMIT || (column = this.getTableColumn(logColumn)) == null) continue;
            size -= column.getPreferredWidth();
        }
        this.getCommitColumn().setPreferredWidth(size);
    }

    private int getColumnWidthFromData(@NotNull TableColumn column) {
        int index = column.getModelIndex();
        VcsLogColumn logColumn = VcsLogColumn.fromOrdinal(index);
        String contentSample = logColumn.getContentSample();
        if (contentSample != null) {
            return this.getFontMetrics(VcsLogGraphTable.getTableFont().deriveFont(1)).stringWidth(contentSample) + VcsLogUiUtil.getHorizontalTextPadding((SimpleColoredComponent)this.myStringCellRenderer);
        }
        if (this.getModel().getRowCount() <= 0 || logColumn.getContentClass() != String.class) {
            return column.getPreferredWidth();
        }
        Font tableFont = VcsLogGraphTable.getTableFont();
        int maxRowsToCheck = Math.min(1000, this.getRowCount());
        int maxValueWidth = 0;
        int unloaded = 0;
        for (int row2 = 0; row2 < maxRowsToCheck; ++row2) {
            String value = this.getModel().getValueAt(row2, logColumn).toString();
            if (value.isEmpty()) {
                ++unloaded;
                continue;
            }
            Font font = tableFont;
            VcsLogHighlighter.TextStyle style = this.getStyle(row2, this.getColumnViewIndex(logColumn), false, false).getTextStyle();
            if (VcsLogHighlighter.TextStyle.BOLD.equals((Object)style)) {
                font = tableFont.deriveFont(1);
            } else if (VcsLogHighlighter.TextStyle.ITALIC.equals((Object)style)) {
                font = tableFont.deriveFont(2);
            }
            maxValueWidth = Math.max(this.getFontMetrics(font).stringWidth(value + "*"), maxValueWidth);
        }
        int width = Math.min(maxValueWidth + VcsLogUiUtil.getHorizontalTextPadding((SimpleColoredComponent)this.myStringCellRenderer), JBUIScale.scale((int)300));
        if (unloaded * 2 <= maxRowsToCheck) {
            this.myInitializedColumns.add(logColumn);
        }
        return width;
    }

    @Nullable
    public VcsLogColumn getVcsLogColumn(int viewIndex) {
        int index = this.convertColumnIndexToModel(viewIndex);
        return index < 0 ? null : VcsLogColumn.fromOrdinal(index);
    }

    public final int getColumnViewIndex(@NotNull VcsLogColumn column) {
        return this.convertColumnIndexToView(column.ordinal());
    }

    @Nullable
    public TableColumn getTableColumn(@NotNull VcsLogColumn column) {
        int viewIndex = this.getColumnViewIndex(column);
        return viewIndex != -1 ? this.getColumnModel().getColumn(viewIndex) : null;
    }

    @NotNull
    public TableColumn getRootColumn() {
        return Objects.requireNonNull(this.getTableColumn(VcsLogColumn.ROOT));
    }

    @NotNull
    public TableColumn getCommitColumn() {
        return Objects.requireNonNull(this.getTableColumn(VcsLogColumn.COMMIT));
    }

    @Nullable
    private VcsLogCellController getController(@NotNull VcsLogColumn column) {
        TableColumn tableColumn = this.getTableColumn(column);
        if (tableColumn == null) {
            return null;
        }
        TableCellRenderer renderer = this.getDefaultRenderer(column.getContentClass());
        if (!(renderer instanceof VcsLogCellRenderer)) {
            return null;
        }
        return ((VcsLogCellRenderer)((Object)renderer)).getCellController();
    }

    @NotNull
    Point getPointInCell(@NotNull Point clickPoint, @NotNull VcsLogColumn vcsLogColumn) {
        TableColumn column;
        int width = 0;
        for (int i = 0; i < this.getColumnModel().getColumnCount() && (column = this.getColumnModel().getColumn(i)).getModelIndex() != vcsLogColumn.ordinal(); ++i) {
            width += column.getWidth();
        }
        return new Point(clickPoint.x - width, PositionUtil.getYInsideRow(clickPoint, this.getRowHeight()));
    }

    int getColumnLeftXCoordinate(int viewColumnIndex) {
        int x = 0;
        for (int i = 0; i < viewColumnIndex; ++i) {
            x += this.getColumnModel().getColumn(i).getWidth();
        }
        return x;
    }

    private void setRootColumnSize() {
        int rootWidth;
        TableColumn column = this.getRootColumn();
        if (!this.myColorManager.hasMultiplePaths()) {
            rootWidth = 0;
        } else if (!this.isShowRootNames()) {
            rootWidth = JBUIScale.scale((int)13);
        } else {
            int width = 0;
            for (FilePath file : this.myColorManager.getPaths()) {
                Font tableFont = VcsLogGraphTable.getTableFont();
                width = Math.max(this.getFontMetrics(tableFont).stringWidth(file.getName() + "  "), width);
            }
            rootWidth = Math.min(width, JBUIScale.scale((int)300));
        }
        column.setMinWidth(rootWidth);
        column.setMaxWidth(rootWidth);
        column.setPreferredWidth(rootWidth);
    }

    public void rootColumnUpdated() {
        this.setRootColumnSize();
        this.reLayout();
        this.repaint();
    }

    public String getToolTipText(@NotNull MouseEvent event) {
        Object path2;
        int row2 = this.rowAtPoint(event.getPoint());
        VcsLogColumn column = this.getVcsLogColumn(this.columnAtPoint(event.getPoint()));
        if (column == null || row2 < 0) {
            return null;
        }
        if (column == VcsLogColumn.ROOT && (path2 = this.getValueAt(row2, column.ordinal())) instanceof FilePath) {
            String clickMessage = this.isShowRootNames() ? VcsLogBundle.message((String)"vcs.log.click.to.collapse.paths.column.tooltip", (Object[])new Object[0]) : VcsLogBundle.message((String)"vcs.log.click.to.expand.paths.column.tooltip", (Object[])new Object[0]);
            return "<html><b>" + this.myColorManager.getLongName((FilePath)path2) + "</b><br/>" + clickMessage + "</html>";
        }
        return null;
    }

    private boolean isShowRootNames() {
        return this.myProperties.exists(CommonUiProperties.SHOW_ROOT_NAMES) && this.myProperties.get(CommonUiProperties.SHOW_ROOT_NAMES) != false;
    }

    public void jumpToRow(int rowIndex) {
        if (rowIndex >= 0 && rowIndex <= this.getRowCount() - 1) {
            this.scrollRectToVisible(this.getCellRect(rowIndex, 0, false));
            this.setRowSelectionInterval(rowIndex, rowIndex);
            if (!this.hasFocus()) {
                IdeFocusManager.getInstance((Project)this.myLogData.getProject()).requestFocus((Component)((Object)this), true);
            }
        }
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        return ValueKey.match((String)dataId).ifEq((ValueKey)PlatformDataKeys.COPY_PROVIDER).then((Object)this).ifEq((ValueKey)VcsDataKeys.VCS).thenGet(() -> {
            int[] selectedRows = this.getSelectedRows();
            if (selectedRows.length == 0 || selectedRows.length > 1000) {
                return null;
            }
            Set roots = ContainerUtil.map2Set((Collection)Ints.asList((int[])selectedRows), row2 -> this.getModel().getRootAtRow((int)row2));
            if (roots.size() == 1) {
                return this.myLogData.getLogProvider((VirtualFile)Objects.requireNonNull(ContainerUtil.getFirstItem((Collection)roots))).getSupportedVcs();
            }
            return null;
        }).ifEq((ValueKey)VcsLogDataKeys.VCS_LOG_BRANCHES).thenGet(() -> {
            int[] selectedRows = this.getSelectedRows();
            if (selectedRows.length != 1) {
                return null;
            }
            return this.getModel().getBranchesAtRow(selectedRows[0]);
        }).ifEq((ValueKey)VcsLogDataKeys.VCS_LOG_REFS).thenGet(() -> {
            int[] selectedRows = this.getSelectedRows();
            if (selectedRows.length != 1) {
                return null;
            }
            return this.getModel().getRefsAtRow(selectedRows[0]);
        }).ifEq((ValueKey)VcsDataKeys.PRESET_COMMIT_MESSAGE).thenGet(() -> {
            int[] selectedRows = this.getSelectedRows();
            if (selectedRows.length == 0) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < Math.min(1000, selectedRows.length); ++i) {
                sb.append(this.getModel().getValueAt(selectedRows[i], VcsLogColumn.COMMIT).toString());
                if (i == selectedRows.length - 1) continue;
                sb.append("\n");
            }
            return sb.toString();
        }).orNull();
    }

    public void performCopy(@NotNull DataContext dataContext) {
        StringBuilder sb = new StringBuilder();
        List<Integer> visibleColumns = this.getVisibleColumns();
        int[] selectedRows = this.getSelectedRows();
        for (int i = 0; i < Math.min(1000, selectedRows.length); ++i) {
            int row2 = selectedRows[i];
            sb.append(StringUtil.join(visibleColumns, j -> {
                if (j.intValue() == VcsLogColumn.ROOT.ordinal()) {
                    return "";
                }
                return this.getModel().getValueAt(row2, (int)j).toString();
            }, (String)" "));
            if (i == selectedRows.length - 1) continue;
            sb.append("\n");
        }
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(sb.toString()));
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        return this.getSelectedRowCount() > 0;
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        return true;
    }

    public void addHighlighter(@NotNull VcsLogHighlighter highlighter) {
        this.myHighlighters.add(highlighter);
    }

    public void removeHighlighter(@NotNull VcsLogHighlighter highlighter) {
        this.myHighlighters.remove(highlighter);
    }

    public void removeAllHighlighters() {
        this.myHighlighters.clear();
    }

    @NotNull
    public SimpleTextAttributes applyHighlighters(@NotNull Component rendererComponent, int row2, int column, boolean hasFocus, boolean selected) {
        VcsLogHighlighter.VcsCommitStyle style = this.getStyle(row2, column, hasFocus, selected);
        assert (style.getBackground() != null && style.getForeground() != null && style.getTextStyle() != null);
        rendererComponent.setBackground(style.getBackground());
        rendererComponent.setForeground(style.getForeground());
        switch (style.getTextStyle()) {
            case BOLD: {
                return SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
            }
            case ITALIC: {
                return SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES;
            }
        }
        return SimpleTextAttributes.REGULAR_ATTRIBUTES;
    }

    @NotNull
    public VcsLogHighlighter.VcsCommitStyle getBaseStyle(int row2, int column, boolean hasFocus, boolean selected) {
        Component dummyRendererComponent = this.myDummyRenderer.getTableCellRendererComponent((JTable)((Object)this), "", selected, hasFocus, row2, column);
        return VcsCommitStyleFactory.createStyle((Color)dummyRendererComponent.getForeground(), (Color)dummyRendererComponent.getBackground(), (VcsLogHighlighter.TextStyle)VcsLogHighlighter.TextStyle.NORMAL);
    }

    @NotNull
    VcsLogHighlighter.VcsCommitStyle getStyle(int row2, int column, boolean hasFocus, boolean selected) {
        VcsLogHighlighter.VcsCommitStyle baseStyle = this.getBaseStyle(row2, column, hasFocus, selected);
        VisibleGraph<Integer> visibleGraph = this.getVisibleGraph();
        if (row2 < 0 || row2 >= visibleGraph.getVisibleCommitCount()) {
            LOG.error("Visible graph has " + visibleGraph.getVisibleCommitCount() + " commits, yet we want row " + row2);
            return baseStyle;
        }
        RowInfo rowInfo = visibleGraph.getRowInfo(row2);
        VcsLogHighlighter.VcsCommitStyle defaultStyle = VcsCommitStyleFactory.createStyle((Color)(rowInfo.getRowType() == RowType.UNMATCHED ? JBColor.GRAY : baseStyle.getForeground()), (Color)baseStyle.getBackground(), (VcsLogHighlighter.TextStyle)VcsLogHighlighter.TextStyle.NORMAL);
        int commitId = (Integer)rowInfo.getCommit();
        Object details = this.myLogData.getMiniDetailsGetter().getCommitDataIfAvailable(commitId);
        if (details == null) {
            return defaultStyle;
        }
        List styles = ContainerUtil.map(this.myHighlighters, highlighter -> highlighter.getStyle(commitId, details, selected));
        return VcsCommitStyleFactory.combine((Collection)ContainerUtil.append((List)styles, (Object[])new VcsLogHighlighter.VcsCommitStyle[]{defaultStyle}));
    }

    public void viewportSet(JViewport viewport) {
        viewport.addChangeListener(e -> {
            if (this.isShowRootNames()) {
                GraphTableModel model = this.getModel();
                Couple visibleRows = ScrollingUtil.getVisibleRows((JTable)((Object)this));
                if ((Integer)visibleRows.first >= 0) {
                    TableModelEvent evt = new TableModelEvent(model, (Integer)visibleRows.first, (Integer)visibleRows.second, VcsLogColumn.ROOT.ordinal());
                    model.fireTableChanged(evt);
                }
            }
            this.mySelection = null;
        });
    }

    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
        Component layeredPane = ComponentUtil.findParentByCondition((Component)((Object)this), component -> component instanceof LoadingDecorator.CursorAware);
        if (layeredPane != null) {
            layeredPane.setCursor(cursor);
        }
    }

    @NotNull
    public GraphTableModel getModel() {
        return (GraphTableModel)super.getModel();
    }

    @NotNull
    public Selection getSelection() {
        if (this.mySelection == null) {
            this.mySelection = new Selection(this);
        }
        return this.mySelection;
    }

    public void handleAnswer(@NotNull GraphAnswer<Integer> answer) {
        GraphCommitCellController controller = (GraphCommitCellController)Objects.requireNonNull(this.getController(VcsLogColumn.COMMIT));
        Cursor cursor = controller.handleGraphAnswer(answer, true, null, null);
        this.myMouseAdapter.handleCursor(cursor);
    }

    public void showTooltip(int row2, @NotNull VcsLogColumn column) {
        if (column != VcsLogColumn.COMMIT) {
            return;
        }
        GraphCommitCellController controller = (GraphCommitCellController)Objects.requireNonNull(this.getController(column));
        controller.showTooltip(row2);
    }

    public void setCompactReferencesView(boolean compact) {
        this.myGraphCommitCellRenderer.setCompactReferencesView(compact);
        this.repaint();
    }

    public void setShowTagNames(boolean showTagsNames) {
        this.myGraphCommitCellRenderer.setShowTagsNames(showTagsNames);
        this.repaint();
    }

    public void setLabelsLeftAligned(boolean leftAligned) {
        this.myGraphCommitCellRenderer.setLeftAligned(leftAligned);
        this.repaint();
    }

    @NotNull
    public VisibleGraph<Integer> getVisibleGraph() {
        return this.getModel().getVisiblePack().getVisibleGraph();
    }

    public TableCellEditor getCellEditor() {
        return this.myDummyEditor;
    }

    public int getRowHeight() {
        return this.myGraphCommitCellRenderer.getPreferredHeight();
    }

    @Override
    protected void paintFooter(@NotNull Graphics g, int x, int y, int width, int height) {
        this.paintTopBottomBorder(g, x, y, width, height, false);
    }

    private void paintTopBottomBorder(@NotNull Graphics g, int x, int y, int width, int height, boolean isTopBorder) {
        int targetRow;
        int n = targetRow = isTopBorder ? 0 : this.getRowCount() - 1;
        if (targetRow >= 0 && targetRow < this.getRowCount()) {
            g.setColor(this.getStyle(targetRow, this.getColumnViewIndex(VcsLogColumn.COMMIT), this.hasFocus(), false).getBackground());
            g.fillRect(x, y, width, height);
            if (this.myColorManager.hasMultiplePaths()) {
                g.setColor((Color)VcsLogGraphTable.getPathBackgroundColor((FilePath)this.getModel().getValueAt(targetRow, VcsLogColumn.ROOT), this.myColorManager));
                int rootWidth = this.getRootColumn().getWidth();
                if (!this.isShowRootNames()) {
                    rootWidth -= JBUIScale.scale((int)5);
                }
                g.fillRect(x, y, rootWidth, height);
            }
        } else {
            g.setColor(this.getBaseStyle(targetRow, this.getColumnViewIndex(VcsLogColumn.COMMIT), this.hasFocus(), false).getBackground());
            g.fillRect(x, y, width, height);
        }
    }

    @NotNull
    public Border createTopBottomBorder(int top, int bottom) {
        return new MyTopBottomBorder(top, bottom);
    }

    public boolean isResizingColumns() {
        return this.getCursor() == Cursor.getPredefinedCursor(11);
    }

    @NotNull
    public static JBColor getRootBackgroundColor(@NotNull VirtualFile root, @NotNull VcsLogColorManager colorManager) {
        return VcsLogColorManagerImpl.getBackgroundColor(colorManager.getRootColor(root));
    }

    @NotNull
    public static JBColor getPathBackgroundColor(@NotNull FilePath filePath, @NotNull VcsLogColorManager colorManager) {
        return VcsLogColorManagerImpl.getBackgroundColor(colorManager.getPathColor(filePath));
    }

    static Font getTableFont() {
        return UIManager.getFont("Table.font");
    }

    private class MyTopBottomBorder
    implements Border {
        @NotNull
        private final JBInsets myInsets;

        private MyTopBottomBorder(int top, int bottom) {
            this.myInsets = JBUI.insets((int)top, (int)0, (int)bottom, (int)0);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (this.myInsets.top > 0) {
                VcsLogGraphTable.this.paintTopBottomBorder(g, x, y, width, this.myInsets.top, true);
            }
            if (this.myInsets.bottom > 0) {
                VcsLogGraphTable.this.paintTopBottomBorder(g, x, y + height - this.myInsets.bottom, width, this.myInsets.bottom, false);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.myInsets;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }

    private class MyTableColumnModel
    extends DefaultTableColumnModel {
        @NotNull
        private final VcsLogUiProperties myProperties;

        MyTableColumnModel(VcsLogUiProperties properties) {
            this.myProperties = properties;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (VcsLogGraphTable.this.getTableHeader().getResizingColumn() == null) {
                return;
            }
            if ("width".equals(evt.getPropertyName())) {
                for (VcsLogColumn logColumn : VcsLogColumn.DYNAMIC_COLUMNS) {
                    TableColumn column = VcsLogGraphTable.this.getTableColumn(logColumn);
                    if (!evt.getSource().equals(column)) continue;
                    CommonUiProperties.saveColumnWidth(this.myProperties, logColumn, column.getWidth());
                }
            }
            super.propertyChange(evt);
        }

        @Override
        public void moveColumn(int columnIndex, int newIndex) {
            if (VcsLogGraphTable.this.getVcsLogColumn(columnIndex) == VcsLogColumn.ROOT || VcsLogGraphTable.this.getVcsLogColumn(newIndex) == VcsLogColumn.ROOT) {
                return;
            }
            super.moveColumn(columnIndex, newIndex);
            VcsLogGraphTable.this.saveColumnOrderToSettings();
        }
    }

    private class MyProgressListener
    implements VcsLogProgress.ProgressListener {
        private MyProgressListener() {
        }

        @Override
        public void progressStarted(@NotNull Collection<? extends VcsLogProgress.ProgressKey> keys) {
            this.progressChanged(keys);
        }

        @Override
        public void progressChanged(@NotNull Collection<? extends VcsLogProgress.ProgressKey> keys) {
            if (VcsLogUiUtil.isProgressVisible(keys, VcsLogGraphTable.this.myId)) {
                VcsLogGraphTable.this.getEmptyText().setText(VcsLogBundle.message((String)"vcs.log.loading.status", (Object[])new Object[0]));
            } else {
                VcsLogGraphTable.this.updateEmptyText();
            }
        }

        @Override
        public void progressStopped() {
            VcsLogGraphTable.this.updateEmptyText();
        }
    }

    private class MyDummyTableCellEditor
    implements TableCellEditor {
        private MyDummyTableCellEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row2, int column) {
            return null;
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return false;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            if (!(anEvent instanceof MouseEvent)) {
                return true;
            }
            MouseEvent e = (MouseEvent)anEvent;
            int row2 = VcsLogGraphTable.this.rowAtPoint(e.getPoint());
            if (row2 < 0 || row2 >= VcsLogGraphTable.this.getRowCount()) {
                return true;
            }
            VcsLogColumn column = VcsLogGraphTable.this.getVcsLogColumn(VcsLogGraphTable.this.columnAtPoint(e.getPoint()));
            if (column == null) {
                return true;
            }
            VcsLogCellController controller = VcsLogGraphTable.this.getController(column);
            if (controller == null) {
                return true;
            }
            return controller.shouldSelectCell(row2, e);
        }

        @Override
        public boolean stopCellEditing() {
            return false;
        }

        @Override
        public void cancelCellEditing() {
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
        }
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        private static final int BORDER_THICKNESS = 3;
        @NotNull
        private final TableLinkMouseListener myLinkListener = new MyLinkMouseListener();
        @Nullable
        private Cursor myLastCursor = null;

        private MyMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            VcsLogCellController controller;
            int row2;
            if (this.myLinkListener.onClick(e, e.getClickCount())) {
                return;
            }
            int c = VcsLogGraphTable.this.columnAtPoint(e.getPoint());
            VcsLogColumn column = VcsLogGraphTable.this.getVcsLogColumn(c);
            if (column == null) {
                return;
            }
            if (e.getClickCount() == 2) {
                boolean useLeftBorder;
                int commitColumnIndex = VcsLogGraphTable.this.getColumnViewIndex(VcsLogColumn.COMMIT);
                boolean bl = useLeftBorder = c > commitColumnIndex;
                if ((useLeftBorder ? this.isOnLeftBorder(e, c) : this.isOnRightBorder(e, c)) && column.isDynamic()) {
                    VcsLogGraphTable.this.resetColumnWidth(column);
                } else {
                    int c2 = VcsLogGraphTable.this.columnAtPoint(new Point(e.getPoint().x + (useLeftBorder ? 1 : -1) * JBUIScale.scale((int)3), e.getPoint().y));
                    VcsLogColumn column2 = VcsLogGraphTable.this.getVcsLogColumn(c2);
                    if (column2 != null && (useLeftBorder ? this.isOnLeftBorder(e, c2) : this.isOnRightBorder(e, c2)) && column2.isDynamic()) {
                        VcsLogGraphTable.this.resetColumnWidth(column2);
                    }
                }
            }
            if ((row2 = VcsLogGraphTable.this.rowAtPoint(e.getPoint())) >= 0 && row2 < VcsLogGraphTable.this.getRowCount() && e.getClickCount() == 1 && (controller = VcsLogGraphTable.this.getController(column)) != null) {
                Cursor cursor = controller.performMouseClick(row2, e);
                this.handleCursor(cursor);
            }
        }

        public boolean isOnLeftBorder(@NotNull MouseEvent e, int column) {
            return Math.abs(VcsLogGraphTable.this.getColumnLeftXCoordinate(column) - e.getPoint().x) <= JBUIScale.scale((int)3);
        }

        public boolean isOnRightBorder(@NotNull MouseEvent e, int column) {
            return Math.abs(VcsLogGraphTable.this.getColumnLeftXCoordinate(column) + VcsLogGraphTable.this.getColumnModel().getColumn(column).getWidth() - e.getPoint().x) <= JBUIScale.scale((int)3);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (VcsLogGraphTable.this.getRowCount() == 0) {
                return;
            }
            if (VcsLogGraphTable.this.isResizingColumns()) {
                return;
            }
            VcsLogGraphTable.this.getExpandableItemsHandler().setEnabled(true);
            if (this.myLinkListener.getTagAt(e) != null) {
                this.swapCursor();
                return;
            }
            int row2 = VcsLogGraphTable.this.rowAtPoint(e.getPoint());
            if (row2 >= 0 && row2 < VcsLogGraphTable.this.getRowCount()) {
                VcsLogColumn column = VcsLogGraphTable.this.getVcsLogColumn(VcsLogGraphTable.this.columnAtPoint(e.getPoint()));
                if (column == null) {
                    return;
                }
                VcsLogCellController controller = VcsLogGraphTable.this.getController(column);
                if (controller != null) {
                    Cursor cursor = controller.performMouseMove(row2, e);
                    this.handleCursor(cursor);
                    return;
                }
            }
            this.restoreCursor();
        }

        private void handleCursor(@Nullable Cursor cursor) {
            if (cursor != null) {
                if (cursor.getType() == 0) {
                    this.restoreCursor();
                } else if (cursor.getType() == 12) {
                    this.swapCursor();
                }
            }
        }

        private void swapCursor() {
            if (VcsLogGraphTable.this.getCursor().getType() != 12 && this.myLastCursor == null) {
                Cursor newCursor = Cursor.getPredefinedCursor(12);
                this.myLastCursor = VcsLogGraphTable.this.getCursor();
                VcsLogGraphTable.this.setCursor(newCursor);
            }
        }

        private void restoreCursor() {
            if (VcsLogGraphTable.this.getCursor().getType() != 0) {
                VcsLogGraphTable.this.setCursor(UIUtil.cursorIfNotDefault((Cursor)this.myLastCursor));
                this.myLastCursor = null;
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            VcsLogGraphTable.this.getExpandableItemsHandler().setEnabled(true);
        }

        private class MyLinkMouseListener
        extends SimpleColoredComponentLinkMouseListener {
            private MyLinkMouseListener() {
            }

            @Override
            @Nullable
            public Object getTagAt(@NotNull MouseEvent e) {
                return ObjectUtils.tryCast((Object)super.getTagAt(e), SimpleColoredComponent.BrowserLauncherTag.class);
            }
        }
    }

    private class StringCellRenderer
    extends ColoredTableCellRenderer {
        private StringCellRenderer() {
            this.setCellState(new GraphCommitCellRenderer.BorderlessTableCellState());
        }

        protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row2, int column) {
            if (value == null) {
                return;
            }
            this.append(value.toString(), VcsLogGraphTable.this.applyHighlighters((Component)((Object)this), row2, column, hasFocus, selected));
            if (column == VcsLogGraphTable.this.getColumnViewIndex(VcsLogColumn.COMMIT) || column == VcsLogGraphTable.this.getColumnViewIndex(VcsLogColumn.AUTHOR)) {
                SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)table, (SimpleColoredComponent)this, (boolean)false, (boolean)selected);
            }
        }
    }

    private static class MyDefaultTableCellRenderer
    extends DefaultTableCellRenderer {
        private MyDefaultTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row2, int column) {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row2, column);
            component.setBackground(isSelected ? (table.hasFocus() ? UIUtil.getListSelectionBackground((boolean)true) : UIUtil.getListSelectionBackground((boolean)false)) : UIUtil.getListBackground());
            return component;
        }
    }
}

