/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.text.DateTimeFormatManager;
import com.intellij.util.text.JBDateFormat;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.ui.render.GraphCommitCell;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum VcsLogColumn {
    ROOT("", (Class)FilePath.class){

        @Override
        public String getLocalizedName() {
            return "";
        }
    }
    ,
    COMMIT("Subject", (Class)GraphCommitCell.class){

        @Override
        public String getLocalizedName() {
            return VcsLogBundle.message((String)"vcs.log.column.subject", (Object[])new Object[0]);
        }
    }
    ,
    AUTHOR("Author", (Class)String.class){

        @Override
        public String getLocalizedName() {
            return VcsLogBundle.message((String)"vcs.log.column.author", (Object[])new Object[0]);
        }
    }
    ,
    DATE("Date", (Class)String.class){

        @Override
        public String getLocalizedName() {
            return VcsLogBundle.message((String)"vcs.log.column.date", (Object[])new Object[0]);
        }

        @Override
        public String getContentSample() {
            if (DateTimeFormatManager.getInstance().isPrettyFormattingAllowed()) {
                return null;
            }
            return JBDateFormat.getFormatter().formatDateTime(DateFormatUtil.getSampleDateTime());
        }
    }
    ,
    HASH("Hash", (Class)String.class){

        @Override
        public String getLocalizedName() {
            return VcsLogBundle.message((String)"vcs.log.column.hash", (Object[])new Object[0]);
        }

        @Override
        public String getContentSample() {
            return StringUtil.repeat((String)"e", (int)8);
        }
    };

    @NotNull
    public static final List<VcsLogColumn> DYNAMIC_COLUMNS;
    private static final VcsLogColumn @NotNull [] COLUMNS;
    @NotNull
    private final String myName;
    @NotNull
    private final Class<?> myContentClass;

    private VcsLogColumn(String name, Class<?> contentClass) {
        this.myName = name;
        this.myContentClass = contentClass;
    }

    public boolean isDynamic() {
        return DYNAMIC_COLUMNS.contains((Object)this);
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    public abstract String getLocalizedName();

    @NotNull
    public String getStableName() {
        return this.myName.toLowerCase(Locale.ROOT);
    }

    @NotNull
    Class<?> getContentClass() {
        return this.myContentClass;
    }

    @Nullable
    public String getContentSample() {
        return null;
    }

    static boolean isValidColumnOrder(@NotNull List<Integer> columnOrder) {
        int columnCount = VcsLogColumn.count();
        if (!columnOrder.contains(ROOT.ordinal())) {
            return false;
        }
        if (!columnOrder.contains(COMMIT.ordinal())) {
            return false;
        }
        for (Integer index : columnOrder) {
            if (index != null && index >= 0 && index < columnCount) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static VcsLogColumn fromOrdinal(int index) {
        return COLUMNS[index];
    }

    public static int count() {
        return COLUMNS.length;
    }

    static {
        DYNAMIC_COLUMNS = ContainerUtil.immutableList((Object[])new VcsLogColumn[]{AUTHOR, DATE, HASH});
        COLUMNS = VcsLogColumn.values();
    }
}

