/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.AsyncProcessIcon;
import icons.VcsLogIcons;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class TableWithProgress
extends JBTable {
    public TableWithProgress(@NotNull TableModel model) {
        super(model);
    }

    @NotNull
    protected AsyncProcessIcon createBusyIcon() {
        return new LastRowLoadingIcon();
    }

    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (this.isBusy()) {
            return new Dimension(size.width, size.height + this.myBusyIcon.getPreferredSize().height);
        }
        return size;
    }

    protected boolean isBusy() {
        return this.myBusyIcon != null && this.myBusyIcon.isRunning();
    }

    protected void paintComponent(@NotNull Graphics g) {
        super.paintComponent(g);
        if (this.isBusy()) {
            int preferredHeight = super.getPreferredSize().height;
            this.paintFooter(g, 0, preferredHeight, this.getWidth(), this.getHeight() - preferredHeight);
        }
    }

    protected void paintFooter(@NotNull Graphics g, int x, int y, int width, int height) {
        g.setColor(this.getBackground());
        g.fillRect(x, y, width, height);
    }

    private class LastRowLoadingIcon
    extends AsyncProcessIcon {
        LastRowLoadingIcon() {
            super(TableWithProgress.this.toString(), new Icon[]{VcsLogIcons.Process.Dots_2, VcsLogIcons.Process.Dots_3, VcsLogIcons.Process.Dots_4, VcsLogIcons.Process.Dots_5}, VcsLogIcons.Process.Dots_1);
        }

        @NotNull
        protected Rectangle calculateBounds(@NotNull JComponent container) {
            Dimension iconSize = this.getPreferredSize();
            return new Rectangle((container.getWidth() - iconSize.width) / 2, container.getPreferredSize().height - iconSize.height, iconSize.width, iconSize.height);
        }
    }
}

